/*     */ package org.jboss.remoting.transport.coyote.ssl;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.IOException;
/*     */ import java.security.cert.CertificateFactory;
/*     */ import javax.net.ssl.SSLSession;
/*     */ import javax.net.ssl.SSLSocket;
/*     */ import org.apache.tomcat.util.net.SSLSupport;
/*     */ import org.apache.tomcat.util.net.SSLSupport.CipherData;
/*     */ 
/*     */ public class RemotingSSLSupport
/*     */   implements SSLSupport
/*     */ {
/*     */   private SSLSocket sslSocket;
/*     */ 
/*     */   public RemotingSSLSupport(SSLSocket socket)
/*     */   {
/*  48 */     this.sslSocket = socket;
/*     */   }
/*     */ 
/*     */   public String getCipherSuite()
/*     */     throws IOException
/*     */   {
/*  56 */     SSLSession session = this.sslSocket.getSession();
/*  57 */     if (session == null)
/*     */     {
/*  59 */       return null;
/*     */     }
/*  61 */     return session.getCipherSuite();
/*     */   }
/*     */ 
/*     */   public Object[] getPeerCertificateChain()
/*     */     throws IOException
/*     */   {
/*  69 */     return getPeerCertificateChain(false);
/*     */   }
/*     */ 
/*     */   public Object[] getPeerCertificateChain(boolean force)
/*     */     throws IOException
/*     */   {
/*  76 */     SSLSession session = this.sslSocket.getSession();
/*  77 */     if (session == null)
/*     */     {
/*  79 */       return null;
/*     */     }
/*     */ 
/*  83 */     javax.security.cert.X509Certificate[] jsseCerts = null;
/*     */     try
/*     */     {
/*  86 */       jsseCerts = session.getPeerCertificateChain();
/*     */     }
/*     */     catch (Exception bex)
/*     */     {
/*     */     }
/*     */ 
/*  92 */     if (jsseCerts == null)
/*     */     {
/*  94 */       jsseCerts = new javax.security.cert.X509Certificate[0];
/*     */     }
/*  96 */     if ((jsseCerts.length <= 0) && (force))
/*     */     {
/*  98 */       session.invalidate();
/*  99 */       handShake();
/* 100 */       session = this.sslSocket.getSession();
/*     */     }
/* 102 */     return getX509Certificates(session);
/*     */   }
/*     */ 
/*     */   protected void handShake()
/*     */     throws IOException
/*     */   {
/* 108 */     this.sslSocket.setNeedClientAuth(true);
/* 109 */     this.sslSocket.startHandshake();
/*     */   }
/*     */ 
/*     */   protected java.security.cert.X509Certificate[] getX509Certificates(SSLSession session) throws IOException
/*     */   {
/* 114 */     javax.security.cert.X509Certificate[] jsseCerts = null;
/*     */     try
/*     */     {
/* 117 */       jsseCerts = session.getPeerCertificateChain();
/*     */     }
/*     */     catch (Throwable ex)
/*     */     {
/*     */     }
/*     */ 
/* 125 */     if (jsseCerts == null)
/*     */     {
/* 127 */       jsseCerts = new javax.security.cert.X509Certificate[0];
/*     */     }
/* 129 */     java.security.cert.X509Certificate[] x509Certs = new java.security.cert.X509Certificate[jsseCerts.length];
/* 130 */     for (int i = 0; i < x509Certs.length; i++)
/*     */     {
/*     */       try
/*     */       {
/* 134 */         byte[] buffer = jsseCerts[i].getEncoded();
/* 135 */         CertificateFactory cf = CertificateFactory.getInstance("X.509");
/* 136 */         ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
/* 137 */         x509Certs[i] = ((java.security.cert.X509Certificate)cf.generateCertificate(stream));
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 141 */         return null;
/*     */       }
/*     */     }
/*     */ 
/* 145 */     if (x509Certs.length < 1)
/*     */     {
/* 147 */       return null;
/*     */     }
/* 149 */     return x509Certs;
/*     */   }
/*     */ 
/*     */   public Integer getKeySize()
/*     */     throws IOException
/*     */   {
/* 169 */     SSLSession session = this.sslSocket.getSession();
/* 170 */     SSLSupport.CipherData[] c_aux = ciphers;
/* 171 */     if (session == null)
/*     */     {
/* 173 */       return null;
/*     */     }
/* 175 */     Integer keySize = (Integer)session.getValue("javax.servlet.request.key_size");
/* 176 */     if (keySize == null)
/*     */     {
/* 178 */       int size = 0;
/* 179 */       String cipherSuite = session.getCipherSuite();
/* 180 */       for (int i = 0; i < c_aux.length; i++)
/*     */       {
/* 182 */         if (cipherSuite.indexOf(c_aux[i].phrase) < 0)
/*     */           continue;
/* 184 */         size = c_aux[i].keySize;
/* 185 */         break;
/*     */       }
/*     */ 
/* 188 */       keySize = new Integer(size);
/* 189 */       session.putValue("javax.servlet.request.key_size", keySize);
/*     */     }
/* 191 */     return keySize;
/*     */   }
/*     */ 
/*     */   public String getSessionId()
/*     */     throws IOException
/*     */   {
/* 200 */     SSLSession session = this.sslSocket.getSession();
/* 201 */     if (session == null)
/*     */     {
/* 203 */       return null;
/*     */     }
/*     */ 
/* 206 */     byte[] ssl_session = session.getId();
/* 207 */     if (ssl_session == null)
/*     */     {
/* 209 */       return null;
/*     */     }
/* 211 */     StringBuffer buf = new StringBuffer("");
/* 212 */     for (int x = 0; x < ssl_session.length; x++)
/*     */     {
/* 214 */       String digit = Integer.toHexString(ssl_session[x]);
/* 215 */       if (digit.length() < 2)
/*     */       {
/* 217 */         buf.append('0');
/*     */       }
/* 219 */       if (digit.length() > 2)
/*     */       {
/* 221 */         digit = digit.substring(digit.length() - 2);
/*     */       }
/* 223 */       buf.append(digit);
/*     */     }
/* 225 */     return buf.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.coyote.ssl.RemotingSSLSupport
 * JD-Core Version:    0.6.0
 */