/*     */ package org.jboss.remoting.transport.coyote;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Writer;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import java.util.HashMap;
/*     */ import org.apache.coyote.ActionCode;
/*     */ import org.apache.coyote.Response;
/*     */ import org.apache.tomcat.util.buf.ByteChunk;
/*     */ import org.apache.tomcat.util.buf.ByteChunk.ByteOutputChannel;
/*     */ import org.apache.tomcat.util.buf.C2BConverter;
/*     */ import org.apache.tomcat.util.buf.CharChunk;
/*     */ import org.apache.tomcat.util.buf.CharChunk.CharOutputChannel;
/*     */ 
/*     */ public class OutputBuffer extends Writer
/*     */   implements ByteChunk.ByteOutputChannel, CharChunk.CharOutputChannel
/*     */ {
/*     */   public static final String DEFAULT_ENCODING = "ISO-8859-1";
/*     */   public static final int DEFAULT_BUFFER_SIZE = 8192;
/*  57 */   public final int INITIAL_STATE = 0;
/*  58 */   public final int CHAR_STATE = 1;
/*  59 */   public final int BYTE_STATE = 2;
/*     */   private ByteChunk bb;
/*     */   private CharChunk cb;
/*  79 */   private int state = 0;
/*     */ 
/*  85 */   private int bytesWritten = 0;
/*     */ 
/*  91 */   private int charsWritten = 0;
/*     */ 
/*  97 */   private boolean closed = false;
/*     */ 
/* 103 */   private boolean doFlush = false;
/*     */ 
/* 109 */   private ByteChunk outputChunk = new ByteChunk();
/*     */   private String enc;
/* 121 */   private boolean gotEnc = false;
/*     */ 
/* 127 */   protected HashMap encoders = new HashMap();
/*     */   protected C2BConverter conv;
/*     */   private Response coyoteResponse;
/* 145 */   private boolean suspended = false;
/*     */ 
/*     */   public OutputBuffer()
/*     */   {
/* 156 */     this(8192);
/*     */   }
/*     */ 
/*     */   public OutputBuffer(int size)
/*     */   {
/* 169 */     this.bb = new ByteChunk(size);
/*     */ 
/* 172 */     this.bb.setLimit(-1);
/* 173 */     this.bb.setByteOutputChannel(this);
/* 174 */     this.cb = new CharChunk(size);
/* 175 */     this.cb.setCharOutputChannel(this);
/* 176 */     this.cb.setLimit(size);
/*     */   }
/*     */ 
/*     */   public void setResponse(Response coyoteResponse)
/*     */   {
/* 190 */     this.coyoteResponse = coyoteResponse;
/*     */   }
/*     */ 
/*     */   public Response getResponse()
/*     */   {
/* 201 */     return this.coyoteResponse;
/*     */   }
/*     */ 
/*     */   public boolean isSuspended()
/*     */   {
/* 212 */     return this.suspended;
/*     */   }
/*     */ 
/*     */   public void setSuspended(boolean suspended)
/*     */   {
/* 223 */     this.suspended = suspended;
/*     */   }
/*     */ 
/*     */   public void recycle()
/*     */   {
/* 235 */     this.state = 0;
/* 236 */     this.bytesWritten = 0;
/* 237 */     this.charsWritten = 0;
/*     */ 
/* 239 */     this.cb.recycle();
/* 240 */     this.bb.recycle();
/* 241 */     this.closed = false;
/* 242 */     this.suspended = false;
/*     */ 
/* 244 */     if (this.conv != null)
/*     */     {
/* 246 */       this.conv.recycle();
/*     */     }
/*     */ 
/* 249 */     this.gotEnc = false;
/* 250 */     this.enc = null;
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws IOException
/*     */   {
/* 265 */     if (this.closed)
/*     */     {
/* 267 */       return;
/*     */     }
/* 269 */     if (this.suspended)
/*     */     {
/* 271 */       return;
/*     */     }
/*     */ 
/* 274 */     if ((!this.coyoteResponse.isCommitted()) && (this.coyoteResponse.getContentLengthLong() == -1L))
/*     */     {
/* 278 */       if (this.state == 1)
/*     */       {
/* 280 */         this.cb.flushBuffer();
/* 281 */         this.state = 2;
/*     */       }
/*     */ 
/* 285 */       if (!this.coyoteResponse.isCommitted())
/*     */       {
/* 287 */         this.coyoteResponse.setContentLength(this.bb.getLength());
/*     */       }
/*     */     }
/*     */ 
/* 291 */     doFlush(false);
/* 292 */     this.closed = true;
/*     */ 
/* 294 */     this.coyoteResponse.finish();
/*     */   }
/*     */ 
/*     */   public void flush()
/*     */     throws IOException
/*     */   {
/* 307 */     doFlush(true);
/*     */   }
/*     */ 
/*     */   protected void doFlush(boolean realFlush)
/*     */     throws IOException
/*     */   {
/* 320 */     if (this.suspended)
/*     */     {
/* 322 */       return;
/*     */     }
/*     */ 
/* 325 */     this.doFlush = true;
/* 326 */     if (this.state == 1)
/*     */     {
/* 328 */       this.cb.flushBuffer();
/* 329 */       this.bb.flushBuffer();
/* 330 */       this.state = 2;
/*     */     }
/* 332 */     else if (this.state == 2)
/*     */     {
/* 334 */       this.bb.flushBuffer();
/*     */     }
/* 336 */     else if (this.state == 0)
/*     */     {
/* 339 */       this.coyoteResponse.sendHeaders();
/*     */     }
/* 341 */     this.doFlush = false;
/*     */ 
/* 343 */     if (realFlush)
/*     */     {
/* 345 */       this.coyoteResponse.action(ActionCode.ACTION_CLIENT_FLUSH, this.coyoteResponse);
/*     */ 
/* 349 */       if (this.coyoteResponse.isExceptionPresent())
/*     */       {
/* 351 */         throw new ClientAbortException(this.coyoteResponse.getErrorException());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void realWriteBytes(byte[] buf, int off, int cnt)
/*     */     throws IOException
/*     */   {
/* 374 */     if (this.closed)
/*     */     {
/* 376 */       return;
/*     */     }
/* 378 */     if (this.coyoteResponse == null)
/*     */     {
/* 380 */       return;
/*     */     }
/*     */ 
/* 384 */     if (cnt > 0)
/*     */     {
/* 387 */       this.outputChunk.setBytes(buf, off, cnt);
/*     */       try
/*     */       {
/* 390 */         this.coyoteResponse.doWrite(this.outputChunk);
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 397 */         throw new ClientAbortException(e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void write(byte[] b, int off, int len)
/*     */     throws IOException
/*     */   {
/* 407 */     if (this.suspended)
/*     */     {
/* 409 */       return;
/*     */     }
/*     */ 
/* 412 */     if (this.state == 1)
/*     */     {
/* 414 */       this.cb.flushBuffer();
/*     */     }
/* 416 */     this.state = 2;
/* 417 */     writeBytes(b, off, len);
/*     */   }
/*     */ 
/*     */   private void writeBytes(byte[] b, int off, int len)
/*     */     throws IOException
/*     */   {
/* 426 */     if (this.closed)
/*     */     {
/* 428 */       return;
/*     */     }
/*     */ 
/* 431 */     this.bb.append(b, off, len);
/* 432 */     this.bytesWritten += len;
/*     */ 
/* 436 */     if (this.doFlush)
/*     */     {
/* 438 */       this.bb.flushBuffer();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeByte(int b)
/*     */     throws IOException
/*     */   {
/* 448 */     if (this.suspended)
/*     */     {
/* 450 */       return;
/*     */     }
/*     */ 
/* 453 */     if (this.state == 1)
/*     */     {
/* 455 */       this.cb.flushBuffer();
/*     */     }
/* 457 */     this.state = 2;
/*     */ 
/* 459 */     this.bb.append((byte)b);
/* 460 */     this.bytesWritten += 1;
/*     */   }
/*     */ 
/*     */   public void write(int c)
/*     */     throws IOException
/*     */   {
/* 471 */     if (this.suspended)
/*     */     {
/* 473 */       return;
/*     */     }
/*     */ 
/* 476 */     this.state = 1;
/*     */ 
/* 478 */     this.cb.append((char)c);
/* 479 */     this.charsWritten += 1;
/*     */   }
/*     */ 
/*     */   public void write(char[] c)
/*     */     throws IOException
/*     */   {
/* 488 */     if (this.suspended)
/*     */     {
/* 490 */       return;
/*     */     }
/*     */ 
/* 493 */     write(c, 0, c.length);
/*     */   }
/*     */ 
/*     */   public void write(char[] c, int off, int len)
/*     */     throws IOException
/*     */   {
/* 502 */     if (this.suspended)
/*     */     {
/* 504 */       return;
/*     */     }
/*     */ 
/* 507 */     this.state = 1;
/*     */ 
/* 509 */     this.cb.append(c, off, len);
/* 510 */     this.charsWritten += len;
/*     */   }
/*     */ 
/*     */   public void write(StringBuffer sb)
/*     */     throws IOException
/*     */   {
/* 519 */     if (this.suspended)
/*     */     {
/* 521 */       return;
/*     */     }
/*     */ 
/* 524 */     this.state = 1;
/*     */ 
/* 526 */     int len = sb.length();
/* 527 */     this.charsWritten += len;
/* 528 */     this.cb.append(sb);
/*     */   }
/*     */ 
/*     */   public void write(String s, int off, int len)
/*     */     throws IOException
/*     */   {
/* 540 */     if (this.suspended)
/*     */     {
/* 542 */       return;
/*     */     }
/*     */ 
/* 545 */     this.state = 1;
/*     */ 
/* 547 */     this.charsWritten += len;
/* 548 */     if (s == null)
/*     */     {
/* 550 */       s = "null";
/*     */     }
/* 552 */     this.cb.append(s, off, len);
/*     */   }
/*     */ 
/*     */   public void write(String s)
/*     */     throws IOException
/*     */   {
/* 561 */     if (this.suspended)
/*     */     {
/* 563 */       return;
/*     */     }
/*     */ 
/* 566 */     this.state = 1;
/* 567 */     if (s == null)
/*     */     {
/* 569 */       s = "null";
/*     */     }
/* 571 */     write(s, 0, s.length());
/*     */   }
/*     */ 
/*     */   public void flushChars()
/*     */     throws IOException
/*     */   {
/* 580 */     this.cb.flushBuffer();
/* 581 */     this.state = 2;
/*     */   }
/*     */ 
/*     */   public boolean flushCharsNeeded()
/*     */   {
/* 588 */     return this.state == 1;
/*     */   }
/*     */ 
/*     */   public void setEncoding(String s)
/*     */   {
/* 594 */     this.enc = s;
/*     */   }
/*     */ 
/*     */   public void realWriteChars(char[] c, int off, int len)
/*     */     throws IOException
/*     */   {
/* 602 */     if (!this.gotEnc)
/*     */     {
/* 604 */       setConverter();
/*     */     }
/*     */ 
/* 607 */     this.conv.convert(c, off, len);
/* 608 */     this.conv.flushBuffer();
/*     */   }
/*     */ 
/*     */   public void checkConverter()
/*     */     throws IOException
/*     */   {
/* 617 */     if (!this.gotEnc)
/*     */     {
/* 619 */       setConverter();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void setConverter()
/*     */     throws IOException
/*     */   {
/* 629 */     if (this.coyoteResponse != null)
/*     */     {
/* 631 */       this.enc = this.coyoteResponse.getCharacterEncoding();
/*     */     }
/*     */ 
/* 634 */     this.gotEnc = true;
/* 635 */     if (this.enc == null)
/*     */     {
/* 637 */       this.enc = "ISO-8859-1";
/*     */     }
/* 639 */     this.conv = ((C2BConverter)this.encoders.get(this.enc));
/* 640 */     if (this.conv == null)
/*     */     {
/* 643 */       if (System.getSecurityManager() != null)
/*     */       {
/*     */         try
/*     */         {
/* 647 */           this.conv = ((C2BConverter)AccessController.doPrivileged(new PrivilegedExceptionAction()
/*     */           {
/*     */             public Object run()
/*     */               throws IOException
/*     */             {
/* 653 */               return new C2BConverter(OutputBuffer.this.bb, OutputBuffer.this.enc);
/*     */             }
/*     */ 
/*     */           }));
/*     */         }
/*     */         catch (PrivilegedActionException ex)
/*     */         {
/* 661 */           Exception e = ex.getException();
/* 662 */           if ((e instanceof IOException))
/*     */           {
/* 664 */             throw ((IOException)e);
/*     */           }
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 670 */         this.conv = new C2BConverter(this.bb, this.enc);
/*     */       }
/*     */ 
/* 673 */       this.encoders.put(this.enc, this.conv);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void flushBytes()
/*     */     throws IOException
/*     */   {
/* 688 */     this.bb.flushBuffer();
/*     */   }
/*     */ 
/*     */   public int getBytesWritten()
/*     */   {
/* 695 */     return this.bytesWritten;
/*     */   }
/*     */ 
/*     */   public int getCharsWritten()
/*     */   {
/* 701 */     return this.charsWritten;
/*     */   }
/*     */ 
/*     */   public int getContentWritten()
/*     */   {
/* 707 */     return this.bytesWritten + this.charsWritten;
/*     */   }
/*     */ 
/*     */   public boolean isNew()
/*     */   {
/* 717 */     return (this.bytesWritten == 0) && (this.charsWritten == 0);
/*     */   }
/*     */ 
/*     */   public void setBufferSize(int size)
/*     */   {
/* 723 */     if (size > this.bb.getLimit())
/*     */     {
/* 725 */       this.bb.setLimit(size);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */   {
/* 734 */     this.bb.recycle();
/* 735 */     this.bytesWritten = 0;
/* 736 */     this.cb.recycle();
/* 737 */     this.charsWritten = 0;
/* 738 */     this.gotEnc = false;
/* 739 */     this.enc = null;
/* 740 */     this.state = 0;
/*     */   }
/*     */ 
/*     */   public int getBufferSize()
/*     */   {
/* 746 */     return this.bb.getLimit();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.coyote.OutputBuffer
 * JD-Core Version:    0.6.0
 */