/*      */ package org.jboss.remoting.transport.coyote;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.lang.reflect.Method;
/*      */ import java.net.InetAddress;
/*      */ import java.net.UnknownHostException;
/*      */ import java.util.Enumeration;
/*      */ import java.util.Iterator;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import javax.net.ServerSocketFactory;
/*      */ import org.apache.coyote.ActionCode;
/*      */ import org.apache.coyote.Adapter;
/*      */ import org.apache.coyote.ProtocolHandler;
/*      */ import org.apache.coyote.Request;
/*      */ import org.apache.coyote.Response;
/*      */ import org.apache.tomcat.util.buf.B2CConverter;
/*      */ import org.apache.tomcat.util.buf.ByteChunk;
/*      */ import org.apache.tomcat.util.buf.CharChunk;
/*      */ import org.apache.tomcat.util.buf.MessageBytes;
/*      */ import org.apache.tomcat.util.buf.UDecoder;
/*      */ import org.apache.tomcat.util.http.MimeHeaders;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.remoting.InvocationRequest;
/*      */ import org.jboss.remoting.InvocationResponse;
/*      */ import org.jboss.remoting.InvokerLocator;
/*      */ import org.jboss.remoting.marshal.Marshaller;
/*      */ import org.jboss.remoting.marshal.UnMarshaller;
/*      */ import org.jboss.remoting.marshal.VersionedMarshaller;
/*      */ import org.jboss.remoting.marshal.VersionedUnMarshaller;
/*      */ import org.jboss.remoting.security.SSLSocketBuilder;
/*      */ import org.jboss.remoting.transport.coyote.ssl.RemotingSSLImplementation;
/*      */ import org.jboss.remoting.transport.coyote.ssl.RemotingServerSocketFactory;
/*      */ import org.jboss.remoting.transport.web.WebServerInvoker;
/*      */ import org.jboss.remoting.transport.web.WebUtil;
/*      */ 
/*      */ public class CoyoteInvoker extends WebServerInvoker
/*      */   implements Adapter
/*      */ {
/*   70 */   private static final Logger log = Logger.getLogger(CoyoteInvoker.class);
/*      */ 
/*   73 */   protected static ThreadLocal receivedInvocationRequest = new ThreadLocal();
/*   74 */   protected static final Boolean FALSE = new Boolean(false);
/*   75 */   protected static final Boolean TRUE = new Boolean(true);
/*      */ 
/*   77 */   private boolean running = false;
/*      */ 
/*   79 */   protected ProtocolHandler protocolHandler = null;
/*      */ 
/*   81 */   protected String URIEncoding = null;
/*      */   protected boolean isRemotingUserAgent;
/*      */ 
/*      */   public CoyoteInvoker(InvokerLocator locator)
/*      */   {
/*   89 */     super(locator);
/*      */   }
/*      */ 
/*      */   public CoyoteInvoker(InvokerLocator locator, Map configuration)
/*      */   {
/*   94 */     super(locator, configuration);
/*      */   }
/*      */ 
/*      */   protected void setup()
/*      */     throws Exception
/*      */   {
/*  100 */     super.setup();
/*      */ 
/*  102 */     Map config = getConfiguration();
/*      */ 
/*  105 */     boolean apr = false;
/*      */     try
/*      */     {
/*  108 */       String methodName = "initialize";
/*  109 */       Class[] paramTypes = new Class[1];
/*  110 */       paramTypes[0] = String.class;
/*  111 */       Object[] paramValues = new Object[1];
/*  112 */       paramValues[0] = null;
/*  113 */       Method method = Class.forName("org.apache.tomcat.jni.Library").getMethod(methodName, paramTypes);
/*      */ 
/*  115 */       method.invoke(null, paramValues);
/*  116 */       apr = true;
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*      */     }
/*      */ 
/*  124 */     String protocolHandlerClassName = null;
/*  125 */     Object value = config.get("protocolHandlerClassName");
/*  126 */     if (value != null)
/*      */     {
/*  128 */       protocolHandlerClassName = String.valueOf(value);
/*      */     }
/*  132 */     else if (apr)
/*      */     {
/*  134 */       protocolHandlerClassName = "org.apache.coyote.http11.Http11AprProtocol";
/*      */     }
/*      */     else
/*      */     {
/*  138 */       protocolHandlerClassName = "org.apache.coyote.http11.Http11Protocol";
/*      */     }
/*      */ 
/*  141 */     log.info("Using " + protocolHandlerClassName + " for http (coyote) invoker protocol handler.");
/*      */     try
/*      */     {
/*  144 */       Class clazz = Class.forName(protocolHandlerClassName);
/*  145 */       this.protocolHandler = ((ProtocolHandler)clazz.newInstance());
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  149 */       log.error("Protocol handler instatiation failed", e);
/*  150 */       return;
/*      */     }
/*  152 */     this.protocolHandler.setAdapter(this);
/*      */ 
/*  155 */     Iterator keys = config.keySet().iterator();
/*  156 */     while (keys.hasNext())
/*      */     {
/*  158 */       String key = (String)keys.next();
/*  159 */       Object obj = config.get(key);
/*  160 */       if ((obj instanceof String))
/*      */       {
/*  162 */         String val = (String)obj;
/*  163 */         setProperty(this.protocolHandler, key, val);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  168 */     String timeoutValue = (String)config.get("timeout");
/*  169 */     if (timeoutValue != null)
/*      */     {
/*  171 */       setProperty(this.protocolHandler, "connectionTimeout", timeoutValue);
/*      */     }
/*      */ 
/*  175 */     value = config.get("URIEncoding");
/*  176 */     if (value != null)
/*      */     {
/*  178 */       this.URIEncoding = String.valueOf(value);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected ServerSocketFactory getDefaultServerSocketFactory()
/*      */     throws IOException
/*      */   {
/*  191 */     if ("https".equals(this.locator.getProtocol()))
/*      */     {
/*  193 */       SSLSocketBuilder builder = new SSLSocketBuilder(this.configuration);
/*  194 */       builder.setUseSSLServerSocketFactory(false);
/*      */       try
/*      */       {
/*  197 */         return builder.createSSLServerSocketFactory();
/*      */       }
/*      */       catch (IOException e)
/*      */       {
/*  201 */         log.error("unable to create server socket factory", e);
/*  202 */         throw e;
/*      */       }
/*      */     }
/*      */ 
/*  206 */     return null;
/*      */   }
/*      */ 
/*      */   public void start() throws IOException
/*      */   {
/*  211 */     if (!this.running)
/*      */     {
/*      */       try
/*      */       {
/*  216 */         InetAddress bindAddress = InetAddress.getByName(getServerBindAddress());
/*  217 */         int port = getServerBindPort();
/*  218 */         setProperty(this.protocolHandler, "address", getServerBindAddress());
/*  219 */         setProperty(this.protocolHandler, "port", "" + getServerBindPort());
/*      */ 
/*  225 */         setProperty(this.protocolHandler, "locator", getLocator().getLocatorURI());
/*  226 */         RemotingSSLImplementation.setMBeanServer(getLocator().getLocatorURI(), getMBeanServer());
/*      */ 
/*  228 */         ServerSocketFactory svrSocketFactory = getServerSocketFactory();
/*  229 */         if (svrSocketFactory != null)
/*      */         {
/*  231 */           RemotingServerSocketFactory.setServerSocketFactory(getLocator().getLocatorURI(), svrSocketFactory);
/*  232 */           setProperty(this.protocolHandler, "SocketFactory", RemotingServerSocketFactory.class.getName());
/*      */         }
/*      */ 
/*  235 */         this.protocolHandler.init();
/*  236 */         this.protocolHandler.start();
/*      */ 
/*  238 */         this.running = true;
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  243 */         log.error("Error starting protocol handler.  Bind port: " + getServerBindPort() + ", bind address: " + getServerBindAddress(), e);
/*  244 */         throw new IOException("" + e.getMessage());
/*      */       }
/*      */     }
/*  247 */     super.start();
/*      */   }
/*      */ 
/*      */   public void service(Request req, Response res)
/*      */     throws Exception
/*      */   {
/*  258 */     RequestMap request = (RequestMap)req.getNote(1);
/*  259 */     ResponseMap response = (ResponseMap)res.getNote(1);
/*      */ 
/*  261 */     if (request == null)
/*      */     {
/*  265 */       request = new RequestMap();
/*  266 */       request.setCoyoteRequest(req);
/*  267 */       response = new ResponseMap();
/*  268 */       response.setCoyoteResponse(res);
/*      */ 
/*  271 */       req.setNote(1, request);
/*  272 */       res.setNote(1, response);
/*      */     }
/*      */     else
/*      */     {
/*  280 */       response.clear();
/*  281 */       request.clear();
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  287 */       if (postParseRequest(req, request, res, response))
/*      */       {
/*  289 */         populateRequestMetadata(request, req);
/*      */ 
/*  291 */         Object responseObject = null;
/*  292 */         boolean isError = false;
/*      */ 
/*  294 */         int version = getVersion(request);
/*      */ 
/*  297 */         Object userAgentObj = request.get("User-Agent");
/*  298 */         if (userAgentObj != null)
/*      */         {
/*  300 */           String userAgent = (String)userAgentObj;
/*  301 */           this.isRemotingUserAgent = userAgent.startsWith("JBossRemoting");
/*      */         }
/*      */ 
/*  304 */         InvocationRequest invocationRequest = versionedRead(req, request, response, version);
/*      */         try
/*      */         {
/*  310 */           responseObject = invoke(invocationRequest);
/*      */         }
/*      */         catch (Throwable ex)
/*      */         {
/*  314 */           log.debug("Error thrown calling invoke on server invoker.", ex);
/*  315 */           responseObject = ex;
/*  316 */           isError = true;
/*      */         }
/*      */ 
/*  321 */         String message = "";
/*      */         int status;
/*  323 */         if (responseObject != null)
/*      */         {
/*  325 */           if (isError)
/*      */           {
/*  327 */             int status = 500;
/*  328 */             message = "JBoss Remoting: Error occurred within target application.";
/*      */           }
/*      */           else
/*      */           {
/*  332 */             int status = 200;
/*  333 */             message = "OK";
/*      */           }
/*      */ 
/*      */         }
/*  338 */         else if ((this.isRemotingUserAgent) && (!req.method().equals("HEAD")))
/*      */         {
/*  340 */           int status = 200;
/*  341 */           message = "OK";
/*      */         }
/*      */         else
/*      */         {
/*  345 */           status = 204;
/*  346 */           message = "No Content";
/*      */         }
/*      */ 
/*  351 */         Map responseMap = invocationRequest.getReturnPayload();
/*  352 */         if (responseMap != null)
/*      */         {
/*  354 */           Integer handlerStatus = (Integer)responseMap.get("ResponseCode");
/*  355 */           if (handlerStatus != null)
/*      */           {
/*  357 */             status = handlerStatus.intValue();
/*      */           }
/*  359 */           String handlerMessage = (String)responseMap.get("ResponseCodeMessage");
/*  360 */           if (handlerMessage != null)
/*      */           {
/*  362 */             message = handlerMessage;
/*      */           }
/*      */         }
/*  365 */         res.setStatus(status);
/*  366 */         res.setMessage(message);
/*      */ 
/*  368 */         if ((this.isRemotingUserAgent) && (((Boolean)receivedInvocationRequest.get()).booleanValue()))
/*      */         {
/*  370 */           responseMap = ((ResponseMap)responseMap).getMap();
/*  371 */           responseObject = new InvocationResponse(invocationRequest.getSessionId(), responseObject, isError, responseMap);
/*      */         }
/*      */ 
/*  375 */         if (responseObject != null)
/*      */         {
/*  377 */           versionedWrite(version, responseObject, req, res, response);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  382 */       response.outputBuffer.close();
/*      */ 
/*  384 */       req.action(ActionCode.ACTION_POST_REQUEST, null);
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/*  389 */       log.error("Error processing request", e);
/*      */     }
/*      */     catch (Throwable t)
/*      */     {
/*  393 */       log.error("Service error", t);
/*      */     }
/*      */     finally
/*      */     {
/*  398 */       request.recycle();
/*  399 */       response.recycle();
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addLeaseInfo(ResponseMap response)
/*      */   {
/*  406 */     boolean leaseManagement = isLeaseActivated();
/*  407 */     response.put("LEASING_ENABLED", new Boolean(leaseManagement));
/*      */ 
/*  409 */     if (leaseManagement)
/*      */     {
/*  411 */       long leasePeriod = getLeasePeriod();
/*  412 */       response.put("LEASE_PERIOD", new Long(leasePeriod));
/*      */     }
/*      */   }
/*      */ 
/*      */   private void versionedWrite(int version, Object responseObject, Request req, Response res, ResponseMap response)
/*      */     throws IOException
/*      */   {
/*  419 */     switch (version)
/*      */     {
/*      */     case 1:
/*      */     case 2:
/*      */     case 22:
/*  425 */       String responseContentType = (String)response.get("Content-Type");
/*  426 */       if (responseContentType == null)
/*      */       {
/*  428 */         responseContentType = responseObject == null ? req.getContentType() : WebUtil.getContentType(responseObject);
/*      */       }
/*  430 */       res.setContentType(responseContentType);
/*      */ 
/*  432 */       Marshaller marshaller = getMarshaller();
/*  433 */       if ((marshaller instanceof VersionedMarshaller))
/*  434 */         ((VersionedMarshaller)marshaller).write(responseObject, response.getOutputStream(), version);
/*      */       else
/*  436 */         marshaller.write(responseObject, response.getOutputStream());
/*  437 */       return;
/*      */     }
/*      */ 
/*  441 */     throw new IOException("Can not send response due to version (" + version + ") not being supported.  Supported versions: " + 1 + ", " + 2 + ", " + 22);
/*      */   }
/*      */ 
/*      */   private InvocationRequest versionedRead(Request req, RequestMap request, ResponseMap response, int version)
/*      */     throws IOException, ClassNotFoundException
/*      */   {
/*  449 */     switch (version)
/*      */     {
/*      */     case 1:
/*      */     case 2:
/*      */     case 22:
/*  456 */       receivedInvocationRequest.set(FALSE);
/*  457 */       InvocationRequest invocationRequest = null;
/*  458 */       MessageBytes method = req.method();
/*  459 */       if ((method.equals("GET")) || (method.equals("HEAD")) || ((method.equals("OPTIONS")) && (req.getContentLength() <= 0)))
/*      */       {
/*  462 */         invocationRequest = createNewInvocationRequest(request, response, null);
/*      */       }
/*      */       else
/*      */       {
/*  466 */         UnMarshaller unmarshaller = getUnMarshaller();
/*  467 */         Object obj = null;
/*  468 */         if ((unmarshaller instanceof VersionedUnMarshaller))
/*  469 */           obj = ((VersionedUnMarshaller)unmarshaller).read(request.getInputStream(), request, version);
/*      */         else
/*  471 */           obj = unmarshaller.read(request.getInputStream(), request);
/*  472 */         if ((obj instanceof InvocationRequest))
/*      */         {
/*  474 */           receivedInvocationRequest.set(TRUE);
/*  475 */           invocationRequest = (InvocationRequest)obj;
/*  476 */           if (invocationRequest.getReturnPayload() == null)
/*      */           {
/*  479 */             invocationRequest.setReturnPayload(response);
/*      */           }
/*  481 */           Map requestPayloadMap = invocationRequest.getRequestPayload();
/*  482 */           if (requestPayloadMap != null)
/*      */           {
/*  484 */             request.putAll(requestPayloadMap);
/*      */           }
/*  486 */           invocationRequest.setRequestPayload(request);
/*      */         }
/*      */         else {
/*  489 */           invocationRequest = createNewInvocationRequest(request, response, obj);
/*      */         }
/*      */       }
/*      */ 
/*  493 */       return invocationRequest;
/*      */     }
/*      */ 
/*  498 */     throw new IOException("Can not processes request due to incorrect version (" + version + ").  Can only process versions: " + 1 + ", " + 2 + ", " + 22);
/*      */   }
/*      */ 
/*      */   private int getVersion(RequestMap request)
/*      */   {
/*  505 */     int version = 1;
/*  506 */     Object versionObj = request.get("JBoss-Remoting-Version");
/*  507 */     if (versionObj != null)
/*      */     {
/*  509 */       String versionString = (String)versionObj;
/*      */       try
/*      */       {
/*  512 */         version = Integer.parseInt(versionString);
/*      */       }
/*      */       catch (NumberFormatException e) {
/*  515 */         log.error("Can not processes remoting version of " + versionString + " as is not a number.");
/*      */       }
/*      */     }
/*  518 */     return version;
/*      */   }
/*      */ 
/*      */   private void populateRequestMetadata(RequestMap metadata, Request req)
/*      */   {
/*  523 */     MimeHeaders headers = req.getMimeHeaders();
/*  524 */     Enumeration nameEnum = headers.names();
/*  525 */     while (nameEnum.hasMoreElements())
/*      */     {
/*  527 */       Object nameObj = nameEnum.nextElement();
/*  528 */       if ((nameObj instanceof String))
/*      */       {
/*  530 */         Object valueObj = headers.getHeader((String)nameObj);
/*  531 */         metadata.put(nameObj, valueObj);
/*      */       }
/*      */     }
/*      */ 
/*  535 */     metadata.put("MethodType", req.method().getString());
/*  536 */     metadata.put("Path", req.requestURI().getString());
/*  537 */     metadata.put("HttpVersion", req.protocol().getString());
/*      */   }
/*      */ 
/*      */   protected InvocationRequest createNewInvocationRequest(RequestMap requestMap, ResponseMap responseMap, Object payload)
/*      */   {
/*  546 */     String sessionId = getSessionId(requestMap);
/*  547 */     String subSystem = (String)requestMap.get(HEADER_SUBSYSTEM);
/*      */ 
/*  549 */     InvocationRequest request = null;
/*      */ 
/*  551 */     boolean isLeaseQueury = checkForLeaseQuery(requestMap);
/*  552 */     if (isLeaseQueury)
/*      */     {
/*  554 */       addLeaseInfo(responseMap);
/*  555 */       request = new InvocationRequest(sessionId, subSystem, "$PING$", null, responseMap, null);
/*      */     }
/*      */     else
/*      */     {
/*  559 */       request = new InvocationRequest(sessionId, subSystem, payload, requestMap, responseMap, null);
/*      */     }
/*      */ 
/*  562 */     return request;
/*      */   }
/*      */ 
/*      */   private boolean checkForLeaseQuery(RequestMap headers)
/*      */   {
/*  567 */     boolean isLeaseQuery = false;
/*      */ 
/*  569 */     if (headers != null)
/*      */     {
/*  571 */       Object val = headers.get("JBoss-Remoting-Lease-Query");
/*  572 */       if ((val != null) && ((val instanceof String)))
/*      */       {
/*  574 */         isLeaseQuery = Boolean.valueOf((String)val).booleanValue();
/*      */       }
/*      */     }
/*  577 */     return isLeaseQuery;
/*      */   }
/*      */ 
/*      */   protected boolean postParseRequest(Request req, RequestMap request, Response res, ResponseMap response)
/*      */     throws Exception
/*      */   {
/*  591 */     MessageBytes decodedURI = req.decodedURI();
/*  592 */     decodedURI.duplicate(req.requestURI());
/*      */ 
/*  594 */     if (decodedURI.getType() == 2)
/*      */     {
/*      */       try
/*      */       {
/*  599 */         req.getURLDecoder().convert(decodedURI, false);
/*      */       }
/*      */       catch (IOException ioe)
/*      */       {
/*  603 */         res.setStatus(400);
/*  604 */         res.setMessage("Invalid URI");
/*  605 */         throw ioe;
/*      */       }
/*      */ 
/*  608 */       if (!normalize(req.decodedURI()))
/*      */       {
/*  610 */         res.setStatus(400);
/*  611 */         res.setMessage("Invalid URI");
/*  612 */         return false;
/*      */       }
/*      */ 
/*  615 */       convertURI(decodedURI, request);
/*      */     }
/*      */     else
/*      */     {
/*  622 */       decodedURI.toChars();
/*      */     }
/*      */ 
/*  625 */     return true;
/*      */   }
/*      */ 
/*      */   protected void convertURI(MessageBytes uri, RequestMap request)
/*      */     throws Exception
/*      */   {
/*  637 */     ByteChunk bc = uri.getByteChunk();
/*  638 */     CharChunk cc = uri.getCharChunk();
/*  639 */     cc.allocate(bc.getLength(), -1);
/*      */ 
/*  641 */     String enc = this.URIEncoding;
/*  642 */     if (enc != null)
/*      */     {
/*  644 */       B2CConverter conv = request.getURIConverter();
/*      */       try
/*      */       {
/*  647 */         if (conv == null)
/*      */         {
/*  649 */           conv = new B2CConverter(enc);
/*  650 */           request.setURIConverter(conv);
/*      */         }
/*      */         else
/*      */         {
/*  654 */           conv.recycle();
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (IOException e)
/*      */       {
/*  660 */         log.error("Invalid URI encoding; using HTTP default");
/*  661 */         this.URIEncoding = null;
/*      */       }
/*  663 */       if (conv != null)
/*      */       {
/*      */         try
/*      */         {
/*  667 */           conv.convert(bc, cc);
/*  668 */           uri.setChars(cc.getBuffer(), cc.getStart(), cc.getLength());
/*      */ 
/*  670 */           return;
/*      */         }
/*      */         catch (IOException e)
/*      */         {
/*  674 */           log.error("Invalid URI character encoding; trying ascii");
/*  675 */           cc.recycle();
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  681 */     byte[] bbuf = bc.getBuffer();
/*  682 */     char[] cbuf = cc.getBuffer();
/*  683 */     int start = bc.getStart();
/*  684 */     for (int i = 0; i < bc.getLength(); i++)
/*      */     {
/*  686 */       cbuf[i] = (char)(bbuf[(i + start)] & 0xFF);
/*      */     }
/*  688 */     uri.setChars(cbuf, 0, bc.getLength());
/*      */   }
/*      */ 
/*      */   protected void convertMB(MessageBytes mb)
/*      */   {
/*  700 */     if (mb.getType() != 2)
/*      */     {
/*  702 */       return;
/*      */     }
/*      */ 
/*  705 */     ByteChunk bc = mb.getByteChunk();
/*  706 */     CharChunk cc = mb.getCharChunk();
/*  707 */     cc.allocate(bc.getLength(), -1);
/*      */ 
/*  710 */     byte[] bbuf = bc.getBuffer();
/*  711 */     char[] cbuf = cc.getBuffer();
/*  712 */     int start = bc.getStart();
/*  713 */     for (int i = 0; i < bc.getLength(); i++)
/*      */     {
/*  715 */       cbuf[i] = (char)(bbuf[(i + start)] & 0xFF);
/*      */     }
/*  717 */     mb.setChars(cbuf, 0, bc.getLength());
/*      */   }
/*      */ 
/*      */   public static boolean normalize(MessageBytes uriMB)
/*      */   {
/*  734 */     ByteChunk uriBC = uriMB.getByteChunk();
/*  735 */     byte[] b = uriBC.getBytes();
/*  736 */     int start = uriBC.getStart();
/*  737 */     int end = uriBC.getEnd();
/*      */ 
/*  740 */     if ((end - start == 1) && (b[start] == 42))
/*      */     {
/*  742 */       return true;
/*      */     }
/*      */ 
/*  745 */     int pos = 0;
/*  746 */     int index = 0;
/*      */ 
/*  750 */     for (pos = start; pos < end; pos++)
/*      */     {
/*  752 */       if (b[pos] == 92)
/*      */       {
/*  754 */         b[pos] = 47;
/*      */       }
/*  756 */       if (b[pos] == 0)
/*      */       {
/*  758 */         return false;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  763 */     if (b[start] != 47)
/*      */     {
/*  765 */       return false;
/*      */     }
/*      */ 
/*  769 */     for (pos = start; pos < end - 1; pos++)
/*      */     {
/*  771 */       if (b[pos] != 47)
/*      */         continue;
/*  773 */       while ((pos + 1 < end) && (b[(pos + 1)] == 47))
/*      */       {
/*  775 */         copyBytes(b, pos, pos + 1, end - pos - 1);
/*  776 */         end--;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  784 */     if ((end - start >= 2) && (b[(end - 1)] == 46))
/*      */     {
/*  786 */       if ((b[(end - 2)] == 47) || ((b[(end - 2)] == 46) && (b[(end - 3)] == 47)))
/*      */       {
/*  790 */         b[end] = 47;
/*  791 */         end++;
/*      */       }
/*      */     }
/*      */ 
/*  795 */     uriBC.setEnd(end);
/*      */ 
/*  797 */     index = 0;
/*      */     while (true)
/*      */     {
/*  802 */       index = uriBC.indexOf("/./", 0, 3, index);
/*  803 */       if (index < 0)
/*      */       {
/*      */         break;
/*      */       }
/*  807 */       copyBytes(b, start + index, start + index + 2, end - start - index - 2);
/*      */ 
/*  809 */       end -= 2;
/*  810 */       uriBC.setEnd(end);
/*      */     }
/*      */ 
/*  813 */     index = 0;
/*      */     while (true)
/*      */     {
/*  818 */       index = uriBC.indexOf("/../", 0, 4, index);
/*  819 */       if (index < 0)
/*      */       {
/*      */         break;
/*      */       }
/*      */ 
/*  824 */       if (index == 0)
/*      */       {
/*  826 */         return false;
/*      */       }
/*  828 */       int index2 = -1;
/*  829 */       for (pos = start + index - 1; (pos >= 0) && (index2 < 0); pos--)
/*      */       {
/*  831 */         if (b[pos] != 47)
/*      */           continue;
/*  833 */         index2 = pos;
/*      */       }
/*      */ 
/*  836 */       copyBytes(b, start + index2, start + index + 3, end - start - index - 3);
/*      */ 
/*  838 */       end = end + index2 - index - 3;
/*  839 */       uriBC.setEnd(end);
/*  840 */       index = index2;
/*      */     }
/*      */ 
/*  843 */     uriBC.setBytes(b, start, end);
/*      */ 
/*  845 */     return true;
/*      */   }
/*      */ 
/*      */   protected static void copyBytes(byte[] b, int dest, int src, int len)
/*      */   {
/*  856 */     for (int pos = 0; pos < len; pos++)
/*      */     {
/*  858 */       b[(pos + dest)] = b[(pos + src)];
/*      */     }
/*      */   }
/*      */ 
/*      */   public void stop()
/*      */   {
/*  865 */     if (this.running)
/*      */     {
/*  867 */       this.running = false;
/*      */       try
/*      */       {
/*  871 */         this.protocolHandler.destroy();
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  875 */         log.error("Stop error", e);
/*      */       }
/*      */     }
/*  878 */     super.stop();
/*      */ 
/*  880 */     log.debug("CoyoteInvoker stopped.");
/*      */   }
/*      */ 
/*      */   public static boolean setProperty(Object o, String name, String value)
/*      */   {
/*  890 */     String setter = "set" + capitalize(name);
/*      */     try
/*      */     {
/*  894 */       Method[] methods = o.getClass().getMethods();
/*  895 */       Method setPropertyMethod = null;
/*      */ 
/*  898 */       for (int i = 0; i < methods.length; i++)
/*      */       {
/*  900 */         Class[] paramT = methods[i].getParameterTypes();
/*  901 */         if ((!setter.equals(methods[i].getName())) || (paramT.length != 1) || (!"java.lang.String".equals(paramT[0].getName())))
/*      */         {
/*      */           continue;
/*      */         }
/*  905 */         methods[i].invoke(o, new Object[] { value });
/*  906 */         return true;
/*      */       }
/*      */ 
/*  911 */       for (int i = 0; i < methods.length; i++)
/*      */       {
/*  913 */         boolean ok = true;
/*  914 */         if ((setter.equals(methods[i].getName())) && (methods[i].getParameterTypes().length == 1))
/*      */         {
/*  919 */           Class paramType = methods[i].getParameterTypes()[0];
/*  920 */           Object[] params = new Object[1];
/*      */ 
/*  923 */           if (("java.lang.Integer".equals(paramType.getName())) || ("int".equals(paramType.getName())))
/*      */           {
/*      */             try
/*      */             {
/*  928 */               params[0] = new Integer(value);
/*      */             }
/*      */             catch (NumberFormatException ex)
/*      */             {
/*  932 */               ok = false;
/*      */             }
/*      */ 
/*      */           }
/*  936 */           else if (("java.lang.Long".equals(paramType.getName())) || ("long".equals(paramType.getName())))
/*      */           {
/*      */             try
/*      */             {
/*  941 */               params[0] = new Long(value);
/*      */             }
/*      */             catch (NumberFormatException ex)
/*      */             {
/*  945 */               ok = false;
/*      */             }
/*      */ 
/*      */           }
/*  950 */           else if (("java.lang.Boolean".equals(paramType.getName())) || ("boolean".equals(paramType.getName())))
/*      */           {
/*  953 */             params[0] = new Boolean(value);
/*      */           }
/*  957 */           else if ("java.net.InetAddress".equals(paramType.getName()))
/*      */           {
/*      */             try
/*      */             {
/*  962 */               params[0] = InetAddress.getByName(value);
/*      */             }
/*      */             catch (UnknownHostException exc)
/*      */             {
/*  966 */               ok = false;
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*  972 */           if (ok)
/*      */           {
/*  974 */             methods[i].invoke(o, params);
/*  975 */             return true;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*  980 */         if (!"setProperty".equals(methods[i].getName()))
/*      */           continue;
/*  982 */         setPropertyMethod = methods[i];
/*      */       }
/*      */ 
/*  987 */       if (setPropertyMethod != null)
/*      */       {
/*  989 */         Object[] params = new Object[2];
/*  990 */         params[0] = name;
/*  991 */         params[1] = value;
/*  992 */         setPropertyMethod.invoke(o, params);
/*  993 */         return true;
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  999 */       return false;
/*      */     }
/* 1001 */     return false;
/*      */   }
/*      */ 
/*      */   public static String capitalize(String name)
/*      */   {
/* 1009 */     if ((name == null) || (name.length() == 0))
/*      */     {
/* 1011 */       return name;
/*      */     }
/* 1013 */     char[] chars = name.toCharArray();
/* 1014 */     chars[0] = Character.toUpperCase(chars[0]);
/* 1015 */     return new String(chars);
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.coyote.CoyoteInvoker
 * JD-Core Version:    0.6.0
 */