/*      */ package org.jboss.remoting.transport;
/*      */ 
/*      */ import java.net.InetAddress;
/*      */ import java.util.HashMap;
/*      */ import java.util.Iterator;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import java.util.StringTokenizer;
/*      */ import javax.management.MBeanRegistration;
/*      */ import javax.management.MBeanServer;
/*      */ import javax.management.MBeanServerInvocationHandler;
/*      */ import javax.management.MalformedObjectNameException;
/*      */ import javax.management.ObjectName;
/*      */ import javax.net.ServerSocketFactory;
/*      */ import javax.net.SocketFactory;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.remoting.ConnectionListener;
/*      */ import org.jboss.remoting.InvokerLocator;
/*      */ import org.jboss.remoting.InvokerRegistry;
/*      */ import org.jboss.remoting.ServerInvocationHandler;
/*      */ import org.jboss.remoting.ServerInvoker;
/*      */ import org.jboss.remoting.marshal.MarshalFactory;
/*      */ import org.jboss.remoting.marshal.MarshallLoaderFactory;
/*      */ import org.jboss.remoting.serialization.ClassLoaderUtility;
/*      */ import org.w3c.dom.Element;
/*      */ import org.w3c.dom.NamedNodeMap;
/*      */ import org.w3c.dom.Node;
/*      */ import org.w3c.dom.NodeList;
/*      */ 
/*      */ public class Connector
/*      */   implements MBeanRegistration, ConnectorMBean
/*      */ {
/*      */   protected ServerInvoker invoker;
/*      */   private String locatorURI;
/*      */   private Element xml;
/*  126 */   private Map configuration = new HashMap();
/*      */   private MBeanServer server;
/*      */   private ServerSocketFactory svrSocketFactory;
/*      */   private SocketFactory socketFactory;
/*  133 */   private Connector marshallerLoaderConnector = null;
/*  134 */   private boolean isMarshallerLoader = false;
/*      */ 
/*  136 */   private boolean isStarted = false;
/*  137 */   private boolean isCreated = false;
/*      */ 
/*  139 */   protected final Logger log = Logger.getLogger(getClass());
/*      */ 
/*      */   public Connector()
/*      */   {
/*      */   }
/*      */ 
/*      */   public Connector(String locatorURI)
/*      */   {
/*  156 */     this.locatorURI = locatorURI;
/*      */   }
/*      */ 
/*      */   public Connector(InvokerLocator locator)
/*      */   {
/*  166 */     if (locator != null)
/*      */     {
/*  168 */       this.locatorURI = locator.getLocatorURI();
/*      */     }
/*      */   }
/*      */ 
/*      */   public Connector(Map configuration)
/*      */   {
/*  179 */     this.configuration.putAll(configuration);
/*      */   }
/*      */ 
/*      */   public Connector(String locatorURI, Map configuration)
/*      */   {
/*  190 */     this.locatorURI = locatorURI;
/*  191 */     this.configuration.putAll(configuration);
/*      */   }
/*      */ 
/*      */   public Connector(InvokerLocator locator, Map configuration)
/*      */   {
/*  202 */     if (locator != null)
/*      */     {
/*  204 */       this.locatorURI = locator.getLocatorURI();
/*      */     }
/*      */ 
/*  207 */     if (configuration != null)
/*      */     {
/*  209 */       this.configuration.putAll(configuration);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected Connector(boolean isMarshallerConnector)
/*      */   {
/*  215 */     this();
/*  216 */     this.isMarshallerLoader = isMarshallerConnector;
/*      */   }
/*      */ 
/*      */   public boolean isStarted()
/*      */   {
/*  226 */     return this.isStarted;
/*      */   }
/*      */ 
/*      */   public ObjectName preRegister(MBeanServer server, ObjectName name)
/*      */     throws Exception
/*      */   {
/*  250 */     this.server = server;
/*  251 */     return name;
/*      */   }
/*      */ 
/*      */   public void postRegister(Boolean registrationDone)
/*      */   {
/*      */   }
/*      */ 
/*      */   public void preDeregister()
/*      */     throws Exception
/*      */   {
/*      */   }
/*      */ 
/*      */   public void postDeregister()
/*      */   {
/*      */   }
/*      */ 
/*      */   public void start()
/*      */     throws Exception
/*      */   {
/*  294 */     if (!this.isStarted)
/*      */     {
/*  299 */       if (!this.isCreated)
/*      */       {
/*  301 */         create();
/*      */       }
/*      */ 
/*  306 */       configureHandlers();
/*      */ 
/*  309 */       if (!this.isMarshallerLoader)
/*      */       {
/*  311 */         if ((this.marshallerLoaderConnector != null) && (!this.marshallerLoaderConnector.isStarted()))
/*      */         {
/*  313 */           this.marshallerLoaderConnector.start();
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  318 */       if (!this.invoker.isStarted())
/*      */       {
/*      */         try
/*      */         {
/*  322 */           this.invoker.start();
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/*  326 */           if (this.marshallerLoaderConnector != null)
/*      */           {
/*  328 */             this.marshallerLoaderConnector.stop();
/*      */           }
/*  330 */           this.log.error("Error starting connector.", e);
/*  331 */           throw e;
/*      */         }
/*      */       }
/*  334 */       this.isStarted = true;
/*      */ 
/*  336 */       this.log.debug(this + " started");
/*      */     }
/*      */   }
/*      */ 
/*      */   public void start(boolean runAsNewThread)
/*      */     throws Exception
/*      */   {
/*  351 */     Runnable r = new Runnable()
/*      */     {
/*      */       public void run()
/*      */       {
/*      */         try
/*      */         {
/*  357 */           Connector.this.start();
/*      */         }
/*      */         catch (Exception e)
/*      */         {
/*  361 */           Connector.this.log.error("Error starting Connector.", e);
/*      */         }
/*      */       }
/*      */     };
/*  365 */     Thread t = new Thread(r);
/*  366 */     t.setDaemon(false);
/*  367 */     t.start();
/*      */   }
/*      */ 
/*      */   private void init()
/*      */     throws Exception
/*      */   {
/*  373 */     Map invokerConfig = new HashMap();
/*      */ 
/*  375 */     if (this.locatorURI == null)
/*      */     {
/*  378 */       if (this.xml != null)
/*      */       {
/*  380 */         getInvokerConfig(invokerConfig);
/*      */       }
/*      */ 
/*  383 */       this.configuration.putAll(invokerConfig);
/*      */     }
/*      */ 
/*  386 */     if (this.locatorURI == null)
/*      */     {
/*  388 */       throw new IllegalStateException("Connector not configured with LocatorURI.");
/*      */     }
/*      */ 
/*  391 */     InvokerLocator locator = new InvokerLocator(this.locatorURI);
/*      */ 
/*  393 */     if (this.invoker == null)
/*      */     {
/*  396 */       this.invoker = InvokerRegistry.createServerInvoker(locator, this.configuration);
/*      */ 
/*  399 */       if (this.server != null)
/*      */       {
/*      */         try
/*      */         {
/*  403 */           ObjectName objName = new ObjectName(this.invoker.getMBeanObjectName());
/*  404 */           if (!this.server.isRegistered(objName))
/*      */           {
/*  406 */             this.server.registerMBean(this.invoker, objName);
/*      */           }
/*      */           else
/*      */           {
/*  410 */             this.log.warn(objName + " is already registered with MBeanServer");
/*      */           }
/*  412 */           this.invoker.setMBeanServer(this.server);
/*      */         }
/*      */         catch (Throwable e)
/*      */         {
/*  416 */           this.log.warn("Error registering invoker " + this.invoker + " with MBeanServer.", e);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  421 */       this.invoker.setServerSocketFactory(this.svrSocketFactory);
/*      */ 
/*  424 */       this.svrSocketFactory = null;
/*      */ 
/*  427 */       this.invoker.setSocketFactory(this.socketFactory);
/*  428 */       this.socketFactory = null;
/*      */ 
/*  430 */       this.invoker.create();
/*      */     }
/*      */ 
/*  435 */     this.locatorURI = this.invoker.getLocator().getLocatorURI();
/*      */ 
/*  438 */     if (!this.isMarshallerLoader)
/*      */     {
/*  441 */       if (this.marshallerLoaderConnector == null)
/*      */       {
/*  443 */         this.marshallerLoaderConnector = createMarshallerLoader(this.invoker.getLocator());
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private Connector createMarshallerLoader(InvokerLocator locator)
/*      */   {
/*  459 */     MarshalFactory.getMarshaller(locator, getClass().getClassLoader());
/*      */ 
/*  461 */     Connector marshallerLoader = null;
/*  462 */     InvokerLocator loaderLocator = MarshallLoaderFactory.convertLocator(locator);
/*      */ 
/*  464 */     if (loaderLocator != null)
/*      */     {
/*  466 */       marshallerLoader = MarshallLoaderFactory.createMarshallLoader(loaderLocator);
/*      */     }
/*  468 */     return marshallerLoader;
/*      */   }
/*      */ 
/*      */   private void getInvokerConfig(Map invokerConfig)
/*      */   {
/*      */     try
/*      */     {
/*  475 */       NodeList invokerNodes = this.xml.getElementsByTagName("invoker");
/*      */ 
/*  477 */       if ((invokerNodes != null) && (invokerNodes.getLength() >= 1))
/*      */       {
/*  480 */         Node invokerNode = invokerNodes.item(0);
/*      */ 
/*  482 */         NamedNodeMap attributes = invokerNode.getAttributes();
/*  483 */         Node transportNode = attributes.getNamedItem("transport");
/*      */ 
/*  485 */         if (transportNode != null)
/*      */         {
/*  487 */           String transport = transportNode.getNodeValue();
/*      */ 
/*  490 */           if (invokerNodes.getLength() > 1)
/*      */           {
/*  492 */             this.log.warn("Found more than one invokers defined in configuration.  Will only be using the first one - " + transport);
/*      */           }
/*      */ 
/*  497 */           Map paramConfig = new HashMap();
/*  498 */           NodeList invokerAttributes = invokerNode.getChildNodes();
/*  499 */           int len = invokerAttributes.getLength();
/*  500 */           for (int x = 0; x < len; x++)
/*      */           {
/*  502 */             Node attr = invokerAttributes.item(x);
/*  503 */             if (!"attribute".equals(attr.getNodeName()))
/*      */               continue;
/*  505 */             String name = attr.getAttributes().getNamedItem("name").getNodeValue();
/*  506 */             String value = attr.getFirstChild().getNodeValue();
/*  507 */             invokerConfig.put(name, value);
/*  508 */             Node isParamAttribute = attr.getAttributes().getNamedItem("isParam");
/*  509 */             if ((isParamAttribute == null) || (!Boolean.valueOf(isParamAttribute.getNodeValue()).booleanValue()))
/*      */               continue;
/*  511 */             paramConfig.put(name, value);
/*      */           }
/*      */ 
/*  518 */           String clientConnectAddress = (String)invokerConfig.get("clientConnectAddress");
/*  519 */           String clientConnectPort = (String)invokerConfig.get("clientConnectPort");
/*  520 */           String serverBindAddress = (String)invokerConfig.get("serverBindAddress");
/*  521 */           String serverBindPort = (String)invokerConfig.get("serverBindPort");
/*  522 */           String path = (String)invokerConfig.get("path");
/*      */ 
/*  524 */           String host = serverBindAddress != null ? serverBindAddress : clientConnectAddress != null ? clientConnectAddress : InetAddress.getLocalHost().getHostAddress();
/*  525 */           int port = serverBindPort != null ? Integer.parseInt(serverBindPort) : clientConnectPort != null ? Integer.parseInt(clientConnectPort) : PortUtil.findFreePort(serverBindAddress != null ? serverBindAddress : InetAddress.getLocalHost().getHostAddress());
/*      */ 
/*  528 */           String tempURI = transport + "://" + host + ":" + port;
/*      */ 
/*  531 */           if (path != null)
/*      */           {
/*  533 */             tempURI = tempURI + "/" + path;
/*      */           }
/*      */ 
/*  537 */           if (paramConfig.size() > 0)
/*      */           {
/*  539 */             tempURI = tempURI + "/?";
/*  540 */             Iterator keyItr = paramConfig.keySet().iterator();
/*  541 */             if (keyItr.hasNext())
/*      */             {
/*  543 */               Object name = keyItr.next();
/*  544 */               Object value = paramConfig.get(name);
/*  545 */               tempURI = tempURI + name + "=" + value;
/*      */             }
/*  547 */             while (keyItr.hasNext())
/*      */             {
/*  549 */               tempURI = tempURI + "&";
/*  550 */               Object name = keyItr.next();
/*  551 */               Object value = paramConfig.get(name);
/*  552 */               tempURI = tempURI + name + "=" + value;
/*      */             }
/*      */           }
/*  555 */           this.locatorURI = tempURI;
/*      */         }
/*      */         else
/*      */         {
/*  559 */           this.log.error("Invoker element within Configuration attribute does not contain a transport attribute.");
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  566 */       this.log.error("Error configuring invoker for connector.", e);
/*  567 */       throw new IllegalStateException("Error configuring invoker for connector.  Can not continue without invoker.");
/*      */     }
/*      */   }
/*      */ 
/*      */   private void configureHandlers()
/*      */     throws Exception
/*      */   {
/*  574 */     if (this.xml != null)
/*      */     {
/*  576 */       NodeList handlersNodes = this.xml.getElementsByTagName("handler");
/*      */ 
/*  578 */       if (((handlersNodes == null) || (handlersNodes.getLength() <= 0)) && ((getInvocationHandlers() == null) || (getInvocationHandlers().length == 0)))
/*      */       {
/*  581 */         throw new IllegalArgumentException("required 'handler' element not found and are no registered handlers found.");
/*      */       }
/*      */ 
/*  584 */       int len = handlersNodes.getLength();
/*      */ 
/*  586 */       for (int c = 0; c < len; c++)
/*      */       {
/*  588 */         Node node = handlersNodes.item(c);
/*  589 */         Node subNode = node.getAttributes().getNamedItem("subsystem");
/*      */ 
/*  591 */         if (subNode == null)
/*      */         {
/*  593 */           throw new IllegalArgumentException("Required 'subsystem' attribute on 'handler' element");
/*      */         }
/*      */ 
/*  596 */         String handlerClass = node.getFirstChild().getNodeValue();
/*      */ 
/*  598 */         boolean isObjName = false;
/*  599 */         ServerInvocationHandler handler = null;
/*      */         try
/*      */         {
/*  604 */           ObjectName objName = new ObjectName(handlerClass);
/*  605 */           handler = createHandlerProxy(objName);
/*  606 */           isObjName = true;
/*      */         }
/*      */         catch (MalformedObjectNameException e)
/*      */         {
/*  610 */           this.log.debug("Handler supplied is not an object name.");
/*      */         }
/*      */ 
/*  613 */         if (!isObjName)
/*      */         {
/*  615 */           Class serverInvocationHandlerClass = ClassLoaderUtility.loadClass(handlerClass, Connector.class);
/*  616 */           handler = (ServerInvocationHandler)serverInvocationHandlerClass.newInstance();
/*      */         }
/*      */ 
/*  620 */         StringTokenizer tok = new StringTokenizer(subNode.getNodeValue(), ",");
/*      */ 
/*  622 */         while (tok.hasMoreTokens())
/*      */         {
/*  624 */           String subsystem = tok.nextToken();
/*  625 */           addInvocationHandler(subsystem, handler);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private ServerInvocationHandler createHandlerProxy(ObjectName objName)
/*      */   {
/*      */     ServerInvocationHandler handler;
/*  634 */     if (this.server != null)
/*      */     {
/*  636 */       handler = (ServerInvocationHandler)MBeanServerInvocationHandler.newProxyInstance(this.server, objName, ServerInvocationHandler.class, false);
/*      */     }
/*      */     else
/*      */     {
/*  644 */       throw new RuntimeException("Can not register MBean invocation handler as the Connector has not been registered with a MBeanServer.");
/*      */     }
/*      */     ServerInvocationHandler handler;
/*  646 */     return handler;
/*      */   }
/*      */ 
/*      */   public void addConnectionListener(ConnectionListener listener)
/*      */   {
/*  664 */     if (this.invoker != null)
/*      */     {
/*  666 */       this.invoker.addConnectionListener(listener);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void removeConnectionListener(ConnectionListener listener)
/*      */   {
/*  683 */     if (this.invoker != null)
/*      */     {
/*  685 */       this.invoker.removeConnectionListener(listener);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setLeasePeriod(long leasePeriodValue)
/*      */   {
/*  701 */     if (this.invoker != null)
/*      */     {
/*  703 */       this.invoker.setLeasePeriod(leasePeriodValue);
/*      */     }
/*      */   }
/*      */ 
/*      */   public long getLeasePeriod()
/*      */   {
/*  716 */     if (this.invoker != null)
/*      */     {
/*  718 */       return this.invoker.getLeasePeriod();
/*      */     }
/*      */ 
/*  722 */     return -1L;
/*      */   }
/*      */ 
/*      */   public void stop()
/*      */   {
/*  735 */     if (this.isStarted)
/*      */     {
/*  737 */       if (this.invoker != null)
/*      */       {
/*  739 */         if (this.server != null)
/*      */         {
/*      */           try
/*      */           {
/*  743 */             ObjectName objName = new ObjectName(this.invoker.getMBeanObjectName());
/*  744 */             this.server.unregisterMBean(objName);
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/*  748 */             this.log.error("invalid Object Name", e);
/*      */           }
/*      */         }
/*  751 */         this.invoker.stop();
/*  752 */         this.invoker.destroy();
/*  753 */         InvokerRegistry.destroyServerInvoker(this.invoker);
/*  754 */         this.invoker = null;
/*      */       }
/*  756 */       if ((this.marshallerLoaderConnector != null) && (this.marshallerLoaderConnector.isStarted))
/*      */       {
/*  758 */         this.marshallerLoaderConnector.stop();
/*  759 */         this.marshallerLoaderConnector = null;
/*      */       }
/*  761 */       this.isStarted = false;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void create()
/*      */     throws Exception
/*      */   {
/*  773 */     if (!this.isCreated)
/*      */     {
/*      */       try
/*      */       {
/*  777 */         init();
/*  778 */         this.isCreated = true;
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  783 */         if (this.invoker != null)
/*      */         {
/*  785 */           this.invoker.stop();
/*  786 */           this.invoker.destroy();
/*  787 */           InvokerRegistry.destroyServerInvoker(this.invoker);
/*  788 */           this.invoker = null;
/*      */         }
/*  790 */         this.isCreated = false;
/*  791 */         throw e;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void destroy()
/*      */   {
/*  803 */     if (this.isStarted)
/*      */     {
/*  805 */       stop();
/*      */     }
/*  807 */     if (this.invoker != null)
/*      */     {
/*  809 */       this.invoker.stop();
/*  810 */       this.invoker.destroy();
/*  811 */       InvokerRegistry.destroyServerInvoker(this.invoker);
/*  812 */       this.invoker = null;
/*      */     }
/*  814 */     this.isCreated = false;
/*      */   }
/*      */ 
/*      */   public ServerInvoker getServerInvoker()
/*      */   {
/*  819 */     return this.invoker;
/*      */   }
/*      */ 
/*      */   public ServerInvocationHandler[] getInvocationHandlers()
/*      */   {
/*  829 */     ServerInvocationHandler[] handlers = null;
/*  830 */     if (this.invoker != null)
/*      */     {
/*  832 */       handlers = this.invoker.getInvocationHandlers();
/*      */     }
/*      */ 
/*  835 */     return handlers;
/*      */   }
/*      */ 
/*      */   public InvokerLocator getLocator()
/*      */   {
/*  848 */     return this.invoker.getLocator();
/*      */   }
/*      */ 
/*      */   public void setInvokerLocator(String locator)
/*      */     throws Exception
/*      */   {
/*  864 */     if (!this.isCreated)
/*      */     {
/*  866 */       this.locatorURI = locator;
/*      */     }
/*      */     else
/*      */     {
/*  870 */       throw new RuntimeException("Can not set the invoker locator on this Connector as has already been created with a different locator.");
/*      */     }
/*      */   }
/*      */ 
/*      */   public String getInvokerLocator()
/*      */     throws Exception
/*      */   {
/*  885 */     return this.locatorURI;
/*      */   }
/*      */ 
/*      */   public void setConfiguration(Element xml)
/*      */     throws Exception
/*      */   {
/*  902 */     this.xml = xml;
/*      */   }
/*      */ 
/*      */   public Element getConfiguration()
/*      */   {
/*  914 */     return this.xml;
/*      */   }
/*      */ 
/*      */   public ServerInvocationHandler addInvocationHandler(String subsystem, ObjectName handlerObjectName)
/*      */     throws Exception
/*      */   {
/*  939 */     ServerInvocationHandler invocationHandler = createHandlerProxy(handlerObjectName);
/*  940 */     return addInvocationHandler(subsystem, invocationHandler);
/*      */   }
/*      */ 
/*      */   public ServerInvocationHandler addInvocationHandler(String subsystem, ServerInvocationHandler handler)
/*      */     throws Exception
/*      */   {
/*  962 */     if (this.invoker == null)
/*      */     {
/*  964 */       throw new IllegalStateException("You may only add handlers once the Connector is created (via create() method).");
/*      */     }
/*      */ 
/*  967 */     handler.setMBeanServer(this.server);
/*  968 */     return this.invoker.addInvocationHandler(subsystem, handler);
/*      */   }
/*      */ 
/*      */   public void removeInvocationHandler(String subsystem)
/*      */     throws Exception
/*      */   {
/*  985 */     ServerInvocationHandler handler = this.invoker.removeInvocationHandler(subsystem);
/*      */ 
/*  987 */     if (handler != null)
/*      */     {
/*  989 */       handler.setMBeanServer(null);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setServerSocketFactory(ServerSocketFactory serverSocketFactory)
/*      */   {
/* 1000 */     if (this.isCreated)
/*      */     {
/* 1002 */       throw new RuntimeException("Can not set server socket factory on Connector after the create() method has been called.");
/*      */     }
/*      */ 
/* 1005 */     if (this.invoker != null)
/*      */     {
/* 1007 */       this.invoker.setServerSocketFactory(serverSocketFactory);
/*      */     }
/*      */     else
/*      */     {
/* 1011 */       this.svrSocketFactory = serverSocketFactory;
/*      */     }
/*      */   }
/*      */ 
/*      */   public ServerSocketFactory getServerSocketFactory()
/*      */   {
/* 1017 */     if (this.invoker != null)
/*      */     {
/* 1019 */       return this.invoker.getServerSocketFactory();
/*      */     }
/*      */ 
/* 1023 */     return this.svrSocketFactory;
/*      */   }
/*      */ 
/*      */   public void setSocketFactory(SocketFactory socketFactory)
/*      */   {
/* 1034 */     if (this.isCreated)
/*      */     {
/* 1036 */       throw new RuntimeException("Can not set socket factory on Connector after the create() method has been called.");
/*      */     }
/*      */ 
/* 1039 */     if (this.invoker != null)
/*      */     {
/* 1041 */       this.invoker.setSocketFactory(socketFactory);
/*      */     }
/*      */     else
/*      */     {
/* 1045 */       this.socketFactory = socketFactory;
/*      */     }
/*      */   }
/*      */ 
/*      */   public SocketFactory getSocketFactory()
/*      */   {
/* 1051 */     if (this.invoker != null)
/*      */     {
/* 1053 */       return this.invoker.getSocketFactory();
/*      */     }
/*      */ 
/* 1057 */     return this.socketFactory;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.transport.Connector
 * JD-Core Version:    0.6.0
 */