/*     */ package org.jboss.remoting.stream;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.InetAddress;
/*     */ import java.net.UnknownHostException;
/*     */ import javax.management.MBeanServer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.ServerInvocationHandler;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.remoting.transport.Connector;
/*     */ import org.jboss.remoting.transport.PortUtil;
/*     */ 
/*     */ public class StreamServer
/*     */ {
/*  56 */   private InputStream streamSource = null;
/*     */ 
/*  58 */   private String transport = "socket";
/*  59 */   private String host = "localhost";
/*  60 */   private int port = 5405;
/*     */ 
/*  62 */   private Connector connector = null;
/*     */ 
/*  64 */   private boolean internalConnector = true;
/*     */ 
/*  66 */   private static final Logger log = Logger.getLogger(StreamServer.class);
/*     */   public static final String STREAM_TRANSPORT_KEY = "remoting.stream.transport";
/*     */   public static final String STREAM_HOST_KEY = "remoting.stream.host";
/*     */   public static final String STREAM_PORT_KEY = "remoting.stream.port";
/*     */ 
/*     */   public StreamServer(InputStream stream)
/*     */     throws Exception
/*     */   {
/*  82 */     this.streamSource = stream;
/*  83 */     String locatorURI = getLocatorURI();
/*  84 */     setupServer(locatorURI);
/*     */   }
/*     */ 
/*     */   public StreamServer(InputStream stream, InvokerLocator locator) throws Exception
/*     */   {
/*  89 */     this.streamSource = stream;
/*  90 */     setupServer(locator.getLocatorURI());
/*     */   }
/*     */ 
/*     */   public StreamServer(InputStream stream, Connector connector) throws Exception
/*     */   {
/*  95 */     this.streamSource = stream;
/*  96 */     this.connector = connector;
/*  97 */     if (connector != null)
/*     */     {
/*  99 */       if (!connector.isStarted())
/*     */       {
/* 101 */         throw new IllegalStateException("Connector (" + connector + ") passed to act as stream server has not been started.");
/*     */       }
/* 103 */       ServerInvocationHandler invocationHandler = new Handler(connector);
/* 104 */       connector.addInvocationHandler("stream", invocationHandler);
/* 105 */       this.internalConnector = false;
/*     */     }
/*     */     else
/*     */     {
/* 109 */       throw new NullPointerException("Connector passed to act as stream server can not be null.");
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getLocatorURI()
/*     */     throws IOException
/*     */   {
/* 116 */     this.transport = System.getProperty("remoting.stream.transport", this.transport);
/*     */     try
/*     */     {
/* 119 */       this.host = InetAddress.getLocalHost().getHostName();
/*     */     }
/*     */     catch (UnknownHostException e)
/*     */     {
/*     */       try
/*     */       {
/* 125 */         this.host = InetAddress.getLocalHost().getHostAddress();
/*     */       }
/*     */       catch (UnknownHostException e1)
/*     */       {
/* 129 */         log.error("Stream server could not determine local host or address.");
/*     */       }
/*     */     }
/* 132 */     this.host = System.getProperty("remoting.stream.host", this.host);
/*     */ 
/* 134 */     String sPort = System.getProperty("remoting.stream.port", "" + PortUtil.findFreePort(this.host));
/*     */     try
/*     */     {
/* 137 */       this.port = Integer.parseInt(sPort);
/*     */     }
/*     */     catch (NumberFormatException e)
/*     */     {
/* 141 */       log.error("Stream server could not convert specified port " + sPort + " to a number.");
/*     */     }
/*     */ 
/* 144 */     return this.transport + "://" + this.host + ":" + this.port;
/*     */   }
/*     */ 
/*     */   public String getInvokerLocator()
/*     */     throws Exception
/*     */   {
/* 155 */     String locator = null;
/*     */ 
/* 157 */     if (this.connector != null)
/*     */     {
/* 159 */       locator = this.connector.getInvokerLocator();
/*     */     }
/* 161 */     return locator;
/*     */   }
/*     */ 
/*     */   public void setupServer(String locatorURI) throws Exception
/*     */   {
/* 166 */     InvokerLocator locator = new InvokerLocator(locatorURI);
/*     */ 
/* 168 */     this.connector = new Connector();
/* 169 */     this.connector.setInvokerLocator(locator.getLocatorURI());
/* 170 */     this.connector.create();
/*     */ 
/* 172 */     ServerInvocationHandler invocationHandler = new Handler(this.connector);
/* 173 */     this.connector.addInvocationHandler("stream", invocationHandler);
/*     */ 
/* 175 */     this.connector.start();
/*     */   }
/*     */ 
/*     */   public class Handler
/*     */     implements ServerInvocationHandler
/*     */   {
/* 185 */     private Connector connector = null;
/*     */ 
/*     */     public Handler(Connector connector)
/*     */     {
/* 189 */       this.connector = connector;
/*     */     }
/*     */ 
/*     */     public Object invoke(InvocationRequest invocation) throws Throwable
/*     */     {
/* 194 */       Object obj = invocation.getParameter();
/*     */ 
/* 197 */       if ((obj instanceof StreamCallPayload))
/*     */       {
/* 199 */         StreamCallPayload payload = (StreamCallPayload)obj;
/* 200 */         String method = payload.getMethod();
/*     */ 
/* 202 */         if ("read()".equals(method))
/*     */         {
/* 204 */           int i = StreamServer.this.streamSource.read();
/* 205 */           return new Integer(i);
/*     */         }
/* 207 */         if ("available()".equals(method))
/*     */         {
/* 209 */           int i = StreamServer.this.streamSource.available();
/* 210 */           return new Integer(i);
/*     */         }
/* 212 */         if ("close()".equals(method))
/*     */         {
/* 214 */           StreamServer.this.streamSource.close();
/* 215 */           if ((this.connector != null) && (StreamServer.this.internalConnector))
/*     */           {
/* 217 */             this.connector.stop();
/* 218 */             this.connector.destroy();
/*     */           }
/*     */         }
/* 221 */         else if ("reset()".equals(method))
/*     */         {
/* 223 */           StreamServer.this.streamSource.reset();
/*     */         } else {
/* 225 */           if ("markSupported()".equals(method))
/*     */           {
/* 227 */             boolean b = StreamServer.this.streamSource.markSupported();
/* 228 */             return new Boolean(b);
/*     */           }
/* 230 */           if ("mark(int readlimit)".equals(method))
/*     */           {
/* 232 */             Object[] param = payload.getParams();
/* 233 */             Integer intr = (Integer)param[0];
/* 234 */             int readLimit = intr.intValue();
/* 235 */             StreamServer.this.streamSource.mark(readLimit);
/*     */           } else {
/* 237 */             if ("skip(long n)".equals(method))
/*     */             {
/* 239 */               Object[] param = payload.getParams();
/* 240 */               Long lg = (Long)param[0];
/* 241 */               long n = lg.longValue();
/* 242 */               long ret = StreamServer.this.streamSource.skip(n);
/* 243 */               return new Long(ret);
/*     */             }
/* 245 */             if ("read(byte b[])".equals(method))
/*     */             {
/* 247 */               Object[] param = payload.getParams();
/* 248 */               byte[] byteParam = (byte[])param[0];
/* 249 */               int i = StreamServer.this.streamSource.read(byteParam);
/* 250 */               StreamCallPayload ret = new StreamCallPayload("read(byte b[])");
/* 251 */               ret.setParams(new Object[] { byteParam, new Integer(i) });
/* 252 */               return ret;
/*     */             }
/*     */ 
/* 256 */             throw new Exception("Unsupported method call - " + method);
/*     */           }
/*     */         }
/*     */       }
/*     */       else {
/* 261 */         StreamServer.log.error("Can not process invocation request because is not of type StreamCallPayload.");
/* 262 */         throw new Exception("Invalid payload type.  Must be of type StreamCallPayload.");
/*     */       }
/* 264 */       return null;
/*     */     }
/*     */ 
/*     */     public void addListener(InvokerCallbackHandler callbackHandler)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void removeListener(InvokerCallbackHandler callbackHandler)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void setMBeanServer(MBeanServer server)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void setInvoker(ServerInvoker invoker)
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.stream.StreamServer
 * JD-Core Version:    0.6.0
 */