/*     */ package org.jboss.remoting.stream;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ 
/*     */ public class StreamHandler extends InputStream
/*     */ {
/*  49 */   private InvokerLocator streamServerLocator = null;
/*  50 */   private Client streamClient = null;
/*     */ 
/*  52 */   private static final Logger log = Logger.getLogger(StreamHandler.class);
/*     */   public static final String READ = "read()";
/*     */   public static final String AVAILABLE = "available()";
/*     */   public static final String CLOSE = "close()";
/*     */   public static final String RESET = "reset()";
/*     */   public static final String MARKSUPPORTED = "markSupported()";
/*     */   public static final String MARKREADLIMIT = "mark(int readlimit)";
/*     */   public static final String SKIP = "skip(long n)";
/*     */   public static final String READBYTEARRAY = "read(byte b[])";
/*     */   public static final String READOFFSET = "read(byte b[], int off, int len)";
/*     */ 
/*     */   public StreamHandler(String locatorURL)
/*     */     throws Exception
/*     */   {
/*  75 */     this.streamServerLocator = new InvokerLocator(locatorURL);
/*  76 */     this.streamClient = new Client(this.streamServerLocator);
/*  77 */     this.streamClient.connect();
/*     */   }
/*     */ 
/*     */   public int available()
/*     */     throws IOException
/*     */   {
/*  97 */     int readInt = 0;
/*     */     try
/*     */     {
/* 101 */       Integer retInt = (Integer)this.streamClient.invoke(new StreamCallPayload("available()"));
/* 102 */       if (retInt != null)
/*     */       {
/* 104 */         readInt = retInt.intValue();
/*     */       }
/*     */     }
/*     */     catch (Throwable throwable)
/*     */     {
/* 109 */       log.error("Error getting available from client stream.", throwable);
/* 110 */       throw new IOException(throwable.getMessage());
/*     */     }
/* 112 */     return readInt;
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 128 */       this.streamClient.invoke(new StreamCallPayload("close()"));
/*     */     }
/*     */     catch (Throwable throwable)
/*     */     {
/* 132 */       log.error("Error closing client stream.", throwable);
/* 133 */       throw new IOException(throwable.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void reset()
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 186 */       this.streamClient.invoke(new StreamCallPayload("reset()"));
/*     */     }
/*     */     catch (Throwable throwable)
/*     */     {
/* 190 */       log.error("Error reseting client stream.", throwable);
/* 191 */       throw new IOException(throwable.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean markSupported()
/*     */   {
/* 209 */     boolean supported = false;
/*     */     try
/*     */     {
/* 213 */       Boolean bSupported = (Boolean)this.streamClient.invoke(new StreamCallPayload("markSupported()"));
/* 214 */       if (bSupported != null)
/*     */       {
/* 216 */         supported = bSupported.booleanValue();
/*     */       }
/*     */     }
/*     */     catch (Throwable throwable)
/*     */     {
/* 221 */       log.error("Error getting markSupported from client stream.", throwable);
/* 222 */       throw new RuntimeException(throwable.getMessage(), throwable);
/*     */     }
/* 224 */     return supported;
/*     */   }
/*     */ 
/*     */   public synchronized void mark(int readlimit)
/*     */   {
/*     */     try
/*     */     {
/* 255 */       StreamCallPayload payload = new StreamCallPayload("mark(int readlimit)");
/* 256 */       payload.setParams(new Object[] { new Integer(readlimit) });
/* 257 */       this.streamClient.invoke(payload);
/*     */     }
/*     */     catch (Throwable throwable)
/*     */     {
/* 261 */       log.error("Error marking with read limit on client stream.", throwable);
/* 262 */       throw new RuntimeException(throwable.getMessage(), throwable);
/*     */     }
/*     */   }
/*     */ 
/*     */   public long skip(long n)
/*     */     throws IOException
/*     */   {
/* 286 */     long numSkipped = -1L;
/*     */     try
/*     */     {
/* 290 */       StreamCallPayload payload = new StreamCallPayload("skip(long n)");
/* 291 */       payload.setParams(new Object[] { new Long(n) });
/* 292 */       Long ret = (Long)this.streamClient.invoke(payload);
/* 293 */       if (ret != null)
/*     */       {
/* 295 */         numSkipped = ret.longValue();
/*     */       }
/*     */     }
/*     */     catch (Throwable throwable)
/*     */     {
/* 300 */       log.error("Error skipping on client stream.", throwable);
/* 301 */       throw new IOException(throwable.getMessage());
/*     */     }
/*     */ 
/* 304 */     return numSkipped;
/*     */   }
/*     */ 
/*     */   public int read(byte[] b)
/*     */     throws IOException
/*     */   {
/* 346 */     if (b == null)
/*     */     {
/* 348 */       throw new NullPointerException("can not read for a null byte array.");
/*     */     }
/*     */ 
/* 352 */     if (b.length == 0)
/*     */     {
/* 354 */       return 0;
/*     */     }
/*     */ 
/* 358 */     int retByte = -1;
/*     */     try
/*     */     {
/* 362 */       StreamCallPayload payload = new StreamCallPayload("read(byte b[])");
/* 363 */       payload.setParams(new Object[] { b });
/* 364 */       StreamCallPayload ret = (StreamCallPayload)this.streamClient.invoke(payload);
/* 365 */       if (ret != null)
/*     */       {
/* 367 */         Object[] retVals = ret.getParams();
/* 368 */         byte[] retBytes = (byte[])retVals[0];
/* 369 */         Integer retInt = (Integer)retVals[1];
/*     */ 
/* 371 */         retByte = retInt.intValue();
/*     */ 
/* 373 */         if (retByte != -1)
/*     */         {
/* 375 */           System.arraycopy(retBytes, 0, b, 0, retByte);
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Throwable throwable)
/*     */     {
/* 381 */       log.error("Error reading from client stream.", throwable);
/* 382 */       throw new IOException(throwable.getMessage());
/*     */     }
/*     */ 
/* 385 */     return retByte;
/*     */   }
/*     */ 
/*     */   public int read(byte[] b, int off, int len)
/*     */     throws IOException
/*     */   {
/* 452 */     if (b == null)
/*     */     {
/* 454 */       throw new NullPointerException("can not read for a null byte array.");
/*     */     }
/*     */ 
/* 458 */     if (b.length == 0)
/*     */     {
/* 460 */       return 0;
/*     */     }
/*     */ 
/* 464 */     if ((off < 0) || (len < 0) || (off + len > b.length))
/*     */     {
/* 466 */       throw new IndexOutOfBoundsException("Either off or len is negative or off+len is greater than length of b.");
/*     */     }
/* 468 */     if (len == 0)
/*     */     {
/* 470 */       return 0;
/*     */     }
/*     */ 
/* 475 */     int retByte = -1;
/*     */     try
/*     */     {
/* 479 */       byte[] payloadArray = new byte[len];
/* 480 */       StreamCallPayload payload = new StreamCallPayload("read(byte b[])");
/* 481 */       payload.setParams(new Object[] { payloadArray });
/* 482 */       StreamCallPayload ret = (StreamCallPayload)this.streamClient.invoke(payload);
/* 483 */       if (ret != null)
/*     */       {
/* 485 */         Object[] retVals = ret.getParams();
/* 486 */         byte[] retBytes = (byte[])retVals[0];
/* 487 */         Integer retInt = (Integer)retVals[1];
/*     */ 
/* 489 */         retByte = retInt.intValue();
/*     */ 
/* 491 */         if (retByte != -1)
/*     */         {
/* 493 */           System.arraycopy(retBytes, 0, b, off, retByte);
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Throwable throwable)
/*     */     {
/* 499 */       log.error("Error reading with offset from client stream.", throwable);
/* 500 */       throw new IOException(throwable.getMessage());
/*     */     }
/*     */ 
/* 503 */     return retByte;
/*     */   }
/*     */ 
/*     */   public int read()
/*     */     throws IOException
/*     */   {
/* 522 */     int readInt = -1;
/*     */     try
/*     */     {
/* 526 */       Integer retInt = (Integer)this.streamClient.invoke(new StreamCallPayload("read()"));
/* 527 */       if (retInt != null)
/*     */       {
/* 529 */         readInt = retInt.intValue();
/*     */       }
/*     */     }
/*     */     catch (Throwable throwable)
/*     */     {
/* 534 */       log.error("Error reading from client stream.", throwable);
/* 535 */       throw new IOException(throwable.getMessage());
/*     */     }
/* 537 */     return readInt;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.stream.StreamHandler
 * JD-Core Version:    0.6.0
 */