/*     */ package org.jboss.remoting.socketfactory;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Serializable;
/*     */ import java.net.InetAddress;
/*     */ import java.net.Socket;
/*     */ import java.net.UnknownHostException;
/*     */ import javax.net.SocketFactory;
/*     */ import javax.net.ssl.SSLSocketFactory;
/*     */ 
/*     */ public class CreationListenerSocketFactory extends SSLSocketFactory
/*     */   implements SocketFactoryWrapper, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1210774093889434553L;
/*     */   private SocketFactory factory;
/*     */   private SocketCreationListener listener;
/*     */ 
/*     */   public CreationListenerSocketFactory(SocketCreationListener listener)
/*     */   {
/*  55 */     this(SocketFactory.getDefault(), listener);
/*     */   }
/*     */ 
/*     */   public CreationListenerSocketFactory(SocketFactory factory, SocketCreationListener listener)
/*     */   {
/*  61 */     this.factory = factory;
/*  62 */     this.listener = listener;
/*     */   }
/*     */ 
/*     */   public SocketFactory getFactory()
/*     */   {
/*  67 */     return this.factory;
/*     */   }
/*     */ 
/*     */   public SocketCreationListener getListener()
/*     */   {
/*  73 */     return this.listener;
/*     */   }
/*     */ 
/*     */   public void setFactory(SocketFactory factory)
/*     */   {
/*  79 */     this.factory = factory;
/*     */   }
/*     */ 
/*     */   public void setListener(SocketCreationListener listener)
/*     */   {
/*  85 */     this.listener = listener;
/*     */   }
/*     */ 
/*     */   public Socket createSocket()
/*     */     throws IOException
/*     */   {
/*  91 */     checkFactory();
/*  92 */     Socket socket = this.factory.createSocket();
/*  93 */     this.listener.socketCreated(socket, this.factory);
/*  94 */     return socket;
/*     */   }
/*     */ 
/*     */   public Socket createSocket(String host, int port)
/*     */     throws IOException, UnknownHostException
/*     */   {
/* 101 */     checkFactory();
/* 102 */     Socket socket = this.factory.createSocket(host, port);
/* 103 */     this.listener.socketCreated(socket, this.factory);
/* 104 */     return socket;
/*     */   }
/*     */ 
/*     */   public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort)
/*     */     throws IOException, UnknownHostException
/*     */   {
/* 111 */     checkFactory();
/* 112 */     Socket socket = this.factory.createSocket(host, port, clientHost, clientPort);
/* 113 */     this.listener.socketCreated(socket, this.factory);
/* 114 */     return socket;
/*     */   }
/*     */ 
/*     */   public Socket createSocket(InetAddress host, int port)
/*     */     throws IOException
/*     */   {
/* 120 */     checkFactory();
/* 121 */     Socket socket = this.factory.createSocket(host, port);
/* 122 */     this.listener.socketCreated(socket, this.factory);
/* 123 */     return socket;
/*     */   }
/*     */ 
/*     */   public Socket createSocket(InetAddress address, int port, InetAddress clientAddress, int clientPort)
/*     */     throws IOException
/*     */   {
/* 130 */     checkFactory();
/* 131 */     Socket socket = this.factory.createSocket(address, port, clientAddress, clientPort);
/* 132 */     this.listener.socketCreated(socket, this.factory);
/* 133 */     return socket;
/*     */   }
/*     */ 
/*     */   public String[] getDefaultCipherSuites()
/*     */   {
/* 139 */     if ((this.factory instanceof SSLSocketFactory)) {
/* 140 */       return ((SSLSocketFactory)this.factory).getDefaultCipherSuites();
/*     */     }
/* 142 */     return null;
/*     */   }
/*     */ 
/*     */   public String[] getSupportedCipherSuites()
/*     */   {
/* 148 */     if ((this.factory instanceof SSLSocketFactory)) {
/* 149 */       return ((SSLSocketFactory)this.factory).getSupportedCipherSuites();
/*     */     }
/* 151 */     return null;
/*     */   }
/*     */ 
/*     */   public Socket createSocket(Socket s, String host, int port, boolean autoClose)
/*     */     throws IOException
/*     */   {
/* 157 */     if ((this.factory instanceof SSLSocketFactory))
/*     */     {
/* 159 */       Socket socket = ((SSLSocketFactory)this.factory).createSocket(s, host, port, autoClose);
/* 160 */       this.listener.socketCreated(socket, this.factory);
/* 161 */       return socket;
/*     */     }
/*     */ 
/* 164 */     return null;
/*     */   }
/*     */ 
/*     */   public SocketFactory getSocketFactory()
/*     */   {
/* 170 */     return this.factory;
/*     */   }
/*     */ 
/*     */   public void setSocketFactory(SocketFactory factory)
/*     */   {
/* 176 */     this.factory = factory;
/*     */   }
/*     */ 
/*     */   protected void checkFactory()
/*     */   {
/* 182 */     if (this.factory == null)
/* 183 */       this.factory = SocketFactory.getDefault();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.socketfactory.CreationListenerSocketFactory
 * JD-Core Version:    0.6.0
 */