/*     */ package org.jboss.remoting.socketfactory;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Serializable;
/*     */ import java.net.InetAddress;
/*     */ import java.net.ServerSocket;
/*     */ import javax.net.ServerSocketFactory;
/*     */ 
/*     */ public class CreationListenerServerSocketFactory extends ServerSocketFactory
/*     */   implements ServerSocketFactoryWrapper, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -7939318527267014514L;
/*     */   private ServerSocketFactory factory;
/*     */   private SocketCreationListener listener;
/*     */ 
/*     */   public CreationListenerServerSocketFactory(ServerSocketFactory factory, SocketCreationListener listener)
/*     */   {
/*  55 */     this.factory = factory;
/*  56 */     this.listener = listener;
/*     */   }
/*     */ 
/*     */   public ServerSocketFactory getFactory()
/*     */   {
/*  62 */     return this.factory;
/*     */   }
/*     */ 
/*     */   public SocketCreationListener getListener()
/*     */   {
/*  68 */     return this.listener;
/*     */   }
/*     */ 
/*     */   public void setFactory(ServerSocketFactory factory)
/*     */   {
/*  74 */     this.factory = factory;
/*     */   }
/*     */ 
/*     */   public void setListener(SocketCreationListener listener)
/*     */   {
/*  80 */     this.listener = listener;
/*     */   }
/*     */ 
/*     */   public ServerSocket createServerSocket()
/*     */     throws IOException
/*     */   {
/*  86 */     ServerSocket serverSocket = this.factory.createServerSocket();
/*  87 */     return new CreationListenerServerSocket(serverSocket, this.listener);
/*     */   }
/*     */ 
/*     */   public ServerSocket createServerSocket(int port)
/*     */     throws IOException
/*     */   {
/*  93 */     ServerSocket serverSocket = this.factory.createServerSocket(port);
/*  94 */     return new CreationListenerServerSocket(serverSocket, this.listener);
/*     */   }
/*     */ 
/*     */   public ServerSocket createServerSocket(int port, int backlog)
/*     */     throws IOException
/*     */   {
/* 100 */     ServerSocket serverSocket = this.factory.createServerSocket(port, backlog);
/* 101 */     return new CreationListenerServerSocket(serverSocket, this.listener);
/*     */   }
/*     */ 
/*     */   public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress)
/*     */     throws IOException
/*     */   {
/* 108 */     ServerSocket serverSocket = this.factory.createServerSocket(port, backlog, ifAddress);
/* 109 */     return new CreationListenerServerSocket(serverSocket, this.listener);
/*     */   }
/*     */ 
/*     */   public ServerSocketFactory getServerSocketFactory()
/*     */   {
/* 115 */     return this.factory;
/*     */   }
/*     */ 
/*     */   public void setServerSocketFactory(ServerSocketFactory factory)
/*     */   {
/* 121 */     this.factory = factory;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.socketfactory.CreationListenerServerSocketFactory
 * JD-Core Version:    0.6.0
 */