/*     */ package org.jboss.remoting.serialization.impl.jboss;
/*     */ 
/*     */ import java.io.BufferedOutputStream;
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.serialization.RemotingMarshalledValue;
/*     */ import org.jboss.serial.objectmetamodel.DataContainer;
/*     */ import org.jboss.serial.objectmetamodel.ObjectsCache;
/*     */ import org.jboss.serial.objectmetamodel.safecloning.SafeCloningRepository;
/*     */ 
/*     */ public class LocalMarshalledValue extends RemotingMarshalledValue
/*     */   implements Externalizable
/*     */ {
/*  53 */   protected static final Logger log = Logger.getLogger(JBossSerializationManager.class);
/*     */   DataContainer container;
/*     */   private static final long serialVersionUID = 6996297171147626666L;
/*     */ 
/*     */   public LocalMarshalledValue()
/*     */   {
/*     */   }
/*     */ 
/*     */   public LocalMarshalledValue(Object obj)
/*     */     throws IOException
/*     */   {
/*  64 */     this.container = new DataContainer(false);
/*  65 */     ObjectOutput output = this.container.getOutput();
/*  66 */     output.writeObject(obj);
/*  67 */     output.flush();
/*  68 */     this.container.flush();
/*     */   }
/*     */ 
/*     */   public LocalMarshalledValue(Object obj, SafeCloningRepository safeToReuse) throws IOException
/*     */   {
/*  73 */     this.container = new DataContainer(null, null, safeToReuse, false);
/*  74 */     ObjectOutput output = this.container.getOutput();
/*  75 */     output.writeObject(obj);
/*  76 */     output.flush();
/*  77 */     this.container.flush();
/*     */   }
/*     */ 
/*     */   public Object get()
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*     */     try
/*     */     {
/*  87 */       this.container.getCache().setLoader(Thread.currentThread().getContextClassLoader());
/*  88 */       return this.container.getInput().readObject();
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/*  92 */       log.error(e, e);
/*  93 */     }throw e;
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/*  99 */     log.warn("LocalmarshalledValue writeExternal is deprecated. This version is best used on call-by-value operations");
/* 100 */     ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
/* 101 */     BufferedOutputStream buffOut = new BufferedOutputStream(byteOut);
/* 102 */     DataOutputStream dataOut = new DataOutputStream(buffOut);
/* 103 */     this.container.saveData(dataOut);
/* 104 */     dataOut.flush();
/* 105 */     byte[] arrayBytes = byteOut.toByteArray();
/* 106 */     out.writeInt(arrayBytes.length);
/* 107 */     out.write(arrayBytes);
/* 108 */     out.flush();
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
/*     */   {
/* 113 */     log.warn("LocalmarshalledValue readExternal is deprecated. This version is best used on call-by-value operations");
/* 114 */     byte[] bytes = new byte[in.readInt()];
/* 115 */     in.readFully(bytes);
/* 116 */     ByteArrayInputStream byteInput = new ByteArrayInputStream(bytes);
/* 117 */     DataInputStream input = new DataInputStream(byteInput);
/* 118 */     this.container = new DataContainer(false);
/* 119 */     this.container.loadData(input);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.serialization.impl.jboss.LocalMarshalledValue
 * JD-Core Version:    0.6.0
 */