/*     */ package org.jboss.remoting.serialization.impl.jboss;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.OutputStream;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.loading.ObjectInputStreamWithClassLoader;
/*     */ import org.jboss.remoting.serialization.IMarshalledValue;
/*     */ import org.jboss.remoting.serialization.SerializationManager;
/*     */ import org.jboss.remoting.serialization.SerializationStreamFactory;
/*     */ import org.jboss.serial.io.JBossObjectInputStream;
/*     */ import org.jboss.serial.io.JBossObjectOutputStream;
/*     */ import org.jboss.serial.util.StringUtilBuffer;
/*     */ 
/*     */ public class JBossSerializationManager extends SerializationManager
/*     */ {
/*  50 */   protected static final Logger log = Logger.getLogger(JBossSerializationManager.class);
/*     */ 
/*  52 */   private static boolean trace = log.isTraceEnabled();
/*     */ 
/*     */   public ObjectInputStream createInput(InputStream input, ClassLoader loader) throws IOException
/*     */   {
/*  56 */     if (trace) log.trace(this + " creating JBossObjectInputStream");
/*  57 */     return new JBossObjectInputStream(input, loader, new StringUtilBuffer(10024, 10024));
/*     */   }
/*     */ 
/*     */   public ObjectOutputStream createOutput(OutputStream output) throws IOException
/*     */   {
/*  62 */     if (trace) log.trace(this + " creating JBossObjectOutputStream");
/*  63 */     return new JBossObjectOutputStream(output, new StringUtilBuffer(10024, 10024));
/*     */   }
/*     */ 
/*     */   public IMarshalledValue createdMarshalledValue(Object source)
/*     */     throws IOException
/*     */   {
/*  71 */     if ((source instanceof IMarshalledValue))
/*     */     {
/*  73 */       return (IMarshalledValue)source;
/*     */     }
/*     */ 
/*  77 */     return new MarshalledValue(source);
/*     */   }
/*     */ 
/*     */   public IMarshalledValue createMarshalledValueForClone(Object original)
/*     */     throws IOException
/*     */   {
/*  83 */     return new SmartCloningMarshalledValue(original);
/*     */   }
/*     */ 
/*     */   public void sendObject(ObjectOutputStream oos, Object dataObject, int version)
/*     */     throws IOException
/*     */   {
/*  89 */     oos.writeObject(dataObject);
/*  90 */     oos.flush();
/*     */   }
/*     */ 
/*     */   public Object receiveObject(InputStream inputStream, ClassLoader customClassLoader, int version)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  96 */     ObjectInputStream objInputStream = null;
/*  97 */     Object obj = null;
/*  98 */     if ((inputStream instanceof ObjectInputStreamWithClassLoader))
/*     */     {
/* 100 */       if (((ObjectInputStreamWithClassLoader)inputStream).getClassLoader() == null)
/*     */       {
/* 102 */         ((ObjectInputStreamWithClassLoader)inputStream).setClassLoader(customClassLoader);
/*     */       }
/* 104 */       objInputStream = (ObjectInputStream)inputStream;
/*     */     }
/* 106 */     else if ((inputStream instanceof JBossObjectInputStream))
/*     */     {
/* 108 */       if (((JBossObjectInputStream)inputStream).getClassLoader() == null)
/*     */       {
/* 110 */         ((JBossObjectInputStream)inputStream).setClassLoader(customClassLoader);
/*     */       }
/* 112 */       objInputStream = (ObjectInputStream)inputStream;
/*     */     }
/* 114 */     else if ((inputStream instanceof ObjectInputStream))
/*     */     {
/* 116 */       objInputStream = (ObjectInputStream)inputStream;
/*     */     }
/* 120 */     else if (customClassLoader != null)
/*     */     {
/* 122 */       objInputStream = SerializationStreamFactory.getManagerInstance("jboss").createInput(inputStream, customClassLoader);
/*     */     }
/*     */     else
/*     */     {
/* 126 */       objInputStream = SerializationStreamFactory.getManagerInstance("jboss").createRegularInput(inputStream);
/*     */     }
/*     */ 
/* 130 */     obj = objInputStream.readObject();
/* 131 */     return obj;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 136 */     return "JBossSerializationManager[" + Integer.toHexString(hashCode()) + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.serialization.impl.jboss.JBossSerializationManager
 * JD-Core Version:    0.6.0
 */