/*     */ package org.jboss.remoting.serialization.impl.java;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectStreamClass;
/*     */ import java.lang.reflect.Proxy;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class MarshalledValueInputStream extends ObjectInputStream
/*     */ {
/*  45 */   private static Logger log = Logger.getLogger(MarshalledValueInputStream.class);
/*     */ 
/*  47 */   static boolean useClassCache = false;
/*     */ 
/*     */   public MarshalledValueInputStream(InputStream is)
/*     */     throws IOException
/*     */   {
/*  54 */     super(is);
/*     */   }
/*     */ 
/*     */   protected Class resolveClass(ObjectStreamClass v)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  65 */     String className = v.getName();
/*  66 */     Class resolvedClass = null;
/*     */ 
/*  68 */     if (resolvedClass == null)
/*     */     {
/*  70 */       ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*     */       try
/*     */       {
/*  73 */         resolvedClass = Class.forName(className, false, loader);
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/*  81 */         resolvedClass = super.resolveClass(v);
/*     */       }
/*     */     }
/*  84 */     return resolvedClass;
/*     */   }
/*     */ 
/*     */   protected Class resolveProxyClass(String[] interfaces)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  90 */     if (log.isTraceEnabled())
/*     */     {
/*  92 */       StringBuffer tmp = new StringBuffer("[");
/*  93 */       for (int i = 0; i < interfaces.length; i++)
/*     */       {
/*  95 */         if (i > 0)
/*     */         {
/*  97 */           tmp.append(',');
/*     */         }
/*  99 */         tmp.append(interfaces[i]);
/*     */       }
/* 101 */       tmp.append(']');
/* 102 */       log.trace("resolveProxyClass called, ifaces=" + tmp.toString());
/*     */     }
/*     */ 
/* 106 */     ClassLoader loader = null;
/* 107 */     Class[] ifaceClasses = new Class[interfaces.length];
/* 108 */     for (int i = 0; i < interfaces.length; i++)
/*     */     {
/* 110 */       Class iface = null;
/* 111 */       String className = interfaces[i];
/*     */ 
/* 115 */       if (iface == null)
/*     */       {
/* 117 */         if (loader == null)
/*     */         {
/* 119 */           loader = Thread.currentThread().getContextClassLoader();
/*     */         }
/* 121 */         iface = Class.forName(className, false, loader);
/*     */       }
/* 123 */       ifaceClasses[i] = iface;
/*     */     }
/*     */ 
/* 126 */     return Proxy.getProxyClass(loader, ifaceClasses);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.serialization.impl.java.MarshalledValueInputStream
 * JD-Core Version:    0.6.0
 */