/*     */ package org.jboss.remoting.serialization.impl.java;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.OutputStream;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.loading.ObjectInputStreamWithClassLoader;
/*     */ import org.jboss.remoting.serialization.IMarshalledValue;
/*     */ import org.jboss.remoting.serialization.SerializationManager;
/*     */ import org.jboss.remoting.serialization.SerializationStreamFactory;
/*     */ 
/*     */ public class JavaSerializationManager extends SerializationManager
/*     */ {
/*  46 */   protected static final Logger log = Logger.getLogger(JavaSerializationManager.class);
/*     */ 
/*     */   public ObjectInputStream createInput(InputStream input, ClassLoader loader) throws IOException
/*     */   {
/*  50 */     if (log.isTraceEnabled())
/*     */     {
/*  52 */       log.trace("Creating ObjectInputStreamWithClassLoader");
/*     */     }
/*  54 */     return new ObjectInputStreamWithClassLoader(input, loader);
/*     */   }
/*     */ 
/*     */   public ObjectOutputStream createOutput(OutputStream output) throws IOException
/*     */   {
/*  59 */     if (log.isTraceEnabled())
/*     */     {
/*  61 */       log.trace("Creating ObjectOutputStream");
/*     */     }
/*  63 */     return new ObjectOutputStream(output);
/*     */   }
/*     */ 
/*     */   public IMarshalledValue createdMarshalledValue(Object source)
/*     */     throws IOException
/*     */   {
/*  71 */     if ((source instanceof IMarshalledValue))
/*     */     {
/*  73 */       return (IMarshalledValue)source;
/*     */     }
/*     */ 
/*  77 */     return new JavaMarshalledValue(source);
/*     */   }
/*     */ 
/*     */   public IMarshalledValue createMarshalledValueForClone(Object original) throws IOException
/*     */   {
/*  82 */     return createdMarshalledValue(original);
/*     */   }
/*     */ 
/*     */   public void sendObject(ObjectOutputStream oos, Object dataObject, int version) throws IOException
/*     */   {
/*  87 */     switch (version)
/*     */     {
/*     */     case 1:
/*     */     case 2:
/*  91 */       sendObjectVersion1_2(oos, dataObject);
/*  92 */       break;
/*     */     case 22:
/*  95 */       sendObjectVersion2_2(oos, dataObject);
/*  96 */       break;
/*     */     default:
/*  99 */       throw new IOException("Can not process version " + version + ". " + "Supported versions: " + 1 + ", " + 2 + ", " + 22);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void sendObjectVersion1_2(ObjectOutputStream oos, Object dataObject)
/*     */     throws IOException
/*     */   {
/* 107 */     oos.writeObject(dataObject);
/* 108 */     oos.reset();
/*     */ 
/* 112 */     oos.writeObject(Boolean.TRUE);
/* 113 */     oos.flush();
/* 114 */     oos.reset();
/*     */   }
/*     */ 
/*     */   protected void sendObjectVersion2_2(ObjectOutputStream oos, Object dataObject) throws IOException
/*     */   {
/* 119 */     oos.reset();
/* 120 */     oos.writeObject(dataObject);
/* 121 */     oos.flush();
/*     */   }
/*     */ 
/*     */   public Object receiveObject(InputStream inputStream, ClassLoader customClassLoader, int version) throws IOException, ClassNotFoundException
/*     */   {
/* 126 */     switch (version)
/*     */     {
/*     */     case 1:
/*     */     case 2:
/* 130 */       return receiveObjectVersion1_2(inputStream, customClassLoader);
/*     */     case 22:
/* 133 */       return receiveObjectVersion2_2(inputStream, customClassLoader);
/*     */     }
/*     */ 
/* 136 */     throw new IOException("Can not process version " + version + ". " + "Supported versions: " + 1 + ", " + 2 + ", " + 22);
/*     */   }
/*     */ 
/*     */   protected Object receiveObjectVersion1_2(InputStream inputStream, ClassLoader customClassLoader)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 144 */     ObjectInputStream objInputStream = null;
/* 145 */     Object obj = null;
/* 146 */     if ((inputStream instanceof ObjectInputStreamWithClassLoader))
/*     */     {
/* 148 */       if (((ObjectInputStreamWithClassLoader)inputStream).getClassLoader() == null)
/*     */       {
/* 150 */         ((ObjectInputStreamWithClassLoader)inputStream).setClassLoader(customClassLoader);
/*     */       }
/* 152 */       objInputStream = (ObjectInputStream)inputStream;
/*     */     }
/* 162 */     else if ((inputStream instanceof ObjectInputStream))
/*     */     {
/* 164 */       objInputStream = (ObjectInputStream)inputStream;
/*     */     }
/* 168 */     else if (customClassLoader != null)
/*     */     {
/* 170 */       objInputStream = SerializationStreamFactory.getManagerInstance("java").createInput(inputStream, customClassLoader);
/*     */     }
/*     */     else
/*     */     {
/* 174 */       objInputStream = SerializationStreamFactory.getManagerInstance("java").createRegularInput(inputStream);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 180 */       obj = objInputStream.readObject();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 184 */       log.error("", e);
/* 185 */       throw e;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 190 */       objInputStream.readObject();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*     */ 
/* 199 */     return obj;
/*     */   }
/*     */ 
/*     */   protected Object receiveObjectVersion2_2(InputStream inputStream, ClassLoader customClassLoader) throws IOException, ClassNotFoundException
/*     */   {
/* 204 */     ObjectInputStream objInputStream = null;
/* 205 */     Object obj = null;
/* 206 */     if ((inputStream instanceof ObjectInputStreamWithClassLoader))
/*     */     {
/* 208 */       if (((ObjectInputStreamWithClassLoader)inputStream).getClassLoader() == null)
/*     */       {
/* 210 */         ((ObjectInputStreamWithClassLoader)inputStream).setClassLoader(customClassLoader);
/*     */       }
/* 212 */       objInputStream = (ObjectInputStream)inputStream;
/*     */     }
/* 222 */     else if ((inputStream instanceof ObjectInputStream))
/*     */     {
/* 224 */       objInputStream = (ObjectInputStream)inputStream;
/*     */     }
/* 228 */     else if (customClassLoader != null)
/*     */     {
/* 230 */       objInputStream = SerializationStreamFactory.getManagerInstance("java").createInput(inputStream, customClassLoader);
/*     */     }
/*     */     else
/*     */     {
/* 234 */       objInputStream = SerializationStreamFactory.getManagerInstance("java").createRegularInput(inputStream);
/*     */     }
/*     */ 
/* 239 */     obj = objInputStream.readObject();
/*     */ 
/* 241 */     if ((inputStream instanceof ObjectInputStreamWithClassLoader))
/*     */     {
/* 243 */       ((ObjectInputStreamWithClassLoader)inputStream).clearCache();
/*     */     }
/*     */ 
/* 246 */     return obj;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.serialization.impl.java.JavaSerializationManager
 * JD-Core Version:    0.6.0
 */