/*    */ package org.jboss.remoting.serialization.impl.java;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import java.io.ObjectOutputStream;
/*    */ import java.io.Serializable;
/*    */ import javax.crypto.SealedObject;
/*    */ import org.jboss.remoting.marshal.encryption.EncryptionUtil;
/*    */ 
/*    */ public class JavaEncryptionSerializationManager extends JavaSerializationManager
/*    */ {
/*    */   public Object receiveObject(InputStream inputStream, ClassLoader customClassLoader, int version)
/*    */     throws IOException, ClassNotFoundException
/*    */   {
/* 47 */     Object obj = super.receiveObject(inputStream, customClassLoader, version);
/* 48 */     if ((obj instanceof SealedObject))
/*    */     {
/*    */       try
/*    */       {
/* 52 */         obj = EncryptionUtil.unsealObject((SealedObject)obj);
/*    */       }
/*    */       catch (Exception e)
/*    */       {
/* 56 */         e.printStackTrace();
/*    */       }
/*    */     }
/* 59 */     return obj;
/*    */   }
/*    */ 
/*    */   public void sendObject(ObjectOutputStream oos, Object dataObject, int version) throws IOException
/*    */   {
/* 64 */     if ((dataObject instanceof Serializable))
/*    */       try
/*    */       {
/* 67 */         dataObject = EncryptionUtil.sealObject((Serializable)dataObject);
/*    */       }
/*    */       catch (Exception e)
/*    */       {
/* 71 */         e.printStackTrace();
/*    */       }
/* 73 */     super.sendObject(oos, dataObject, version);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.serialization.impl.java.JavaEncryptionSerializationManager
 * JD-Core Version:    0.6.0
 */