/*      */ package org.jboss.remoting.security;
/*      */ 
/*      */ import java.io.File;
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.lang.reflect.Method;
/*      */ import java.net.MalformedURLException;
/*      */ import java.net.URL;
/*      */ import java.security.KeyStore;
/*      */ import java.security.KeyStoreException;
/*      */ import java.security.NoSuchAlgorithmException;
/*      */ import java.security.NoSuchProviderException;
/*      */ import java.security.Provider;
/*      */ import java.security.SecureRandom;
/*      */ import java.security.UnrecoverableKeyException;
/*      */ import java.security.cert.CertificateException;
/*      */ import java.security.cert.X509Certificate;
/*      */ import java.util.Map;
/*      */ import javax.net.ServerSocketFactory;
/*      */ import javax.net.SocketFactory;
/*      */ import javax.net.ssl.KeyManager;
/*      */ import javax.net.ssl.KeyManagerFactory;
/*      */ import javax.net.ssl.SSLContext;
/*      */ import javax.net.ssl.SSLServerSocketFactory;
/*      */ import javax.net.ssl.SSLSocketFactory;
/*      */ import javax.net.ssl.TrustManager;
/*      */ import javax.net.ssl.TrustManagerFactory;
/*      */ import javax.net.ssl.X509KeyManager;
/*      */ import javax.net.ssl.X509TrustManager;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.remoting.serialization.ClassLoaderUtility;
/*      */ import org.jboss.remoting.util.socket.RemotingKeyManager;
/*      */ 
/*      */ public class SSLSocketBuilder
/*      */   implements SSLSocketBuilderMBean, Cloneable
/*      */ {
/*      */   public static final String REMOTING_SSL_PROVIDER_NAME = "org.jboss.remoting.sslProviderName";
/*      */   public static final String REMOTING_SSL_PROTOCOL = "org.jboss.remoting.sslProtocol";
/*      */   public static final String DEFAULT_SSL_PROTOCOL = "TLS";
/*      */   public static final String REMOTING_SOCKET_USE_CLIENT_MODE = "org.jboss.remoting.socket.useClientMode";
/*      */   public static final String REMOTING_SERVER_SOCKET_USE_CLIENT_MODE = "org.jboss.remoting.serversocket.useClientMode";
/*      */   public static final String REMOTING_CLIENT_AUTH_MODE = "org.jboss.remoting.clientAuthMode";
/*      */   public static final String CLIENT_AUTH_MODE_NONE = "none";
/*      */   public static final String CLIENT_AUTH_MODE_WANT = "want";
/*      */   public static final String CLIENT_AUTH_MODE_NEED = "need";
/*      */   public static final String REMOTING_SERVER_AUTH_MODE = "org.jboss.remoting.serverAuthMode";
/*      */   public static final String REMOTING_KEY_STORE_FILE_PATH = "org.jboss.remoting.keyStore";
/*      */   public static final String REMOTING_KEY_STORE_TYPE = "org.jboss.remoting.keyStoreType";
/*      */   public static final String REMOTING_KEY_STORE_ALGORITHM = "org.jboss.remoting.keyStoreAlgorithm";
/*      */   public static final String REMOTING_KEY_STORE_PASSWORD = "org.jboss.remoting.keyStorePassword";
/*      */   public static final String REMOTING_KEY_ALIAS = "org.jboss.remoting.keyAlias";
/*      */   public static final String REMOTING_KEY_PASSWORD = "org.jboss.remoting.keyPassword";
/*      */   public static final String STANDARD_KEY_STORE_FILE_PATH = "javax.net.ssl.keyStore";
/*      */   public static final String STANDARD_KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
/*      */   public static final String STANDARD_KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
/*      */   public static final String DEFAULT_KEY_STORE_TYPE = "JKS";
/*      */   public static final String DEFAULT_KEY_STORE_ALGORITHM = "SunX509";
/*      */   public static final String REMOTING_TRUST_STORE_FILE_PATH = "org.jboss.remoting.trustStore";
/*      */   public static final String REMOTING_TRUST_STORE_TYPE = "org.jboss.remoting.trustStoreType";
/*      */   public static final String REMOTING_TRUST_STORE_ALGORITHM = "org.jboss.remoting.trustStoreAlgorithm";
/*      */   public static final String REMOTING_TRUST_STORE_PASSWORD = "org.jboss.remoting.trustStorePassword";
/*      */   public static final String STANDARD_TRUST_STORE_FILE_PATH = "javax.net.ssl.trustStore";
/*      */   public static final String STANDARD_TRUST_STORE_TYPE = "javax.net.ssl.trustStoreType";
/*      */   public static final String STANDARD_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
/*      */   public static final String REMOTING_DEFAULT_SOCKET_FACTORY_CLASS = "org.jboss.remoting.defaultSocketFactory";
/*  233 */   private SSLContext sslContextServerSocketFactory = null;
/*  234 */   private SSLContext sslContextSocketFactory = null;
/*  235 */   private Provider provider = null;
/*  236 */   private String providerName = null;
/*  237 */   private String secureSocketProtocol = null;
/*      */ 
/*  239 */   private KeyManager[] keyManagers = null;
/*  240 */   private TrustManager[] trustManagers = null;
/*  241 */   private SecureRandom secureRandom = null;
/*      */ 
/*  243 */   private URL keyStoreFilePath = null;
/*  244 */   private String keyStoreType = null;
/*  245 */   private String keyStoreAlgorithm = null;
/*  246 */   private String keyStorePassword = null;
/*  247 */   private String keyAlias = null;
/*  248 */   private String keyPassword = null;
/*      */ 
/*  250 */   private URL trustStoreFilePath = null;
/*  251 */   private String trustStoreType = null;
/*  252 */   private String trustStoreAlgorithm = null;
/*  253 */   private String trustStorePassword = null;
/*      */ 
/*  255 */   private Map config = null;
/*  256 */   private Boolean socketUseClientMode = null;
/*  257 */   private Boolean serverSocketUseClientMode = null;
/*  258 */   private String clientAuthMode = null;
/*  259 */   private Boolean serverAuthMode = null;
/*      */ 
/*  261 */   private boolean useSSLServerSocketFactory = true;
/*  262 */   private boolean useSSLSocketFactory = true;
/*      */ 
/*  264 */   private static final Logger log = Logger.getLogger(SSLSocketBuilder.class);
/*      */ 
/*      */   public SSLSocketBuilder()
/*      */   {
/*  272 */     this(null);
/*      */   }
/*      */ 
/*      */   public SSLSocketBuilder(Map config)
/*      */   {
/*  285 */     this.config = config;
/*      */   }
/*      */ 
/*      */   public void setUseSSLServerSocketFactory(boolean shouldUse)
/*      */   {
/*  293 */     this.useSSLServerSocketFactory = shouldUse;
/*      */   }
/*      */ 
/*      */   public boolean getUseSSLServerSocketFactory()
/*      */   {
/*  301 */     return this.useSSLServerSocketFactory;
/*      */   }
/*      */ 
/*      */   public void setUseSSLSocketFactory(boolean shouldUse)
/*      */   {
/*  309 */     this.useSSLSocketFactory = shouldUse;
/*      */   }
/*      */ 
/*      */   public boolean getUseSSLSocketFactory()
/*      */   {
/*  317 */     return this.useSSLSocketFactory;
/*      */   }
/*      */ 
/*      */   public ServerSocketFactory createSSLServerSocketFactory()
/*      */     throws IOException
/*      */   {
/*  325 */     return createSSLServerSocketFactory(null);
/*      */   }
/*      */ 
/*      */   public ServerSocketFactory createSSLServerSocketFactory(CustomSSLServerSocketFactory wrapper)
/*      */     throws IOException
/*      */   {
/*  333 */     ServerSocketFactory ssf = null;
/*      */ 
/*  335 */     if (getUseSSLServerSocketFactory())
/*      */     {
/*  337 */       ssf = SSLServerSocketFactory.getDefault();
/*      */     }
/*      */     else
/*      */     {
/*  341 */       if (wrapper == null)
/*      */       {
/*  343 */         wrapper = new CustomSSLServerSocketFactory(null, this);
/*      */       }
/*      */ 
/*  346 */       ssf = createCustomServerSocketFactory(wrapper);
/*      */     }
/*      */ 
/*  349 */     return ssf;
/*      */   }
/*      */ 
/*      */   protected ServerSocketFactory createCustomServerSocketFactory(CustomSSLServerSocketFactory wrapper)
/*      */     throws IOException
/*      */   {
/*  363 */     if (this.sslContextServerSocketFactory == null)
/*      */     {
/*  365 */       createServerSocketFactorySSLContext();
/*  366 */       initializeServerSocketFactorySSLContext();
/*      */     }
/*      */ 
/*  369 */     ServerSocketFactory ssf = this.sslContextServerSocketFactory.getServerSocketFactory();
/*      */ 
/*  371 */     wrapper.setFactory((SSLServerSocketFactory)ssf);
/*      */ 
/*  373 */     return wrapper;
/*      */   }
/*      */ 
/*      */   public SocketFactory createSSLSocketFactory()
/*      */     throws IOException
/*      */   {
/*  381 */     return createSSLSocketFactory(null);
/*      */   }
/*      */ 
/*      */   public SocketFactory createSSLSocketFactory(CustomSSLSocketFactory wrapper)
/*      */     throws IOException
/*      */   {
/*  390 */     SocketFactory sf = null;
/*      */ 
/*  392 */     if (getUseSSLSocketFactory())
/*      */     {
/*  394 */       String defaultFactoryName = System.getProperty("org.jboss.remoting.defaultSocketFactory");
/*  395 */       if (defaultFactoryName != null)
/*      */       {
/*      */         try
/*      */         {
/*  399 */           Class sfClass = ClassLoaderUtility.loadClass(defaultFactoryName, SSLSocketBuilder.class);
/*  400 */           Method m = sfClass.getMethod("getDefault", null);
/*  401 */           if (m == null)
/*      */           {
/*  403 */             throw new RuntimeException("Could not create the socket factory " + defaultFactoryName + " because the class " + sfClass + " doesn't provide the getDefault method.");
/*      */           }
/*      */ 
/*  410 */           sf = (SocketFactory)m.invoke(null, null);
/*      */         }
/*      */         catch (Exception ex)
/*      */         {
/*  414 */           throw new RuntimeException("Could not create the socket factory " + defaultFactoryName, ex);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  419 */       if (sf == null)
/*      */       {
/*  421 */         sf = SSLSocketFactory.getDefault();
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  426 */       if (wrapper == null)
/*      */       {
/*  428 */         wrapper = new CustomSSLSocketFactory(null, this);
/*      */       }
/*      */ 
/*  431 */       sf = createCustomSocketFactory(wrapper);
/*      */     }
/*      */ 
/*  434 */     return sf;
/*      */   }
/*      */ 
/*      */   protected SocketFactory createCustomSocketFactory(CustomSSLSocketFactory wrapper)
/*      */     throws IOException
/*      */   {
/*  448 */     if (this.sslContextSocketFactory == null)
/*      */     {
/*  450 */       createSocketFactorySSLContext();
/*  451 */       initializeSocketFactorySSLContext();
/*      */     }
/*      */ 
/*  454 */     SocketFactory sf = this.sslContextSocketFactory.getSocketFactory();
/*      */ 
/*  456 */     wrapper.setFactory((SSLSocketFactory)sf);
/*      */ 
/*  458 */     return wrapper;
/*      */   }
/*      */ 
/*      */   public SSLContext getServerSocketFactorySSLContext()
/*      */   {
/*  467 */     return this.sslContextServerSocketFactory;
/*      */   }
/*      */ 
/*      */   public SSLContext getSocketFactorySSLContext()
/*      */   {
/*  475 */     return this.sslContextSocketFactory;
/*      */   }
/*      */ 
/*      */   public String getSecureSocketProtocol()
/*      */   {
/*  483 */     if (this.secureSocketProtocol == null)
/*      */     {
/*  485 */       if (this.config != null)
/*      */       {
/*  487 */         this.secureSocketProtocol = ((String)this.config.get("org.jboss.remoting.sslProtocol"));
/*      */       }
/*  489 */       if (this.secureSocketProtocol == null)
/*      */       {
/*  491 */         this.secureSocketProtocol = "TLS";
/*      */       }
/*      */     }
/*      */ 
/*  495 */     return this.secureSocketProtocol;
/*      */   }
/*      */ 
/*      */   public void setSecureSocketProtocol(String protocol)
/*      */   {
/*  503 */     if ((protocol != null) && (protocol.length() > 0))
/*      */     {
/*  505 */       this.secureSocketProtocol = protocol;
/*      */     }
/*      */     else
/*      */     {
/*  509 */       throw new IllegalArgumentException("Can not set remoting socket factory with null protocol");
/*      */     }
/*      */   }
/*      */ 
/*      */   public Provider getProvider()
/*      */   {
/*  518 */     return this.provider;
/*      */   }
/*      */ 
/*      */   public void setProvider(Provider provider)
/*      */   {
/*  526 */     this.provider = provider;
/*      */   }
/*      */ 
/*      */   public String getProviderName()
/*      */   {
/*  534 */     if (this.providerName == null)
/*      */     {
/*  536 */       if (this.config != null)
/*      */       {
/*  538 */         this.providerName = ((String)this.config.get("org.jboss.remoting.sslProviderName"));
/*      */       }
/*      */     }
/*  541 */     return this.providerName;
/*      */   }
/*      */ 
/*      */   public void setProviderName(String providerName)
/*      */   {
/*  549 */     this.providerName = providerName;
/*      */   }
/*      */ 
/*      */   public SecureRandom getSecureRandom()
/*      */   {
/*  557 */     if (this.secureRandom != null)
/*      */     {
/*  559 */       return this.secureRandom;
/*      */     }
/*      */ 
/*  562 */     this.secureRandom = new SecureRandom();
/*      */ 
/*  564 */     return this.secureRandom;
/*      */   }
/*      */ 
/*      */   public void setSecureRandom(SecureRandom secureRandom)
/*      */   {
/*  572 */     this.secureRandom = secureRandom;
/*      */   }
/*      */ 
/*      */   public String getKeyStoreURL()
/*      */   {
/*  580 */     URL keyStore = getKeyStore();
/*  581 */     if (keyStore != null)
/*      */     {
/*  583 */       return keyStore.toString();
/*      */     }
/*      */ 
/*  587 */     return null;
/*      */   }
/*      */ 
/*      */   public URL getKeyStore()
/*      */   {
/*  596 */     if (this.keyStoreFilePath != null)
/*      */     {
/*  598 */       return this.keyStoreFilePath;
/*      */     }
/*      */ 
/*  601 */     if (this.config != null)
/*      */     {
/*  603 */       String path = (String)this.config.get("org.jboss.remoting.keyStore");
/*  604 */       if ((path != null) && (path.length() > 0))
/*      */       {
/*  606 */         setKeyStoreURL(path);
/*      */       }
/*      */     }
/*      */ 
/*  610 */     if (this.keyStoreFilePath == null)
/*      */     {
/*  612 */       String path = System.getProperty("javax.net.ssl.keyStore");
/*  613 */       if ((path != null) && (path.length() > 0))
/*      */       {
/*  615 */         setKeyStoreURL(path);
/*      */       }
/*      */     }
/*      */ 
/*  619 */     return this.keyStoreFilePath;
/*      */   }
/*      */ 
/*      */   public void setKeyStoreURL(String keyStoreFilePath)
/*      */   {
/*      */     try
/*      */     {
/*  629 */       this.keyStoreFilePath = validateStoreURL(keyStoreFilePath);
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/*  633 */       throw new RuntimeException("Cannot validate the store URL: " + keyStoreFilePath, e);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setKeyStore(URL keyStore)
/*      */   {
/*  642 */     this.keyStoreFilePath = keyStore;
/*      */   }
/*      */ 
/*      */   public String getKeyStoreType()
/*      */   {
/*  650 */     if (this.keyStoreType != null)
/*      */     {
/*  652 */       return this.keyStoreType;
/*      */     }
/*      */ 
/*  655 */     if (this.config != null)
/*      */     {
/*  657 */       String type = (String)this.config.get("org.jboss.remoting.keyStoreType");
/*  658 */       if ((type != null) && (type.length() > 0))
/*      */       {
/*  660 */         this.keyStoreType = type;
/*      */       }
/*      */     }
/*      */ 
/*  664 */     if (this.keyStoreType == null)
/*      */     {
/*  666 */       this.keyStoreType = System.getProperty("javax.net.ssl.keyStoreType");
/*      */ 
/*  668 */       if (this.keyStoreType == null)
/*      */       {
/*  670 */         this.keyStoreType = "JKS";
/*      */       }
/*      */     }
/*      */ 
/*  674 */     return this.keyStoreType;
/*      */   }
/*      */ 
/*      */   public void setKeyStoreType(String keyStoreType)
/*      */   {
/*  682 */     this.keyStoreType = keyStoreType;
/*      */   }
/*      */ 
/*      */   public String getKeyStoreAlgorithm()
/*      */   {
/*  690 */     if (this.keyStoreAlgorithm != null)
/*      */     {
/*  692 */       return this.keyStoreAlgorithm;
/*      */     }
/*      */ 
/*  695 */     if (this.config != null)
/*      */     {
/*  697 */       String alg = (String)this.config.get("org.jboss.remoting.keyStoreAlgorithm");
/*  698 */       if ((alg != null) && (alg.length() > 0))
/*      */       {
/*  700 */         this.keyStoreAlgorithm = alg;
/*      */       }
/*      */     }
/*      */ 
/*  704 */     if (this.keyStoreAlgorithm == null)
/*      */     {
/*  706 */       this.keyStoreAlgorithm = "SunX509";
/*      */     }
/*      */ 
/*  709 */     return this.keyStoreAlgorithm;
/*      */   }
/*      */ 
/*      */   public void setKeyStoreAlgorithm(String algorithm)
/*      */   {
/*  717 */     this.keyStoreAlgorithm = algorithm;
/*      */   }
/*      */ 
/*      */   public String getKeyStorePassword()
/*      */   {
/*  727 */     if (this.keyStorePassword != null)
/*      */     {
/*  729 */       return this.keyStorePassword;
/*      */     }
/*      */ 
/*  732 */     if (this.config != null)
/*      */     {
/*  734 */       String passwd = (String)this.config.get("org.jboss.remoting.keyStorePassword");
/*  735 */       if ((passwd != null) && (passwd.length() > 0))
/*      */       {
/*  737 */         this.keyStorePassword = passwd;
/*      */       }
/*      */     }
/*      */ 
/*  741 */     if (this.keyStorePassword == null)
/*      */     {
/*  743 */       this.keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
/*      */     }
/*      */ 
/*  746 */     return this.keyStorePassword;
/*      */   }
/*      */ 
/*      */   public void setKeyStorePassword(String keyStorePassword)
/*      */   {
/*  754 */     this.keyStorePassword = keyStorePassword;
/*      */   }
/*      */ 
/*      */   public String getTrustStoreURL()
/*      */   {
/*  762 */     URL trustStore = getTrustStore();
/*  763 */     if (trustStore != null)
/*      */     {
/*  765 */       return trustStore.toString();
/*      */     }
/*      */ 
/*  769 */     return null;
/*      */   }
/*      */ 
/*      */   public URL getTrustStore()
/*      */   {
/*  778 */     if (this.trustStoreFilePath != null)
/*      */     {
/*  780 */       return this.trustStoreFilePath;
/*      */     }
/*      */ 
/*  783 */     if (this.config != null)
/*      */     {
/*  785 */       String path = (String)this.config.get("org.jboss.remoting.trustStore");
/*  786 */       if ((path != null) && (path.length() > 0))
/*      */       {
/*  788 */         setTrustStoreURL(path);
/*      */       }
/*      */     }
/*      */ 
/*  792 */     if (this.trustStoreFilePath == null)
/*      */     {
/*  794 */       String path = System.getProperty("javax.net.ssl.trustStore");
/*  795 */       if ((path != null) && (path.length() > 0))
/*      */       {
/*  797 */         setTrustStoreURL(path);
/*      */       }
/*      */     }
/*      */ 
/*  801 */     return this.trustStoreFilePath;
/*      */   }
/*      */ 
/*      */   public void setTrustStore(URL trustStore)
/*      */   {
/*  809 */     this.trustStoreFilePath = trustStore;
/*      */   }
/*      */ 
/*      */   public void setTrustStoreURL(String trustStoreFilePath)
/*      */   {
/*      */     try
/*      */     {
/*  819 */       this.trustStoreFilePath = validateStoreURL(trustStoreFilePath);
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/*  823 */       throw new RuntimeException("Cannot validate the store URL: " + trustStoreFilePath, e);
/*      */     }
/*      */   }
/*      */ 
/*      */   public String getTrustStoreType()
/*      */   {
/*  832 */     if (this.trustStoreType != null)
/*      */     {
/*  834 */       return this.trustStoreType;
/*      */     }
/*      */ 
/*  837 */     if (this.config != null)
/*      */     {
/*  839 */       String type = (String)this.config.get("org.jboss.remoting.trustStoreType");
/*  840 */       if ((type != null) && (type.length() > 0))
/*      */       {
/*  842 */         this.trustStoreType = type;
/*      */       }
/*      */     }
/*      */ 
/*  846 */     if (this.trustStoreType == null)
/*      */     {
/*  848 */       this.trustStoreType = System.getProperty("javax.net.ssl.trustStoreType");
/*      */ 
/*  850 */       if (this.trustStoreType == null)
/*      */       {
/*  852 */         this.trustStoreType = getKeyStoreType();
/*      */       }
/*      */     }
/*      */ 
/*  856 */     return this.trustStoreType;
/*      */   }
/*      */ 
/*      */   public void setTrustStoreType(String trustStoreType)
/*      */   {
/*  864 */     this.trustStoreType = trustStoreType;
/*      */   }
/*      */ 
/*      */   public String getTrustStoreAlgorithm()
/*      */   {
/*  872 */     if (this.trustStoreAlgorithm != null)
/*      */     {
/*  874 */       return this.trustStoreAlgorithm;
/*      */     }
/*      */ 
/*  877 */     if (this.config != null)
/*      */     {
/*  879 */       String alg = (String)this.config.get("org.jboss.remoting.trustStoreAlgorithm");
/*  880 */       if ((alg != null) && (alg.length() > 0))
/*      */       {
/*  882 */         this.trustStoreAlgorithm = alg;
/*      */       }
/*      */     }
/*      */ 
/*  886 */     if (this.trustStoreAlgorithm == null)
/*      */     {
/*  888 */       this.trustStoreAlgorithm = getKeyStoreAlgorithm();
/*      */     }
/*      */ 
/*  891 */     return this.trustStoreAlgorithm;
/*      */   }
/*      */ 
/*      */   public void setTrustStoreAlgorithm(String algorithm)
/*      */   {
/*  899 */     this.trustStoreAlgorithm = algorithm;
/*      */   }
/*      */ 
/*      */   public String getTrustStorePassword()
/*      */   {
/*  909 */     if (this.trustStorePassword != null)
/*      */     {
/*  911 */       return this.trustStorePassword;
/*      */     }
/*      */ 
/*  914 */     if (this.config != null)
/*      */     {
/*  916 */       String passwd = (String)this.config.get("org.jboss.remoting.trustStorePassword");
/*  917 */       if ((passwd != null) && (passwd.length() > 0))
/*      */       {
/*  919 */         this.trustStorePassword = passwd;
/*      */       }
/*      */     }
/*      */ 
/*  923 */     if (this.trustStorePassword == null)
/*      */     {
/*  925 */       this.trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
/*  926 */       if (this.trustStorePassword == null)
/*      */       {
/*  928 */         this.trustStorePassword = getKeyStorePassword();
/*      */       }
/*      */     }
/*      */ 
/*  932 */     return this.trustStorePassword;
/*      */   }
/*      */ 
/*      */   public void setTrustStorePassword(String trustStorePassword)
/*      */   {
/*  940 */     this.trustStorePassword = trustStorePassword;
/*      */   }
/*      */ 
/*      */   public String getKeyAlias()
/*      */   {
/*  948 */     if (this.keyAlias != null)
/*      */     {
/*  950 */       return this.keyAlias;
/*      */     }
/*  952 */     if (this.config != null)
/*      */     {
/*  954 */       this.keyAlias = ((String)this.config.get("org.jboss.remoting.keyAlias"));
/*      */     }
/*  956 */     return this.keyAlias;
/*      */   }
/*      */ 
/*      */   public void setKeyAlias(String alias)
/*      */   {
/*  964 */     this.keyAlias = alias;
/*      */   }
/*      */ 
/*      */   public String getKeyPassword()
/*      */   {
/*  977 */     if (this.keyPassword != null)
/*      */     {
/*  979 */       return this.keyPassword;
/*      */     }
/*      */ 
/*  982 */     if (this.config != null)
/*      */     {
/*  984 */       String passwd = (String)this.config.get("org.jboss.remoting.keyPassword");
/*  985 */       if ((passwd != null) && (passwd.length() > 0))
/*      */       {
/*  987 */         this.keyPassword = passwd;
/*      */       }
/*      */     }
/*      */ 
/*  991 */     return this.keyPassword;
/*      */   }
/*      */ 
/*      */   public void setKeyPassword(String keyPassword)
/*      */   {
/*  999 */     this.keyPassword = keyPassword;
/*      */   }
/*      */ 
/*      */   public boolean isSocketUseClientMode()
/*      */   {
/* 1007 */     if (this.socketUseClientMode == null)
/*      */     {
/* 1009 */       if ((this.config != null) && (this.config.containsKey("org.jboss.remoting.socket.useClientMode")))
/*      */       {
/* 1011 */         this.socketUseClientMode = Boolean.valueOf((String)this.config.get("org.jboss.remoting.socket.useClientMode"));
/*      */       }
/*      */       else
/*      */       {
/* 1015 */         this.socketUseClientMode = Boolean.TRUE;
/*      */       }
/*      */     }
/*      */ 
/* 1019 */     return this.socketUseClientMode.booleanValue();
/*      */   }
/*      */ 
/*      */   public boolean isServerSocketUseClientMode()
/*      */   {
/* 1027 */     if (this.serverSocketUseClientMode == null)
/*      */     {
/* 1029 */       if ((this.config != null) && (this.config.containsKey("org.jboss.remoting.serversocket.useClientMode")))
/*      */       {
/* 1031 */         this.serverSocketUseClientMode = Boolean.valueOf((String)this.config.get("org.jboss.remoting.serversocket.useClientMode"));
/*      */       }
/*      */       else
/*      */       {
/* 1035 */         this.serverSocketUseClientMode = Boolean.FALSE;
/*      */       }
/*      */     }
/*      */ 
/* 1039 */     return this.serverSocketUseClientMode.booleanValue();
/*      */   }
/*      */ 
/*      */   public void setSocketUseClientMode(boolean useClientMode)
/*      */   {
/* 1047 */     this.socketUseClientMode = Boolean.valueOf(useClientMode);
/*      */   }
/*      */ 
/*      */   public void setServerSocketUseClientMode(boolean useClientMode)
/*      */   {
/* 1055 */     this.serverSocketUseClientMode = Boolean.valueOf(useClientMode);
/*      */   }
/*      */ 
/*      */   public boolean isClientAuthModeNone()
/*      */   {
/* 1063 */     return "none".equals(getClientAuthMode());
/*      */   }
/*      */ 
/*      */   public boolean isClientAuthModeWant()
/*      */   {
/* 1071 */     return "want".equals(getClientAuthMode());
/*      */   }
/*      */ 
/*      */   public boolean isClientAuthModeNeed()
/*      */   {
/* 1079 */     return "need".equals(getClientAuthMode());
/*      */   }
/*      */ 
/*      */   public String getClientAuthMode()
/*      */   {
/* 1087 */     if (this.clientAuthMode == null)
/*      */     {
/* 1089 */       if ((this.config != null) && (this.config.containsKey("org.jboss.remoting.clientAuthMode")))
/*      */       {
/* 1091 */         setClientAuthMode((String)this.config.get("org.jboss.remoting.clientAuthMode"));
/*      */       }
/*      */       else
/*      */       {
/* 1095 */         this.clientAuthMode = "none";
/*      */       }
/*      */     }
/*      */ 
/* 1099 */     return this.clientAuthMode;
/*      */   }
/*      */ 
/*      */   public void setClientAuthMode(String mode)
/*      */   {
/* 1107 */     if ((mode == null) || ((!mode.equalsIgnoreCase("none")) && (!mode.equalsIgnoreCase("want")) && (!mode.equalsIgnoreCase("need"))))
/*      */     {
/* 1112 */       log.warn("Client authentication mode is invalid [" + mode + "]; falling back to NEED mode");
/* 1113 */       this.clientAuthMode = "need";
/*      */     }
/*      */     else
/*      */     {
/* 1117 */       this.clientAuthMode = mode;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isServerAuthMode()
/*      */   {
/* 1128 */     if (this.serverAuthMode == null)
/*      */     {
/* 1130 */       if ((this.config != null) && (this.config.containsKey("org.jboss.remoting.serverAuthMode")))
/*      */       {
/* 1132 */         this.serverAuthMode = Boolean.valueOf((String)this.config.get("org.jboss.remoting.serverAuthMode"));
/*      */       }
/*      */       else
/*      */       {
/* 1136 */         this.serverAuthMode = Boolean.TRUE;
/*      */       }
/*      */     }
/*      */ 
/* 1140 */     return this.serverAuthMode.booleanValue();
/*      */   }
/*      */ 
/*      */   public void setServerAuthMode(boolean mode)
/*      */   {
/* 1148 */     this.serverAuthMode = Boolean.valueOf(mode);
/*      */   }
/*      */ 
/*      */   protected void createServerSocketFactorySSLContext()
/*      */     throws IOException
/*      */   {
/*      */     try
/*      */     {
/* 1167 */       if (getProvider() != null)
/*      */       {
/* 1169 */         this.sslContextServerSocketFactory = SSLContext.getInstance(getSecureSocketProtocol(), getProvider());
/*      */       }
/* 1171 */       else if (getProviderName() != null)
/*      */       {
/* 1173 */         this.sslContextServerSocketFactory = SSLContext.getInstance(getSecureSocketProtocol(), getProviderName());
/*      */       }
/*      */       else
/*      */       {
/* 1177 */         this.sslContextServerSocketFactory = SSLContext.getInstance(getSecureSocketProtocol());
/*      */       }
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1182 */       IOException ioe = new IOException("Error creating server socket factory SSL context: " + e.getMessage());
/* 1183 */       ioe.setStackTrace(e.getStackTrace());
/* 1184 */       throw ioe;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void createSocketFactorySSLContext()
/*      */     throws IOException
/*      */   {
/*      */     try
/*      */     {
/* 1206 */       if (getProvider() != null)
/*      */       {
/* 1208 */         this.sslContextSocketFactory = SSLContext.getInstance(getSecureSocketProtocol(), getProvider());
/*      */       }
/* 1210 */       else if (getProviderName() != null)
/*      */       {
/* 1212 */         this.sslContextSocketFactory = SSLContext.getInstance(getSecureSocketProtocol(), getProviderName());
/*      */       }
/*      */       else
/*      */       {
/* 1216 */         this.sslContextSocketFactory = SSLContext.getInstance(getSecureSocketProtocol());
/*      */       }
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1221 */       IOException ioe = new IOException("Error creating socket factory SSL context: " + e.getMessage());
/* 1222 */       ioe.setStackTrace(e.getStackTrace());
/* 1223 */       throw ioe;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initializeServerSocketFactorySSLContext()
/*      */     throws IOException
/*      */   {
/*      */     try
/*      */     {
/* 1243 */       if (this.sslContextServerSocketFactory == null)
/*      */       {
/* 1245 */         createServerSocketFactorySSLContext();
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/* 1250 */         this.keyManagers = loadKeyManagers();
/*      */       }
/*      */       catch (NullStoreURLException e)
/*      */       {
/* 1254 */         if (isServerSocketUseClientMode())
/*      */         {
/* 1256 */           this.keyManagers = null;
/* 1257 */           log.debug("Could not find keytore url.  " + e.getMessage());
/*      */         }
/*      */         else
/*      */         {
/* 1262 */           IOException ioe = new IOException("Can not find keystore url.");
/* 1263 */           ioe.initCause(e);
/* 1264 */           throw ioe;
/*      */         }
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/* 1270 */         boolean isClientMode = isServerSocketUseClientMode();
/* 1271 */         this.trustManagers = loadTrustManagers(isClientMode);
/*      */       }
/*      */       catch (NullStoreURLException e)
/*      */       {
/* 1275 */         this.trustManagers = null;
/* 1276 */         log.debug("Could not find truststore url.  " + e.getMessage());
/*      */       }
/*      */ 
/* 1279 */       this.secureRandom = getSecureRandom();
/*      */ 
/* 1281 */       this.sslContextServerSocketFactory.init(this.keyManagers, this.trustManagers, this.secureRandom);
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1285 */       IOException ioe = new IOException("Error initializing server socket factory SSL context: " + e.getMessage());
/* 1286 */       ioe.setStackTrace(e.getStackTrace());
/* 1287 */       throw ioe;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void initializeSocketFactorySSLContext()
/*      */     throws IOException
/*      */   {
/*      */     try
/*      */     {
/* 1307 */       if (this.sslContextSocketFactory == null)
/*      */       {
/* 1309 */         createSocketFactorySSLContext();
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/* 1314 */         this.keyManagers = loadKeyManagers();
/*      */       }
/*      */       catch (NullStoreURLException e)
/*      */       {
/* 1319 */         this.keyManagers = null;
/* 1320 */         log.debug("Could not find keystore url.  " + e.getMessage());
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/* 1325 */         boolean isClientMode = isSocketUseClientMode();
/* 1326 */         this.trustManagers = loadTrustManagers(isClientMode);
/*      */       }
/*      */       catch (NullStoreURLException e)
/*      */       {
/* 1333 */         if (this.keyManagers != null)
/*      */         {
/* 1335 */           this.trustManagers = null;
/* 1336 */           log.debug("Could not find truststore url.  " + e.getMessage());
/*      */         }
/*      */         else
/*      */         {
/* 1340 */           IOException ioe = new IOException("Can not find truststore url.");
/* 1341 */           ioe.initCause(e);
/* 1342 */           throw ioe;
/*      */         }
/*      */       }
/*      */ 
/* 1346 */       this.secureRandom = getSecureRandom();
/*      */ 
/* 1348 */       this.sslContextSocketFactory.init(this.keyManagers, this.trustManagers, this.secureRandom);
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1352 */       IOException ioe = new IOException("Error initializing socket factory SSL context: " + e.getMessage());
/* 1353 */       ioe.setStackTrace(e.getStackTrace());
/* 1354 */       throw ioe;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected TrustManager[] loadTrustManagers(boolean isClientMode)
/*      */     throws NoSuchProviderException, NoSuchAlgorithmException, IOException, CertificateException, KeyStoreException, SSLSocketBuilder.NullStoreURLException
/*      */   {
/* 1375 */     if ((isClientMode) && (!isServerAuthMode()))
/*      */     {
/* 1379 */       this.trustManagers = new TrustManager[] { new X509TrustManager() {
/*      */         public void checkClientTrusted(X509Certificate[] chain, String authType) {
/*      */         }
/*      */         public void checkServerTrusted(X509Certificate[] chain, String authType) {  }
/*      */ 
/* 1383 */         public X509Certificate[] getAcceptedIssuers() { return null; }
/*      */       }
/*      */        };
/*      */     } else {
/* 1388 */       String tsType = getTrustStoreType();
/* 1389 */       String tsPasswd = getTrustStorePassword();
/* 1390 */       URL tsPathURL = getTrustStore();
/*      */ 
/* 1392 */       String tsAlg = getTrustStoreAlgorithm();
/*      */ 
/* 1395 */       KeyStore trustStore = loadKeyStore(tsType, tsPathURL, tsPasswd);
/*      */       TrustManagerFactory trustMgrFactory;
/*      */       TrustManagerFactory trustMgrFactory;
/* 1397 */       if (getProvider() != null)
/*      */       {
/* 1399 */         trustMgrFactory = TrustManagerFactory.getInstance(tsAlg, getProvider());
/*      */       }
/*      */       else
/*      */       {
/*      */         TrustManagerFactory trustMgrFactory;
/* 1401 */         if (getProviderName() != null)
/*      */         {
/* 1403 */           trustMgrFactory = TrustManagerFactory.getInstance(tsAlg, getProviderName());
/*      */         }
/*      */         else
/*      */         {
/* 1407 */           trustMgrFactory = TrustManagerFactory.getInstance(tsAlg);
/*      */         }
/*      */       }
/* 1410 */       if (trustStore != null)
/*      */       {
/* 1412 */         trustMgrFactory.init(trustStore);
/*      */ 
/* 1414 */         this.trustManagers = trustMgrFactory.getTrustManagers();
/*      */       }
/*      */     }
/*      */ 
/* 1418 */     return this.trustManagers;
/*      */   }
/*      */ 
/*      */   protected KeyManager[] loadKeyManagers()
/*      */     throws NoSuchProviderException, NoSuchAlgorithmException, IOException, CertificateException, KeyStoreException, UnrecoverableKeyException, SSLSocketBuilder.NullStoreURLException
/*      */   {
/* 1438 */     String ksPasswd = getKeyStorePassword();
/* 1439 */     String ksType = getKeyStoreType();
/* 1440 */     URL ksPathURL = getKeyStore();
/*      */ 
/* 1442 */     KeyStore keyStore = loadKeyStore(ksType, ksPathURL, ksPasswd);
/*      */ 
/* 1444 */     if (keyStore != null)
/*      */     {
/* 1446 */       String alias = getKeyAlias();
/*      */ 
/* 1449 */       if (alias != null)
/*      */       {
/* 1451 */         boolean containsAlias = keyStore.isKeyEntry(alias);
/* 1452 */         if (!containsAlias)
/*      */         {
/* 1455 */           throw new IOException("Can not find key entry for key store (" + ksPathURL + ") with given alias (" + alias + ")");
/*      */         }
/*      */       }
/*      */ 
/* 1459 */       KeyManagerFactory keyMgrFactory = null;
/* 1460 */       String alg = getKeyStoreAlgorithm();
/*      */ 
/* 1462 */       if (getProvider() != null)
/*      */       {
/* 1464 */         keyMgrFactory = KeyManagerFactory.getInstance(alg, getProvider());
/*      */       }
/* 1466 */       else if (getProviderName() != null)
/*      */       {
/* 1468 */         keyMgrFactory = KeyManagerFactory.getInstance(alg, getProviderName());
/*      */       }
/*      */       else
/*      */       {
/* 1472 */         keyMgrFactory = KeyManagerFactory.getInstance(alg);
/*      */       }
/*      */ 
/* 1476 */       String keyPasswd = getKeyPassword();
/* 1477 */       if ((keyPasswd == null) || (keyPasswd.length() == 0))
/*      */       {
/* 1479 */         keyPasswd = ksPasswd;
/*      */       }
/*      */ 
/* 1482 */       keyMgrFactory.init(keyStore, keyPasswd.toCharArray());
/* 1483 */       this.keyManagers = keyMgrFactory.getKeyManagers();
/*      */ 
/* 1486 */       if (alias != null)
/*      */       {
/* 1489 */         for (int x = 0; x < this.keyManagers.length; x++)
/*      */         {
/* 1491 */           this.keyManagers[x] = new RemotingKeyManager((X509KeyManager)this.keyManagers[x], alias);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1496 */     return this.keyManagers;
/*      */   }
/*      */ 
/*      */   protected KeyStore loadKeyStore(String storeType, URL storePathURL, String storePassword)
/*      */     throws KeyStoreException, NoSuchProviderException, IOException, NoSuchAlgorithmException, CertificateException, SSLSocketBuilder.NullStoreURLException
/*      */   {
/* 1519 */     KeyStore keyStore = null;
/*      */ 
/* 1521 */     if (getProvider() != null)
/*      */     {
/* 1523 */       keyStore = KeyStore.getInstance(storeType, getProvider());
/*      */     }
/* 1525 */     else if (getProviderName() != null)
/*      */     {
/* 1527 */       keyStore = KeyStore.getInstance(storeType, getProviderName());
/*      */     }
/*      */     else
/*      */     {
/* 1531 */       keyStore = KeyStore.getInstance(storeType);
/*      */     }
/*      */ 
/* 1534 */     if (storePathURL == null)
/*      */     {
/* 1536 */       throw new NullStoreURLException("Can not find store file for url because store url is null.");
/*      */     }
/*      */ 
/* 1540 */     InputStream keyStoreInputStream = null;
/*      */     try
/*      */     {
/* 1544 */       keyStoreInputStream = storePathURL.openStream();
/*      */ 
/* 1547 */       char[] password = storePassword != null ? storePassword.toCharArray() : null;
/* 1548 */       keyStore.load(keyStoreInputStream, password);
/*      */     }
/*      */     finally
/*      */     {
/* 1552 */       if (keyStoreInputStream != null)
/*      */       {
/*      */         try
/*      */         {
/* 1556 */           keyStoreInputStream.close();
/*      */         }
/*      */         catch (IOException e)
/*      */         {
/*      */         }
/*      */ 
/* 1562 */         keyStoreInputStream = null;
/*      */       }
/*      */     }
/*      */ 
/* 1566 */     return keyStore;
/*      */   }
/*      */ 
/*      */   protected URL validateStoreURL(String storePath)
/*      */     throws IOException
/*      */   {
/* 1585 */     URL url = null;
/*      */     try
/*      */     {
/* 1590 */       url = new URL(storePath);
/*      */     }
/*      */     catch (MalformedURLException e)
/*      */     {
/* 1596 */       File tst = new File(storePath);
/*      */ 
/* 1598 */       if (tst.exists() == true)
/*      */       {
/* 1600 */         url = tst.toURL();
/*      */       }
/* 1605 */       else if (url == null)
/*      */       {
/* 1607 */         ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 1608 */         url = loader.getResource(storePath);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1614 */     if (url == null)
/*      */     {
/* 1616 */       String msg = "Failed to find url=" + storePath + " as a URL, file or resource";
/* 1617 */       throw new MalformedURLException(msg);
/*      */     }
/*      */ 
/* 1620 */     return url;
/*      */   }
/*      */ 
/*      */   public Object clone()
/*      */   {
/*      */     try
/*      */     {
/* 1627 */       return super.clone();
/*      */     }
/*      */     catch (CloneNotSupportedException e) {
/*      */     }
/* 1631 */     return null;
/*      */   }
/*      */ 
/*      */   public void create()
/*      */     throws Exception
/*      */   {
/*      */   }
/*      */ 
/*      */   public void start()
/*      */     throws Exception
/*      */   {
/*      */   }
/*      */ 
/*      */   public void stop()
/*      */   {
/*      */   }
/*      */ 
/*      */   public void destroy()
/*      */   {
/*      */   }
/*      */ 
/*      */   protected class NullStoreURLException extends Exception
/*      */   {
/*      */     private static final long serialVersionUID = 1L;
/*      */ 
/*      */     public NullStoreURLException(String message)
/*      */     {
/* 1689 */       super();
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.security.SSLSocketBuilder
 * JD-Core Version:    0.6.0
 */