/*     */ package org.jboss.remoting.security;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.InetAddress;
/*     */ import java.net.Socket;
/*     */ import java.net.UnknownHostException;
/*     */ import javax.net.ssl.SSLSocket;
/*     */ import javax.net.ssl.SSLSocketFactory;
/*     */ 
/*     */ public class CustomSSLSocketFactory extends SSLSocketFactory
/*     */ {
/*     */   private SSLSocketFactory theDelegate;
/*     */   private SSLSocketBuilderMBean theBuilder;
/*     */ 
/*     */   public CustomSSLSocketFactory(SSLSocketFactory factory, SSLSocketBuilder builder)
/*     */   {
/*  36 */     this.theBuilder = builder;
/*  37 */     this.theDelegate = factory;
/*     */   }
/*     */ 
/*     */   public CustomSSLSocketFactory()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void setSSLSocketBuilder(SSLSocketBuilderMBean sslSocketBuilder)
/*     */   {
/*  51 */     this.theBuilder = sslSocketBuilder;
/*     */   }
/*     */ 
/*     */   public SSLSocketBuilderMBean getSSLSocketBuilder()
/*     */   {
/*  63 */     return this.theBuilder;
/*     */   }
/*     */ 
/*     */   public void setFactory(SSLSocketFactory factory)
/*     */   {
/*  75 */     if (factory == null)
/*     */     {
/*  77 */       throw new IllegalArgumentException("Factory cannot be null");
/*     */     }
/*     */ 
/*  80 */     this.theDelegate = factory;
/*     */   }
/*     */ 
/*     */   public Socket createSocket(Socket s, String host, int port, boolean autoClose)
/*     */     throws IOException
/*     */   {
/*  92 */     SSLSocket sock = (SSLSocket)this.theDelegate.createSocket(s, host, port, autoClose);
/*  93 */     setSocketModes(sock);
/*  94 */     return sock;
/*     */   }
/*     */ 
/*     */   public Socket createSocket()
/*     */     throws IOException
/*     */   {
/* 103 */     SSLSocket sock = (SSLSocket)this.theDelegate.createSocket();
/* 104 */     setSocketModes(sock);
/* 105 */     return sock;
/*     */   }
/*     */ 
/*     */   public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort)
/*     */     throws IOException
/*     */   {
/* 117 */     SSLSocket sock = (SSLSocket)this.theDelegate.createSocket(address, port, localAddress, localPort);
/* 118 */     setSocketModes(sock);
/* 119 */     return sock;
/*     */   }
/*     */ 
/*     */   public Socket createSocket(InetAddress host, int port)
/*     */     throws IOException
/*     */   {
/* 129 */     SSLSocket sock = (SSLSocket)this.theDelegate.createSocket(host, port);
/* 130 */     setSocketModes(sock);
/* 131 */     return sock;
/*     */   }
/*     */ 
/*     */   public Socket createSocket(String host, int port, InetAddress localHost, int localPort)
/*     */     throws IOException, UnknownHostException
/*     */   {
/* 144 */     SSLSocket sock = (SSLSocket)this.theDelegate.createSocket(host, port, localHost, localPort);
/* 145 */     setSocketModes(sock);
/* 146 */     return sock;
/*     */   }
/*     */ 
/*     */   public Socket createSocket(String host, int port)
/*     */     throws IOException, UnknownHostException
/*     */   {
/* 157 */     SSLSocket sock = (SSLSocket)this.theDelegate.createSocket(host, port);
/* 158 */     setSocketModes(sock);
/* 159 */     return sock;
/*     */   }
/*     */ 
/*     */   public String[] getDefaultCipherSuites()
/*     */   {
/* 167 */     return this.theDelegate.getDefaultCipherSuites();
/*     */   }
/*     */ 
/*     */   public String[] getSupportedCipherSuites()
/*     */   {
/* 175 */     return this.theDelegate.getSupportedCipherSuites();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 183 */     return this.theDelegate.equals(obj);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 191 */     return this.theDelegate.hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 199 */     return this.theDelegate.toString();
/*     */   }
/*     */ 
/*     */   private void setSocketModes(SSLSocket sock)
/*     */   {
/* 209 */     if (this.theBuilder != null)
/*     */     {
/* 211 */       sock.setUseClientMode(this.theBuilder.isSocketUseClientMode());
/*     */ 
/* 213 */       if (this.theBuilder.isClientAuthModeWant())
/*     */       {
/* 215 */         sock.setNeedClientAuth(false);
/* 216 */         sock.setWantClientAuth(true);
/*     */       }
/* 218 */       else if (this.theBuilder.isClientAuthModeNeed())
/*     */       {
/* 220 */         sock.setWantClientAuth(false);
/* 221 */         sock.setNeedClientAuth(true);
/*     */       }
/*     */       else
/*     */       {
/* 225 */         sock.setWantClientAuth(false);
/* 226 */         sock.setNeedClientAuth(false);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.security.CustomSSLSocketFactory
 * JD-Core Version:    0.6.0
 */