/*     */ package org.jboss.remoting.security;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.InetAddress;
/*     */ import java.net.ServerSocket;
/*     */ import javax.net.ssl.SSLServerSocket;
/*     */ import javax.net.ssl.SSLServerSocketFactory;
/*     */ 
/*     */ public class CustomSSLServerSocketFactory extends SSLServerSocketFactory
/*     */ {
/*     */   private SSLServerSocketFactory theDelegate;
/*     */   private SSLSocketBuilderMBean theBuilder;
/*     */ 
/*     */   public CustomSSLServerSocketFactory(SSLServerSocketFactory factory, SSLSocketBuilderMBean builder)
/*     */   {
/*  35 */     this.theBuilder = builder;
/*  36 */     this.theDelegate = factory;
/*     */   }
/*     */ 
/*     */   public CustomSSLServerSocketFactory()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void setSSLSocketBuilder(SSLSocketBuilderMBean sslSocketBuilder)
/*     */   {
/*  50 */     this.theBuilder = sslSocketBuilder;
/*     */   }
/*     */ 
/*     */   public SSLSocketBuilderMBean getSSLSocketBuilder()
/*     */   {
/*  61 */     return this.theBuilder;
/*     */   }
/*     */ 
/*     */   public void setFactory(SSLServerSocketFactory factory)
/*     */   {
/*  73 */     if (factory == null)
/*     */     {
/*  75 */       throw new IllegalArgumentException("Factory cannot be null");
/*     */     }
/*     */ 
/*  78 */     this.theDelegate = factory;
/*     */   }
/*     */ 
/*     */   public ServerSocket createServerSocket()
/*     */     throws IOException
/*     */   {
/*  87 */     SSLServerSocket sock = (SSLServerSocket)this.theDelegate.createServerSocket();
/*  88 */     setSocketModes(sock);
/*  89 */     return sock;
/*     */   }
/*     */ 
/*     */   public ServerSocket createServerSocket(int port)
/*     */     throws IOException
/*     */   {
/*  98 */     SSLServerSocket sock = (SSLServerSocket)this.theDelegate.createServerSocket(port);
/*  99 */     setSocketModes(sock);
/* 100 */     return sock;
/*     */   }
/*     */ 
/*     */   public ServerSocket createServerSocket(int port, int backlog)
/*     */     throws IOException
/*     */   {
/* 110 */     SSLServerSocket sock = (SSLServerSocket)this.theDelegate.createServerSocket(port, backlog);
/* 111 */     setSocketModes(sock);
/* 112 */     return sock;
/*     */   }
/*     */ 
/*     */   public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress)
/*     */     throws IOException
/*     */   {
/* 123 */     SSLServerSocket sock = (SSLServerSocket)this.theDelegate.createServerSocket(port, backlog, ifAddress);
/* 124 */     setSocketModes(sock);
/* 125 */     return sock;
/*     */   }
/*     */ 
/*     */   public String[] getDefaultCipherSuites()
/*     */   {
/* 133 */     return this.theDelegate.getDefaultCipherSuites();
/*     */   }
/*     */ 
/*     */   public String[] getSupportedCipherSuites()
/*     */   {
/* 141 */     return this.theDelegate.getSupportedCipherSuites();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 149 */     return this.theDelegate.equals(obj);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 157 */     return this.theDelegate.hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 165 */     return this.theDelegate.toString();
/*     */   }
/*     */ 
/*     */   private void setSocketModes(SSLServerSocket sock)
/*     */   {
/* 175 */     if (this.theBuilder != null)
/*     */     {
/* 177 */       sock.setUseClientMode(this.theBuilder.isServerSocketUseClientMode());
/*     */ 
/* 179 */       if (this.theBuilder.isClientAuthModeWant())
/*     */       {
/* 181 */         sock.setNeedClientAuth(false);
/* 182 */         sock.setWantClientAuth(true);
/*     */       }
/* 184 */       else if (this.theBuilder.isClientAuthModeNeed())
/*     */       {
/* 186 */         sock.setWantClientAuth(false);
/* 187 */         sock.setNeedClientAuth(true);
/*     */       }
/*     */       else
/*     */       {
/* 191 */         sock.setWantClientAuth(false);
/* 192 */         sock.setNeedClientAuth(false);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.security.CustomSSLServerSocketFactory
 * JD-Core Version:    0.6.0
 */