/*    */ package org.jboss.remoting.samples.transporter.serialization.client;
/*    */ 
/*    */ import java.io.PrintStream;
/*    */ import java.util.ArrayList;
/*    */ import java.util.List;
/*    */ import org.jboss.remoting.samples.transporter.basic.Address;
/*    */ import org.jboss.remoting.samples.transporter.basic.Customer;
/*    */ import org.jboss.remoting.samples.transporter.serialization.Order;
/*    */ import org.jboss.remoting.samples.transporter.serialization.OrderProcessor;
/*    */ import org.jboss.remoting.transporter.TransporterClient;
/*    */ 
/*    */ public class Client
/*    */ {
/* 39 */   private String locatorURI = "socket://localhost:5400/?serializationtype=jboss";
/*    */ 
/*    */   public void makeClientCall() throws Exception
/*    */   {
/* 43 */     Order order = createOrder();
/*    */ 
/* 45 */     OrderProcessor orderProcessor = (OrderProcessor)TransporterClient.createTransporterClient(this.locatorURI, OrderProcessor.class);
/*    */ 
/* 47 */     System.out.println("Order to be processed: " + order);
/* 48 */     Order changedOrder = orderProcessor.processOrder(order);
/* 49 */     System.out.println("Order now processed " + changedOrder);
/*    */ 
/* 51 */     TransporterClient.destroyTransporterClient(orderProcessor);
/*    */   }
/*    */ 
/*    */   private Order createOrder()
/*    */   {
/* 57 */     Order order = new Order();
/* 58 */     Customer customer = createCustomer();
/* 59 */     order.setCustomer(customer);
/*    */ 
/* 61 */     List items = new ArrayList();
/* 62 */     items.add("Xbox 360");
/* 63 */     items.add("Wireless controller");
/* 64 */     items.add("Ghost Recon 3");
/*    */ 
/* 66 */     order.setItems(items);
/*    */ 
/* 68 */     return order;
/*    */   }
/*    */ 
/*    */   private Customer createCustomer()
/*    */   {
/* 73 */     Customer cust = new Customer();
/* 74 */     cust.setFirstName("Bob");
/* 75 */     cust.setLastName("Smith");
/* 76 */     Address addr = new Address();
/* 77 */     addr.setStreet("101 Oak Street");
/* 78 */     addr.setCity("Atlanta");
/* 79 */     addr.setState("GA");
/* 80 */     addr.setZip(30249);
/* 81 */     cust.setAddr(addr);
/*    */ 
/* 83 */     return cust;
/*    */   }
/*    */ 
/*    */   public static void main(String[] args)
/*    */   {
/* 88 */     Client client = new Client();
/*    */     try
/*    */     {
/* 91 */       client.makeClientCall();
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 95 */       e.printStackTrace();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.transporter.serialization.client.Client
 * JD-Core Version:    0.6.0
 */