/*    */ package org.jboss.remoting.samples.transporter.serialization;
/*    */ 
/*    */ import java.io.PrintStream;
/*    */ import java.util.Iterator;
/*    */ import java.util.List;
/*    */ import java.util.Random;
/*    */ import org.jboss.remoting.samples.transporter.basic.Customer;
/*    */ import org.jboss.remoting.samples.transporter.basic.CustomerProcessor;
/*    */ import org.jboss.remoting.samples.transporter.basic.CustomerProcessorImpl;
/*    */ 
/*    */ public class OrderProcessorImpl
/*    */   implements OrderProcessor
/*    */ {
/* 38 */   private CustomerProcessor customerProcessor = null;
/*    */ 
/*    */   public OrderProcessorImpl()
/*    */   {
/* 42 */     this.customerProcessor = new CustomerProcessorImpl();
/*    */   }
/*    */ 
/*    */   public Order processOrder(Order order)
/*    */   {
/* 47 */     System.out.println("Incoming order to process from customer.\n" + order.getCustomer());
/*    */ 
/* 50 */     if (order.getCustomer().getCustomerId() < 0)
/*    */     {
/* 52 */       order.setCustomer(this.customerProcessor.processCustomer(order.getCustomer()));
/*    */     }
/*    */ 
/* 55 */     List items = order.getItems();
/* 56 */     System.out.println("Items ordered:");
/* 57 */     Iterator itr = items.iterator();
/* 58 */     while (itr.hasNext())
/*    */     {
/* 60 */       System.out.println(itr.next());
/*    */     }
/*    */ 
/* 63 */     order.setOrderId(new Random().nextInt(1000));
/* 64 */     order.setProcessed(true);
/*    */ 
/* 66 */     System.out.println("Order processed.  Order id now: " + order.getOrderId());
/* 67 */     return order;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.transporter.serialization.OrderProcessorImpl
 * JD-Core Version:    0.6.0
 */