/*    */ package org.jboss.remoting.samples.transporter.multiple.client;
/*    */ 
/*    */ import java.io.PrintStream;
/*    */ import org.jboss.remoting.samples.transporter.multiple.Account;
/*    */ import org.jboss.remoting.samples.transporter.multiple.AccountProcessor;
/*    */ import org.jboss.remoting.samples.transporter.multiple.Address;
/*    */ import org.jboss.remoting.samples.transporter.multiple.Customer;
/*    */ import org.jboss.remoting.samples.transporter.multiple.CustomerProcessor;
/*    */ import org.jboss.remoting.transporter.TransporterClient;
/*    */ 
/*    */ public class Client
/*    */ {
/* 16 */   private String locatorURI = "socket://localhost:5400";
/*    */ 
/*    */   public void makeClientCall() throws Exception
/*    */   {
/* 20 */     Customer customer = createCustomer();
/*    */ 
/* 22 */     CustomerProcessor customerProcessor = (CustomerProcessor)TransporterClient.createTransporterClient(this.locatorURI, CustomerProcessor.class);
/*    */ 
/* 24 */     System.out.println("Customer to be processed: " + customer);
/* 25 */     Customer processedCustomer = customerProcessor.processCustomer(customer);
/* 26 */     System.out.println("Customer is now: " + processedCustomer);
/*    */ 
/* 28 */     AccountProcessor accountProcessor = (AccountProcessor)TransporterClient.createTransporterClient(this.locatorURI, AccountProcessor.class);
/*    */ 
/* 30 */     System.out.println("Asking for a new account to be created for customer.");
/* 31 */     Account account = accountProcessor.createAccount(processedCustomer);
/* 32 */     System.out.println("New account: " + account);
/*    */ 
/* 34 */     TransporterClient.destroyTransporterClient(customerProcessor);
/* 35 */     TransporterClient.destroyTransporterClient(accountProcessor);
/*    */   }
/*    */ 
/*    */   private Customer createCustomer()
/*    */   {
/* 41 */     Customer cust = new Customer();
/* 42 */     cust.setFirstName("Bob");
/* 43 */     cust.setLastName("Smith");
/* 44 */     Address addr = new Address();
/* 45 */     addr.setStreet("101 Oak Street");
/* 46 */     addr.setCity("Atlanta");
/* 47 */     addr.setState("GA");
/* 48 */     addr.setZip(30249);
/* 49 */     cust.setAddr(addr);
/*    */ 
/* 51 */     return cust;
/*    */   }
/*    */ 
/*    */   public static void main(String[] args)
/*    */   {
/* 56 */     Client client = new Client();
/*    */     try
/*    */     {
/* 59 */       client.makeClientCall();
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 63 */       e.printStackTrace();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.transporter.multiple.client.Client
 * JD-Core Version:    0.6.0
 */