/*    */ package org.jboss.remoting.samples.transporter.custom.server;
/*    */ 
/*    */ import java.net.InetAddress;
/*    */ import java.util.HashMap;
/*    */ import java.util.Map;
/*    */ import javax.management.MBeanServer;
/*    */ import javax.management.MBeanServerFactory;
/*    */ import javax.management.ObjectName;
/*    */ import org.jboss.remoting.detection.jndi.JNDIDetector;
/*    */ import org.jboss.remoting.network.NetworkRegistry;
/*    */ import org.jboss.remoting.samples.transporter.basic.CustomerProcessor;
/*    */ import org.jboss.remoting.samples.transporter.basic.CustomerProcessorImpl;
/*    */ import org.jboss.remoting.transporter.InternalTransporterServices;
/*    */ import org.jboss.remoting.transporter.TransporterServer;
/*    */ 
/*    */ public class SocketServer
/*    */ {
/* 22 */   public static String locatorURI = "socket://localhost:5400";
/* 23 */   private TransporterServer server = null;
/*    */ 
/*    */   public void start() throws Exception
/*    */   {
/* 27 */     initTransporterServices();
/*    */ 
/* 29 */     Map config = getConnectorConfig();
/*    */ 
/* 31 */     this.server = TransporterServer.createTransporterServer(getLocatorURI(), new CustomerProcessorImpl(), CustomerProcessor.class.getName(), config, true);
/*    */   }
/*    */ 
/*    */   private Map getConnectorConfig()
/*    */   {
/* 37 */     Map config = new HashMap();
/*    */ 
/* 39 */     config.put("timeout", "5000");
/* 40 */     return config;
/*    */   }
/*    */ 
/*    */   protected String getLocatorURI()
/*    */   {
/* 45 */     return locatorURI;
/*    */   }
/*    */ 
/*    */   public void stop()
/*    */   {
/* 50 */     if (this.server != null)
/*    */     {
/* 52 */       this.server.stop();
/*    */     }
/*    */   }
/*    */ 
/*    */   private void initTransporterServices()
/*    */     throws Exception
/*    */   {
/* 59 */     MBeanServer mbeanServer = MBeanServerFactory.createMBeanServer();
/*    */ 
/* 61 */     NetworkRegistry registry = NetworkRegistry.getInstance();
/*    */ 
/* 63 */     String host = InetAddress.getLocalHost().getHostAddress();
/* 64 */     JNDIDetector jndiDetector = new JNDIDetector();
/* 65 */     jndiDetector.setPort(2410);
/* 66 */     jndiDetector.setHost(host);
/* 67 */     jndiDetector.setContextFactory("org.jnp.interfaces.NamingContextFactory");
/* 68 */     jndiDetector.setURLPackage("org.jboss.naming:org.jnp.interfaces");
/*    */ 
/* 71 */     InternalTransporterServices transporterService = InternalTransporterServices.getInstance();
/*    */ 
/* 73 */     transporterService.setup(mbeanServer, jndiDetector, new ObjectName("remoting:type=Detector,transport=jndi"), registry, new ObjectName("remoting:type=NetworkRegistry"), true, true);
/*    */ 
/* 79 */     jndiDetector.start();
/*    */   }
/*    */ 
/*    */   public static void main(String[] args)
/*    */   {
/* 85 */     SocketServer server = new SocketServer();
/*    */     try
/*    */     {
/* 88 */       server.start();
/*    */ 
/* 90 */       Thread.currentThread(); Thread.sleep(60000L);
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 95 */       e.printStackTrace();
/*    */     }
/*    */     finally
/*    */     {
/* 99 */       server.stop();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.transporter.custom.server.SocketServer
 * JD-Core Version:    0.6.0
 */