/*    */ package org.jboss.remoting.samples.transporter.custom.server;
/*    */ 
/*    */ import java.net.InetAddress;
/*    */ import javax.management.MBeanServer;
/*    */ import javax.management.MBeanServerFactory;
/*    */ import javax.management.ObjectName;
/*    */ import org.jboss.remoting.detection.jndi.JNDIDetector;
/*    */ import org.jboss.remoting.network.NetworkRegistry;
/*    */ import org.jboss.remoting.samples.transporter.basic.CustomerProcessor;
/*    */ import org.jboss.remoting.samples.transporter.basic.CustomerProcessorImpl;
/*    */ import org.jboss.remoting.transporter.InternalTransporterServices;
/*    */ import org.jboss.remoting.transporter.TransporterServer;
/*    */ 
/*    */ public class RMIServer
/*    */ {
/* 21 */   private String localLocatorURI = "rmi://localhost:5500";
/*    */ 
/* 23 */   private TransporterServer server = null;
/*    */ 
/*    */   public void start() throws Exception
/*    */   {
/* 27 */     initTransporterServices();
/*    */ 
/* 29 */     this.server = TransporterServer.createTransporterServer(this.localLocatorURI, new CustomerProcessorImpl(), CustomerProcessor.class.getName(), true);
/*    */   }
/*    */ 
/*    */   public void stop()
/*    */   {
/* 35 */     if (this.server != null)
/*    */     {
/* 37 */       this.server.stop();
/*    */     }
/*    */   }
/*    */ 
/*    */   private void initTransporterServices()
/*    */     throws Exception
/*    */   {
/* 44 */     MBeanServer mbeanServer = MBeanServerFactory.createMBeanServer();
/*    */ 
/* 46 */     NetworkRegistry registry = NetworkRegistry.getInstance();
/*    */ 
/* 48 */     String host = InetAddress.getLocalHost().getHostAddress();
/* 49 */     JNDIDetector jndiDetector = new JNDIDetector();
/* 50 */     jndiDetector.setPort(2410);
/* 51 */     jndiDetector.setHost(host);
/* 52 */     jndiDetector.setContextFactory("org.jnp.interfaces.NamingContextFactory");
/* 53 */     jndiDetector.setURLPackage("org.jboss.naming:org.jnp.interfaces");
/*    */ 
/* 56 */     InternalTransporterServices transporterService = InternalTransporterServices.getInstance();
/*    */ 
/* 58 */     transporterService.setup(mbeanServer, jndiDetector, new ObjectName("remoting:type=Detector,transport=jndi"), registry, new ObjectName("remoting:type=NetworkRegistry"), true, true);
/*    */ 
/* 64 */     jndiDetector.start();
/*    */   }
/*    */ 
/*    */   public static void main(String[] args)
/*    */   {
/* 70 */     RMIServer server = new RMIServer();
/*    */     try
/*    */     {
/* 73 */       server.start();
/*    */ 
/* 75 */       Thread.currentThread(); Thread.sleep(60000L);
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 80 */       e.printStackTrace();
/*    */     }
/*    */     finally
/*    */     {
/* 84 */       server.stop();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.transporter.custom.server.RMIServer
 * JD-Core Version:    0.6.0
 */