/*     */ package org.jboss.remoting.samples.transporter.custom.server;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.IOException;
/*     */ import java.net.InetAddress;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerFactory;
/*     */ import javax.management.ObjectName;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import javax.xml.parsers.ParserConfigurationException;
/*     */ import org.jboss.remoting.detection.jndi.JNDIDetector;
/*     */ import org.jboss.remoting.network.NetworkRegistry;
/*     */ import org.jboss.remoting.samples.transporter.basic.CustomerProcessor;
/*     */ import org.jboss.remoting.samples.transporter.basic.CustomerProcessorImpl;
/*     */ import org.jboss.remoting.transporter.InternalTransporterServices;
/*     */ import org.jboss.remoting.transporter.TransporterServer;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public class HTTPServer
/*     */ {
/*  27 */   private TransporterServer server = null;
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/*  31 */     initTransporterServices();
/*     */ 
/*  33 */     Element xmlConfig = getXmlConfig();
/*     */ 
/*  35 */     this.server = TransporterServer.createTransporterServer(xmlConfig, new CustomerProcessorImpl(), CustomerProcessor.class.getName(), true);
/*     */   }
/*     */ 
/*     */   private Element getXmlConfig()
/*     */     throws ParserConfigurationException, IOException, SAXException
/*     */   {
/*  42 */     String transport = "http";
/*  43 */     String host = "localhost";
/*  44 */     int port = 5600;
/*     */ 
/*  46 */     StringBuffer buf = new StringBuffer();
/*  47 */     buf.append("<?xml version=\"1.0\"?>\n");
/*  48 */     buf.append("<config>");
/*  49 */     buf.append("<invoker transport=\"" + transport + "\">");
/*  50 */     buf.append("<attribute name=\"serverBindAddress\">" + host + "</attribute>");
/*  51 */     buf.append("<attribute name=\"serverBindPort\">" + port + "</attribute>");
/*  52 */     buf.append("</invoker>");
/*  53 */     buf.append("</config>");
/*  54 */     Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(buf.toString().getBytes()));
/*  55 */     return xml.getDocumentElement();
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*  61 */     if (this.server != null)
/*     */     {
/*  63 */       this.server.stop();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void initTransporterServices()
/*     */     throws Exception
/*     */   {
/*  70 */     MBeanServer mbeanServer = MBeanServerFactory.createMBeanServer();
/*     */ 
/*  72 */     NetworkRegistry registry = NetworkRegistry.getInstance();
/*     */ 
/*  74 */     String host = InetAddress.getLocalHost().getHostAddress();
/*  75 */     JNDIDetector jndiDetector = new JNDIDetector();
/*  76 */     jndiDetector.setPort(2410);
/*  77 */     jndiDetector.setHost(host);
/*  78 */     jndiDetector.setContextFactory("org.jnp.interfaces.NamingContextFactory");
/*  79 */     jndiDetector.setURLPackage("org.jboss.naming:org.jnp.interfaces");
/*     */ 
/*  82 */     InternalTransporterServices transporterService = InternalTransporterServices.getInstance();
/*     */ 
/*  84 */     transporterService.setup(mbeanServer, jndiDetector, new ObjectName("remoting:type=Detector,transport=jndi"), registry, new ObjectName("remoting:type=NetworkRegistry"), true, true);
/*     */ 
/*  90 */     jndiDetector.start();
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*  97 */     HTTPServer server = new HTTPServer();
/*     */     try
/*     */     {
/* 100 */       server.start();
/*     */ 
/* 102 */       Thread.currentThread(); Thread.sleep(60000L);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 107 */       e.printStackTrace();
/*     */     }
/*     */     finally
/*     */     {
/* 111 */       server.stop();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.transporter.custom.server.HTTPServer
 * JD-Core Version:    0.6.0
 */