/*    */ package org.jboss.remoting.samples.transporter.custom.client;
/*    */ 
/*    */ import java.io.PrintStream;
/*    */ import java.net.InetAddress;
/*    */ import javax.management.MBeanServer;
/*    */ import javax.management.MBeanServerFactory;
/*    */ import javax.management.ObjectName;
/*    */ import org.jboss.remoting.detection.jndi.JNDIDetector;
/*    */ import org.jboss.remoting.network.NetworkRegistry;
/*    */ import org.jboss.remoting.samples.transporter.basic.Address;
/*    */ import org.jboss.remoting.samples.transporter.basic.Customer;
/*    */ import org.jboss.remoting.samples.transporter.basic.CustomerProcessor;
/*    */ import org.jboss.remoting.samples.transporter.custom.server.SocketServer;
/*    */ import org.jboss.remoting.transporter.InternalTransporterServices;
/*    */ import org.jboss.remoting.transporter.TransporterClient;
/*    */ 
/*    */ public class Client
/*    */ {
/* 23 */   private String locatorURI = SocketServer.locatorURI;
/*    */ 
/* 25 */   private CustomerProcessor customerProcessor = null;
/*    */ 
/*    */   public void makeClientCall() throws Exception
/*    */   {
/* 29 */     Customer customer = createCustomer();
/*    */ 
/* 31 */     System.out.println("Customer to be processed: " + customer);
/* 32 */     Customer processedCustomer = this.customerProcessor.processCustomer(customer);
/* 33 */     System.out.println("Customer is now: " + processedCustomer);
/*    */   }
/*    */ 
/*    */   public void getCustomerProcessor()
/*    */     throws Exception
/*    */   {
/* 40 */     initTransporterServices();
/*    */ 
/* 42 */     this.customerProcessor = ((CustomerProcessor)TransporterClient.createTransporterClient(this.locatorURI, CustomerProcessor.class, true));
/*    */   }
/*    */ 
/*    */   private void initTransporterServices()
/*    */     throws Exception
/*    */   {
/* 48 */     MBeanServer mbeanServer = MBeanServerFactory.createMBeanServer();
/*    */ 
/* 50 */     NetworkRegistry registry = NetworkRegistry.getInstance();
/*    */ 
/* 52 */     String host = InetAddress.getLocalHost().getHostAddress();
/* 53 */     JNDIDetector jndiDetector = new JNDIDetector();
/* 54 */     jndiDetector.setPort(2410);
/* 55 */     jndiDetector.setHost(host);
/* 56 */     jndiDetector.setContextFactory("org.jnp.interfaces.NamingContextFactory");
/* 57 */     jndiDetector.setURLPackage("org.jboss.naming:org.jnp.interfaces");
/*    */ 
/* 60 */     InternalTransporterServices transporterService = InternalTransporterServices.getInstance();
/*    */ 
/* 62 */     transporterService.setup(mbeanServer, jndiDetector, new ObjectName("remoting:type=Detector,transport=jndi"), registry, new ObjectName("remoting:type=NetworkRegistry"), true, true);
/*    */ 
/* 68 */     jndiDetector.start();
/*    */   }
/*    */ 
/*    */   private Customer createCustomer()
/*    */   {
/* 75 */     Customer cust = new Customer();
/* 76 */     cust.setFirstName("Bob");
/* 77 */     cust.setLastName("Smith");
/* 78 */     Address addr = new Address();
/* 79 */     addr.setStreet("101 Oak Stree");
/* 80 */     addr.setCity("Atlanta");
/* 81 */     addr.setZip(30249);
/* 82 */     cust.setAddr(addr);
/*    */ 
/* 84 */     return cust;
/*    */   }
/*    */ 
/*    */   public static void main(String[] args)
/*    */   {
/* 89 */     Client client = new Client();
/*    */     try
/*    */     {
/* 92 */       client.getCustomerProcessor();
/*    */       while (true)
/*    */       {
/*    */         try
/*    */         {
/* 97 */           client.makeClientCall();
/* 98 */           Thread.currentThread(); Thread.sleep(5000L);
/*    */ 
/* 103 */           continue;
/*    */         }
/*    */         catch (Exception e)
/*    */         {
/* 102 */           e.printStackTrace();
/*    */         }
/*    */       }
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 108 */       e.printStackTrace();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.transporter.custom.client.Client
 * JD-Core Version:    0.6.0
 */