/*    */ package org.jboss.remoting.samples.transporter.complex;
/*    */ 
/*    */ public class ProviderInterfaceImpl
/*    */   implements ProviderInterface
/*    */ {
/*    */   public Doctor findDoctor(Patient patient)
/*    */     throws NoDoctorAvailableException
/*    */   {
/* 38 */     String ailmentType = patient.getAilmentType();
/*    */ 
/* 40 */     Information info = Information.getInstance();
/* 41 */     Doctor doc = info.getProviderBySpecialty(ailmentType);
/* 42 */     if (doc != null)
/*    */     {
/* 44 */       doc.addPatient(patient);
/* 45 */       return doc;
/*    */     }
/*    */ 
/* 49 */     throw new NoDoctorAvailableException("No doctor available for ailment '" + ailmentType + "'");
/*    */   }
/*    */ 
/*    */   public void retireDoctor(Doctor doctor)
/*    */   {
/* 56 */     Information info = Information.getInstance();
/* 57 */     info.retireDoctor(doctor);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.transporter.complex.ProviderInterfaceImpl
 * JD-Core Version:    0.6.0
 */