/*    */ package org.jboss.remoting.samples.transporter.basic.client;
/*    */ 
/*    */ import java.io.PrintStream;
/*    */ import org.jboss.remoting.samples.transporter.basic.Address;
/*    */ import org.jboss.remoting.samples.transporter.basic.Customer;
/*    */ import org.jboss.remoting.samples.transporter.basic.CustomerProcessor;
/*    */ import org.jboss.remoting.transporter.TransporterClient;
/*    */ 
/*    */ public class Client
/*    */ {
/* 35 */   private String locatorURI = "socket://localhost:5400";
/*    */ 
/*    */   public void makeClientCall() throws Exception
/*    */   {
/* 39 */     Customer customer = createCustomer();
/*    */ 
/* 41 */     CustomerProcessor customerProcessor = (CustomerProcessor)TransporterClient.createTransporterClient(this.locatorURI, CustomerProcessor.class);
/*    */ 
/* 43 */     System.out.println("Customer to be processed: " + customer);
/* 44 */     Customer processedCustomer = customerProcessor.processCustomer(customer);
/* 45 */     System.out.println("Customer is now: " + processedCustomer);
/*    */ 
/* 47 */     TransporterClient.destroyTransporterClient(customerProcessor);
/*    */   }
/*    */ 
/*    */   private Customer createCustomer()
/*    */   {
/* 54 */     Customer cust = new Customer();
/* 55 */     cust.setFirstName("Bob");
/* 56 */     cust.setLastName("Smith");
/* 57 */     Address addr = new Address();
/* 58 */     addr.setStreet("101 Oak Street");
/* 59 */     addr.setCity("Atlanta");
/* 60 */     addr.setState("GA");
/* 61 */     addr.setZip(30249);
/* 62 */     cust.setAddr(addr);
/*    */ 
/* 64 */     return cust;
/*    */   }
/*    */ 
/*    */   public static void main(String[] args)
/*    */   {
/* 69 */     Client client = new Client();
/*    */     try
/*    */     {
/* 72 */       client.makeClientCall();
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 76 */       e.printStackTrace();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.transporter.basic.client.Client
 * JD-Core Version:    0.6.0
 */