/*     */ package org.jboss.remoting.samples.stream;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import java.net.URL;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ 
/*     */ public class StreamingClient
/*     */ {
/*  42 */   private static String transport = "socket";
/*  43 */   private static String host = "localhost";
/*  44 */   private static int port = 5400;
/*     */ 
/*  46 */   private String locatorURI = transport + "://" + host + ":" + port;
/*     */ 
/*  48 */   private String localFileName = "sample.txt";
/*  49 */   private String remoteFileName = "server_sample.txt";
/*     */ 
/*     */   public void sendStream() throws Throwable
/*     */   {
/*  53 */     FileInputStream fileInput = null;
/*  54 */     Client remotingClient = null;
/*     */     try
/*     */     {
/*  58 */       InvokerLocator locator = new InvokerLocator(this.locatorURI);
/*  59 */       System.out.println("Calling on remoting server with locator uri of: " + this.locatorURI);
/*     */ 
/*  61 */       remotingClient = new Client(locator);
/*  62 */       remotingClient.connect();
/*     */ 
/*  64 */       URL fileURL = getClass().getResource(this.localFileName);
/*  65 */       System.out.println("looking for file at " + fileURL);
/*  66 */       if (fileURL == null)
/*     */       {
/*  68 */         throw new Exception("Can not find file " + this.localFileName);
/*     */       }
/*  70 */       File testFile = new File(fileURL.getFile());
/*  71 */       fileInput = new FileInputStream(testFile);
/*     */ 
/*  73 */       System.out.println("Sending input stream for file " + this.localFileName + " to server.");
/*  74 */       Object ret = remotingClient.invoke(fileInput, this.remoteFileName);
/*     */ 
/*  76 */       long fileLength = testFile.length();
/*  77 */       System.out.println("Size of file sample.txt is " + fileLength);
/*  78 */       System.out.println("Server returned " + ret + " as the size of the file read.");
/*     */     }
/*     */     finally
/*     */     {
/*  83 */       if (remotingClient != null)
/*     */       {
/*  85 */         remotingClient.disconnect();
/*     */       }
/*  87 */       if (fileInput != null)
/*     */       {
/*     */         try
/*     */         {
/*  91 */           fileInput.close();
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/*  95 */           e.printStackTrace();
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setRemoteFileName(String remoteFileName)
/*     */   {
/* 103 */     this.remoteFileName = remoteFileName;
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 115 */     String newFileName = null;
/* 116 */     if ((args != null) && (args.length == 1))
/*     */     {
/* 118 */       newFileName = args[0];
/*     */     }
/* 120 */     if ((args != null) && (args.length == 2))
/*     */     {
/* 122 */       transport = args[0];
/* 123 */       port = Integer.parseInt(args[1]);
/*     */     }
/* 125 */     if ((args != null) && (args.length == 3))
/*     */     {
/* 127 */       transport = args[0];
/* 128 */       port = Integer.parseInt(args[1]);
/* 129 */       newFileName = args[2];
/*     */     }
/* 131 */     String locatorURI = transport + "://" + host + ":" + port;
/* 132 */     StreamingClient client = new StreamingClient();
/* 133 */     if (newFileName != null)
/*     */     {
/* 135 */       client.setRemoteFileName(newFileName);
/*     */     }
/*     */     try
/*     */     {
/* 139 */       client.sendStream();
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 143 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.stream.StreamingClient
 * JD-Core Version:    0.6.0
 */