/*     */ package org.jboss.remoting.samples.simple;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import javax.management.MBeanServer;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.ServerInvocationHandler;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.remoting.transport.Connector;
/*     */ 
/*     */ public class SimpleServer
/*     */ {
/*  42 */   private static String transport = "socket";
/*  43 */   private static String host = "localhost";
/*  44 */   private static int port = 5400;
/*     */   private static final String RESPONSE_VALUE = "This is the return to SampleInvocationHandler invocation";
/*     */ 
/*     */   public void setupServer(String locatorURI)
/*     */     throws Exception
/*     */   {
/*  55 */     InvokerLocator locator = new InvokerLocator(locatorURI);
/*  56 */     System.out.println("Starting remoting server with locator uri of: " + locatorURI);
/*  57 */     Connector connector = new Connector(locator);
/*     */ 
/*  59 */     connector.create();
/*     */ 
/*  62 */     SampleInvocationHandler invocationHandler = new SampleInvocationHandler();
/*     */ 
/*  64 */     connector.addInvocationHandler("sample", invocationHandler);
/*     */ 
/*  68 */     connector.start();
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*  80 */     if ((args != null) && (args.length == 3))
/*     */     {
/*  82 */       transport = args[0];
/*  83 */       host = args[1];
/*  84 */       port = Integer.parseInt(args[2]);
/*     */     }
/*  86 */     String locatorURI = transport + "://" + host + ":" + port;
/*  87 */     SimpleServer server = new SimpleServer();
/*     */     try
/*     */     {
/*  90 */       server.setupServer(locatorURI);
/*     */       while (true)
/*     */       {
/*  95 */         Thread.sleep(1000L);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 101 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class SampleInvocationHandler
/*     */     implements ServerInvocationHandler
/*     */   {
/*     */     public Object invoke(InvocationRequest invocation)
/*     */       throws Throwable
/*     */     {
/* 121 */       System.out.println("Invocation request is: " + invocation.getParameter());
/* 122 */       System.out.println("Returning response of: This is the return to SampleInvocationHandler invocation");
/*     */ 
/* 124 */       return "This is the return to SampleInvocationHandler invocation";
/*     */     }
/*     */ 
/*     */     public void addListener(InvokerCallbackHandler callbackHandler)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void removeListener(InvokerCallbackHandler callbackHandler)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void setMBeanServer(MBeanServer server)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void setInvoker(ServerInvoker invoker)
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.simple.SimpleServer
 * JD-Core Version:    0.6.0
 */