/*    */ package org.jboss.remoting.samples.simple;
/*    */ 
/*    */ import java.io.PrintStream;
/*    */ import org.jboss.remoting.Client;
/*    */ import org.jboss.remoting.InvokerLocator;
/*    */ 
/*    */ public class SimpleClient
/*    */ {
/* 36 */   private static String transport = "socket";
/* 37 */   private static String host = "localhost";
/* 38 */   private static int port = 5400;
/*    */ 
/*    */   public void makeInvocation(String locatorURI)
/*    */     throws Throwable
/*    */   {
/* 44 */     InvokerLocator locator = new InvokerLocator(locatorURI);
/* 45 */     System.out.println("Calling remoting server with locator uri of: " + locatorURI);
/*    */ 
/* 47 */     Client remotingClient = new Client(locator);
/* 48 */     remotingClient.connect();
/* 49 */     String request = "Do something";
/* 50 */     System.out.println("Invoking server with request of '" + request + "'");
/* 51 */     Object response = remotingClient.invoke(request);
/* 52 */     remotingClient.disconnect();
/* 53 */     System.out.println("Invocation response: " + response);
/*    */   }
/*    */ 
/*    */   public static void main(String[] args)
/*    */   {
/* 64 */     if ((args != null) && (args.length == 3))
/*    */     {
/* 66 */       transport = args[0];
/* 67 */       host = args[1];
/* 68 */       port = Integer.parseInt(args[2]);
/*    */     }
/* 70 */     String locatorURI = transport + "://" + host + ":" + port;
/* 71 */     SimpleClient client = new SimpleClient();
/*    */     try
/*    */     {
/* 74 */       client.makeInvocation(locatorURI);
/*    */     }
/*    */     catch (Throwable e)
/*    */     {
/* 78 */       e.printStackTrace();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.simple.SimpleClient
 * JD-Core Version:    0.6.0
 */