/*    */ package org.jboss.remoting.samples.serialization;
/*    */ 
/*    */ import java.io.PrintStream;
/*    */ import org.jboss.remoting.Client;
/*    */ import org.jboss.remoting.InvokerLocator;
/*    */ 
/*    */ public class SerializationClient
/*    */ {
/* 39 */   private static String transport = "socket";
/* 40 */   private static String host = "localhost";
/* 41 */   private static int port = 5400;
/*    */ 
/*    */   public void makeInvocation(String locatorURI)
/*    */     throws Throwable
/*    */   {
/* 47 */     InvokerLocator locator = new InvokerLocator(locatorURI);
/* 48 */     System.out.println("Calling remoting server with locator uri of: " + locatorURI);
/*    */ 
/* 50 */     Client remotingClient = new Client(locator);
/* 51 */     remotingClient.connect();
/* 52 */     NonSerializablePayload payload = new NonSerializablePayload("foo", 1);
/* 53 */     System.out.println("Invoking server with request of '" + payload + "'");
/* 54 */     Object response = remotingClient.invoke(payload);
/*    */ 
/* 56 */     System.out.println("Invocation response: " + response);
/*    */   }
/*    */ 
/*    */   public static void main(String[] args)
/*    */   {
/* 67 */     if ((args != null) && (args.length == 3))
/*    */     {
/* 69 */       transport = args[0];
/* 70 */       host = args[1];
/* 71 */       port = Integer.parseInt(args[2]);
/*    */     }
/*    */ 
/* 74 */     String locatorURI = transport + "://" + host + ":" + port + "/?serializationtype=jboss";
/* 75 */     SerializationClient client = new SerializationClient();
/*    */     try
/*    */     {
/* 78 */       client.makeInvocation(locatorURI);
/*    */     }
/*    */     catch (Throwable e)
/*    */     {
/* 82 */       e.printStackTrace();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.serialization.SerializationClient
 * JD-Core Version:    0.6.0
 */