/*     */ package org.jboss.remoting.samples.oneway;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import javax.management.MBeanServer;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.ServerInvocationHandler;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.remoting.transport.Connector;
/*     */ 
/*     */ public class OnewayServer
/*     */ {
/*  42 */   private static String transport = "socket";
/*  43 */   private static String host = "localhost";
/*  44 */   private static int port = 5400;
/*     */ 
/*     */   public void setupServer(String locatorURI)
/*     */     throws Exception
/*     */   {
/*  51 */     InvokerLocator locator = new InvokerLocator(locatorURI);
/*  52 */     System.out.println("Starting remoting server with locator uri of: " + locatorURI);
/*  53 */     Connector connector = new Connector(locator);
/*     */ 
/*  55 */     connector.create();
/*     */ 
/*  58 */     SampleInvocationHandler invocationHandler = new SampleInvocationHandler();
/*     */ 
/*  60 */     connector.addInvocationHandler("sample", invocationHandler);
/*     */ 
/*  62 */     connector.start();
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*  73 */     if ((args != null) && (args.length == 2))
/*     */     {
/*  75 */       transport = args[0];
/*  76 */       port = Integer.parseInt(args[1]);
/*     */     }
/*  78 */     String locatorURI = transport + "://" + host + ":" + port;
/*  79 */     OnewayServer server = new OnewayServer();
/*     */     try
/*     */     {
/*  82 */       server.setupServer(locatorURI);
/*     */       while (true)
/*     */       {
/*  87 */         Thread.sleep(1000L);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  93 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class SampleInvocationHandler
/*     */     implements ServerInvocationHandler
/*     */   {
/*     */     public Object invoke(InvocationRequest invocation)
/*     */       throws Throwable
/*     */     {
/* 113 */       System.out.println("Invocation request is: " + invocation.getParameter());
/* 114 */       return null;
/*     */     }
/*     */ 
/*     */     public void addListener(InvokerCallbackHandler callbackHandler)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void removeListener(InvokerCallbackHandler callbackHandler)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void setMBeanServer(MBeanServer server)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void setInvoker(ServerInvoker invoker)
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.oneway.OnewayServer
 * JD-Core Version:    0.6.0
 */