/*    */ package org.jboss.remoting.samples.oneway;
/*    */ 
/*    */ import java.io.PrintStream;
/*    */ import org.jboss.remoting.Client;
/*    */ import org.jboss.remoting.InvokerLocator;
/*    */ 
/*    */ public class OnewayClient
/*    */ {
/* 36 */   private static String transport = "socket";
/* 37 */   private static String host = "localhost";
/* 38 */   private static int port = 5400;
/*    */ 
/*    */   public void makeInvocation(String locatorURI) throws Throwable
/*    */   {
/* 42 */     InvokerLocator locator = new InvokerLocator(locatorURI);
/* 43 */     System.out.println("Calling remoting server with locator uri of: " + locatorURI);
/*    */ 
/* 45 */     Client remotingClient = new Client(locator);
/* 46 */     remotingClient.connect();
/*    */ 
/* 57 */     String payload1 = "Oneway call 1.";
/* 58 */     System.out.println("Making oneway invocation with payload of '" + payload1 + "'");
/* 59 */     remotingClient.invokeOneway(payload1);
/*    */ 
/* 68 */     String payload2 = "Oneway call 2.";
/* 69 */     System.out.println("Making oneway invocation with payload of '" + payload2 + "'");
/* 70 */     remotingClient.invokeOneway(payload2, null, true);
/*    */   }
/*    */ 
/*    */   public static void main(String[] args)
/*    */   {
/* 81 */     if ((args != null) && (args.length == 2))
/*    */     {
/* 83 */       transport = args[0];
/* 84 */       port = Integer.parseInt(args[1]);
/*    */     }
/* 86 */     String locatorURI = transport + "://" + host + ":" + port;
/* 87 */     OnewayClient client = new OnewayClient();
/*    */     try
/*    */     {
/* 90 */       client.makeInvocation(locatorURI);
/*    */     }
/*    */     catch (Throwable e)
/*    */     {
/* 94 */       e.printStackTrace();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.oneway.OnewayClient
 * JD-Core Version:    0.6.0
 */