/*     */ package org.jboss.remoting.samples.multiplex.invoker;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.callback.Callback;
/*     */ import org.jboss.remoting.callback.HandleCallbackException;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.remoting.transport.ClientInvoker;
/*     */ import org.jboss.remoting.transport.Connector;
/*     */ 
/*     */ public class Server3Client1
/*     */ {
/*     */   private Client client;
/*     */   private SampleCallbackHandler handler;
/*     */   private Connector connector;
/*     */   private InvokerLocator locator;
/*     */ 
/*     */   public void init()
/*     */   {
/*     */     try
/*     */     {
/*  60 */       String parameters = "/?clientMultiplexId=server3client1";
/*  61 */       String locatorURI = "multiplex://localhost:9090" + parameters;
/*  62 */       InvokerLocator locator = new InvokerLocator(locatorURI);
/*  63 */       this.client = new Client(locator, "sample");
/*  64 */       this.client.connect();
/*  65 */       System.out.println("Connected client to server at: " + this.client.getInvoker().getLocator().getLocatorURI());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  69 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   private InvokerLocator initServer()
/*     */     throws Exception
/*     */   {
/*  83 */     String parameters = "/?serverMultiplexId=server3client1";
/*  84 */     String locatorURI = "multiplex://localhost:8080" + parameters;
/*  85 */     InvokerLocator locator = new InvokerLocator(locatorURI);
/*  86 */     this.connector = new Connector(locator.getLocatorURI());
/*  87 */     this.connector.create();
/*  88 */     this.connector.start();
/*  89 */     System.out.println("Started callback server at:    " + this.connector.getInvokerLocator());
/*  90 */     return this.connector.getLocator();
/*     */   }
/*     */ 
/*     */   public void setUp()
/*     */     throws Exception
/*     */   {
/*  96 */     this.locator = initServer();
/*  97 */     init();
/*     */   }
/*     */ 
/*     */   public void tearDown() throws Throwable
/*     */   {
/* 102 */     while (!this.handler.gotCallbacks) {
/* 103 */       Thread.sleep(1000L);
/*     */     }
/* 105 */     this.client.removeListener(this.handler);
/*     */ 
/* 107 */     if (this.connector != null)
/*     */     {
/* 109 */       this.connector.stop();
/* 110 */       this.connector.destroy();
/* 111 */       this.connector = null;
/*     */     }
/* 113 */     this.locator = null;
/* 114 */     if (this.client != null)
/*     */     {
/* 116 */       this.client.disconnect();
/* 117 */       this.client = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void makeClientCall()
/*     */     throws Throwable
/*     */   {
/* 124 */     this.handler = new SampleCallbackHandler();
/*     */ 
/* 127 */     this.client.addListener(this.handler, this.locator, this.client.getSessionId());
/*     */ 
/* 130 */     Object answer = this.client.invoke(new Integer(17));
/*     */ 
/* 132 */     System.out.println("invocation returns: " + ((Integer)answer).intValue());
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 138 */     Server3Client1 test = new Server3Client1();
/*     */     try
/*     */     {
/* 142 */       test.setUp();
/* 143 */       test.makeClientCall();
/* 144 */       test.tearDown();
/*     */     }
/*     */     catch (Throwable throwable)
/*     */     {
/* 148 */       throwable.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class SampleCallbackHandler implements InvokerCallbackHandler
/*     */   {
/*     */     int callbackCounter;
/*     */     boolean gotCallbacks;
/*     */ 
/*     */     public void handleCallback(Callback callback) throws HandleCallbackException {
/* 160 */       Object ret = callback.getCallbackObject();
/* 161 */       System.out.println("callback value: " + ret);
/*     */ 
/* 163 */       if (++this.callbackCounter == 2)
/* 164 */         this.gotCallbacks = true;
/*     */     }
/*     */ 
/*     */     public boolean gotCallbacks()
/*     */     {
/* 169 */       return this.gotCallbacks;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.multiplex.invoker.Server3Client1
 * JD-Core Version:    0.6.0
 */