/*     */ package org.jboss.remoting.samples.multiplex.invoker;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.callback.Callback;
/*     */ import org.jboss.remoting.callback.HandleCallbackException;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.remoting.transport.ClientInvoker;
/*     */ import org.jboss.remoting.transport.Connector;
/*     */ 
/*     */ public class Server2Client2
/*     */ {
/*     */   private Client client;
/*     */   private SampleCallbackHandler handler;
/*     */   private Connector connector;
/*     */   private InvokerLocator locator;
/*     */ 
/*     */   public void init()
/*     */   {
/*     */     try
/*     */     {
/*  60 */       String locatorURI = "multiplex://localhost:9090/?multiplexBindHost=localhost&multiplexBindPort=8080";
/*  61 */       InvokerLocator locator = new InvokerLocator(locatorURI);
/*  62 */       this.client = new Client(locator, "sample");
/*  63 */       this.client.connect();
/*  64 */       System.out.println("Connected client to server at: " + this.client.getInvoker().getLocator().getLocatorURI());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  68 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   private InvokerLocator initServer()
/*     */     throws Exception
/*     */   {
/*  82 */     String locatorURI = "multiplex://localhost:8080/?multiplexConnectHost=localhost&multiplexConnectPort=9090";
/*  83 */     InvokerLocator locator = new InvokerLocator(locatorURI);
/*  84 */     this.connector = new Connector(locator.getLocatorURI());
/*  85 */     this.connector.create();
/*  86 */     this.connector.start();
/*  87 */     System.out.println("Started callback server at:    " + this.connector.getInvokerLocator());
/*  88 */     return this.connector.getLocator();
/*     */   }
/*     */ 
/*     */   public void setUp()
/*     */     throws Exception
/*     */   {
/*  94 */     this.locator = initServer();
/*  95 */     init();
/*     */   }
/*     */ 
/*     */   public void tearDown() throws Throwable
/*     */   {
/* 100 */     while (!this.handler.gotCallbacks) {
/* 101 */       Thread.sleep(1000L);
/*     */     }
/* 103 */     this.client.removeListener(this.handler);
/*     */ 
/* 105 */     if (this.connector != null)
/*     */     {
/* 107 */       this.connector.stop();
/* 108 */       this.connector.destroy();
/* 109 */       this.connector = null;
/*     */     }
/* 111 */     this.locator = null;
/* 112 */     if (this.client != null)
/*     */     {
/* 114 */       this.client.disconnect();
/* 115 */       this.client = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void makeClientCall()
/*     */     throws Throwable
/*     */   {
/* 122 */     this.handler = new SampleCallbackHandler();
/*     */ 
/* 125 */     this.client.addListener(this.handler, this.locator, this.client.getSessionId());
/*     */ 
/* 128 */     Object answer = this.client.invoke(new Integer(17));
/*     */ 
/* 130 */     System.out.println("invocation returns: " + ((Integer)answer).intValue());
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 136 */     Server2Client2 test = new Server2Client2();
/*     */     try
/*     */     {
/* 140 */       test.setUp();
/* 141 */       test.makeClientCall();
/* 142 */       test.tearDown();
/*     */     }
/*     */     catch (Throwable throwable)
/*     */     {
/* 146 */       throwable.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class SampleCallbackHandler implements InvokerCallbackHandler
/*     */   {
/*     */     int callbackCounter;
/*     */     boolean gotCallbacks;
/*     */ 
/*     */     public void handleCallback(Callback callback) throws HandleCallbackException {
/* 158 */       Object ret = callback.getCallbackObject();
/* 159 */       System.out.println("callback value: " + ret);
/*     */ 
/* 161 */       if (++this.callbackCounter == 2)
/* 162 */         this.gotCallbacks = true;
/*     */     }
/*     */ 
/*     */     public boolean gotCallbacks()
/*     */     {
/* 167 */       return this.gotCallbacks;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.multiplex.invoker.Server2Client2
 * JD-Core Version:    0.6.0
 */