/*     */ package org.jboss.remoting.samples.multiplex.invoker;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.management.MBeanServer;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.ServerInvocationHandler;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ import org.jboss.remoting.callback.Callback;
/*     */ import org.jboss.remoting.callback.HandleCallbackException;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.remoting.transport.Connector;
/*     */ 
/*     */ public class MultiplexInvokerServer
/*     */ {
/*     */   private SampleInvocationHandler handler;
/*     */   private Connector connector;
/*     */ 
/*     */   public MultiplexInvokerServer()
/*     */   {
/*  51 */     this.connector = null;
/*     */   }
/*     */ 
/*     */   public void init() throws Exception
/*     */   {
/*  56 */     this.connector = new Connector();
/*  57 */     InvokerLocator locator = new InvokerLocator("multiplex://localhost:9090");
/*  58 */     this.connector.setInvokerLocator(locator.getLocatorURI());
/*  59 */     this.connector.create();
/*  60 */     this.handler = new SampleInvocationHandler();
/*  61 */     this.connector.addInvocationHandler("sample", this.handler);
/*  62 */     this.connector.start();
/*  63 */     System.out.println("Started server at: " + this.connector.getInvokerLocator());
/*     */   }
/*     */ 
/*     */   public boolean isDone()
/*     */   {
/*  69 */     return this.handler.isDone();
/*     */   }
/*     */ 
/*     */   protected void setUp()
/*     */     throws Exception
/*     */   {
/*  75 */     init();
/*     */   }
/*     */ 
/*     */   protected void tearDown()
/*     */     throws Exception
/*     */   {
/*  81 */     if (this.connector != null)
/*     */     {
/*  83 */       this.connector.stop();
/*  84 */       this.connector.destroy();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*  91 */     MultiplexInvokerServer test = new MultiplexInvokerServer();
/*     */     try
/*     */     {
/*  94 */       test.setUp();
/*     */ 
/*  96 */       while (!test.isDone()) {
/*  97 */         Thread.sleep(1000L);
/*     */       }
/*  99 */       test.tearDown();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 103 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class SampleInvocationHandler
/*     */     implements ServerInvocationHandler, Runnable
/*     */   {
/* 115 */     private List listeners = new ArrayList();
/* 116 */     private boolean didCallbacks = false;
/*     */ 
/*     */     public SampleInvocationHandler()
/*     */     {
/* 121 */       Thread callbackThread = new Thread(this);
/* 122 */       callbackThread.setDaemon(true);
/* 123 */       callbackThread.start();
/*     */     }
/*     */ 
/*     */     public Object invoke(InvocationRequest invocation)
/*     */       throws Throwable
/*     */     {
/* 136 */       System.out.println("Invocation request is: " + invocation.getParameter());
/*     */ 
/* 139 */       return invocation.getParameter();
/*     */     }
/*     */ 
/*     */     public void addListener(InvokerCallbackHandler callbackHandler)
/*     */     {
/* 150 */       System.out.println("Adding callback listener.");
/* 151 */       this.listeners.add(callbackHandler);
/*     */     }
/*     */ 
/*     */     public void removeListener(InvokerCallbackHandler callbackHandler)
/*     */     {
/* 162 */       System.out.println("Removing callback listener.");
/* 163 */       this.listeners.remove(callbackHandler);
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/* 173 */       while (this.listeners.isEmpty())
/*     */       {
/*     */         try
/*     */         {
/* 177 */           Thread.sleep(1000L);
/*     */         }
/*     */         catch (InterruptedException e)
/*     */         {
/*     */         }
/*     */       }
/*     */ 
/* 184 */       for (int i = 0; i < 2; i++)
/*     */       {
/* 187 */         Callback callback = new Callback(new Integer(29 * (i + 1)));
/* 188 */         System.out.println("generating callback value: " + callback.getCallbackObject());
/*     */ 
/* 191 */         List localListeners = new ArrayList(this.listeners);
/*     */ 
/* 194 */         Iterator itr = localListeners.iterator();
/* 195 */         while (itr.hasNext())
/*     */         {
/* 197 */           InvokerCallbackHandler callbackHandler = (InvokerCallbackHandler)itr.next();
/*     */           try
/*     */           {
/* 201 */             callbackHandler.handleCallback(callback);
/*     */           }
/*     */           catch (HandleCallbackException e)
/*     */           {
/* 205 */             e.printStackTrace();
/*     */           }
/*     */ 
/*     */           try
/*     */           {
/* 210 */             Thread.sleep(2000L);
/*     */           }
/*     */           catch (InterruptedException ignored)
/*     */           {
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 218 */       this.didCallbacks = true;
/*     */     }
/*     */ 
/*     */     public void setMBeanServer(MBeanServer server)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void setInvoker(ServerInvoker invoker)
/*     */     {
/*     */     }
/*     */ 
/*     */     public boolean isDone()
/*     */     {
/* 244 */       return this.didCallbacks;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.multiplex.invoker.MultiplexInvokerServer
 * JD-Core Version:    0.6.0
 */