/*     */ package org.jboss.remoting.samples.multiplex.invoker;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.callback.Callback;
/*     */ import org.jboss.remoting.callback.HandleCallbackException;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.remoting.transport.ClientInvoker;
/*     */ import org.jboss.remoting.transport.Connector;
/*     */ 
/*     */ public class Client2Server1
/*     */ {
/*     */   private Client client;
/*     */   private SampleCallbackHandler handler;
/*     */   private Connector connector;
/*     */   private InvokerLocator locator;
/*     */ 
/*     */   public void init()
/*     */   {
/*     */     try
/*     */     {
/*  64 */       String locatorURI = "multiplex://localhost:9090";
/*  65 */       InvokerLocator locator = new InvokerLocator(locatorURI);
/*  66 */       Map configuration = new HashMap();
/*  67 */       configuration.put("multiplexBindHost", "localhost");
/*  68 */       configuration.put("multiplexBindPort", "8080");
/*  69 */       configuration.put("clientMultiplexId", "client2server2");
/*  70 */       this.client = new Client(locator, "sample", configuration);
/*  71 */       this.client.connect();
/*  72 */       System.out.println("Connected client to server at: " + this.client.getInvoker().getLocator().getLocatorURI());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  76 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   private InvokerLocator initServer()
/*     */     throws Exception
/*     */   {
/*  90 */     String locatorURI = "multiplex://localhost:8080";
/*  91 */     InvokerLocator locator = new InvokerLocator(locatorURI);
/*  92 */     Map configuration = new HashMap();
/*  93 */     configuration.put("serverMultiplexId", "client2server2");
/*  94 */     this.connector = new Connector(locator.getLocatorURI(), configuration);
/*  95 */     this.connector.create();
/*  96 */     this.connector.start();
/*  97 */     System.out.println("Started callback server at:    " + this.connector.getInvokerLocator());
/*  98 */     return this.connector.getLocator();
/*     */   }
/*     */ 
/*     */   public void setUp()
/*     */     throws Exception
/*     */   {
/* 104 */     init();
/* 105 */     this.locator = initServer();
/*     */   }
/*     */ 
/*     */   public void tearDown() throws Throwable
/*     */   {
/* 110 */     while (!this.handler.gotCallbacks) {
/* 111 */       Thread.sleep(1000L);
/*     */     }
/* 113 */     this.client.removeListener(this.handler);
/*     */ 
/* 115 */     if (this.connector != null)
/*     */     {
/* 117 */       this.connector.stop();
/* 118 */       this.connector.destroy();
/* 119 */       this.connector = null;
/*     */     }
/* 121 */     this.locator = null;
/* 122 */     if (this.client != null)
/*     */     {
/* 124 */       this.client.disconnect();
/* 125 */       this.client = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void makeClientCall()
/*     */     throws Throwable
/*     */   {
/* 132 */     this.handler = new SampleCallbackHandler();
/*     */ 
/* 135 */     this.client.addListener(this.handler, this.locator, this.client.getSessionId());
/*     */ 
/* 138 */     Object answer = this.client.invoke(new Integer(17));
/*     */ 
/* 140 */     System.out.println("invocation returns: " + ((Integer)answer).intValue());
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 146 */     Client2Server1 test = new Client2Server1();
/*     */     try
/*     */     {
/* 150 */       test.setUp();
/* 151 */       test.makeClientCall();
/* 152 */       test.tearDown();
/*     */     }
/*     */     catch (Throwable throwable)
/*     */     {
/* 156 */       throwable.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class SampleCallbackHandler implements InvokerCallbackHandler
/*     */   {
/*     */     int callbackCounter;
/*     */     boolean gotCallbacks;
/*     */ 
/*     */     public void handleCallback(Callback callback) throws HandleCallbackException {
/* 168 */       Object ret = callback.getCallbackObject();
/* 169 */       System.out.println("callback value: " + ret);
/*     */ 
/* 171 */       if (++this.callbackCounter == 2)
/* 172 */         this.gotCallbacks = true;
/*     */     }
/*     */ 
/*     */     public boolean gotCallbacks()
/*     */     {
/* 177 */       return this.gotCallbacks;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.multiplex.invoker.Client2Server1
 * JD-Core Version:    0.6.0
 */