/*     */ package org.jboss.remoting.samples.multiplex;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.net.InetSocketAddress;
/*     */ import java.net.Socket;
/*     */ import org.jboss.remoting.transport.multiplex.VirtualServerSocket;
/*     */ import org.jboss.remoting.transport.multiplex.VirtualSocket;
/*     */ 
/*     */ public class SymmetricScenarioClient
/*     */ {
/*  49 */   static int bindPort = 5555;
/*  50 */   static String connectHost = "localhost";
/*  51 */   static int connectPort = 6666;
/*     */ 
/*     */   public void runSymmetricScenario()
/*     */   {
/*     */     try
/*     */     {
/*  59 */       Socket syncSocket = new Socket(connectHost, connectPort);
/*  60 */       InputStream is_sync = syncSocket.getInputStream();
/*  61 */       OutputStream os_sync = syncSocket.getOutputStream();
/*     */ 
/*  65 */       VirtualServerSocket serverSocket = new VirtualServerSocket(bindPort);
/*  66 */       InetSocketAddress address1 = new InetSocketAddress(connectHost, connectPort + 1);
/*  67 */       is_sync.read();
/*  68 */       serverSocket.setSoTimeout(5000);
/*  69 */       serverSocket.connect(address1);
/*     */ 
/*  73 */       os_sync.write(5);
/*  74 */       is_sync.read();
/*  75 */       int port = serverSocket.getRemotePort();
/*  76 */       Socket virtualSocket1 = new VirtualSocket(connectHost, port);
/*  77 */       InputStream is1 = virtualSocket1.getInputStream();
/*  78 */       OutputStream os1 = virtualSocket1.getOutputStream();
/*     */ 
/*  81 */       Socket virtualSocket2 = serverSocket.accept();
/*  82 */       InputStream is2 = virtualSocket2.getInputStream();
/*  83 */       OutputStream os2 = virtualSocket2.getOutputStream();
/*     */ 
/*  86 */       os1.write(9);
/*  87 */       System.out.println(is1.read());
/*  88 */       os2.write(11);
/*  89 */       System.out.println(is2.read());
/*  90 */       virtualSocket1.close();
/*  91 */       virtualSocket2.close();
/*  92 */       syncSocket.close();
/*  93 */       serverSocket.close();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  97 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 103 */     if (args.length == 3)
/*     */     {
/* 105 */       bindPort = Integer.parseInt(args[0]);
/* 106 */       connectHost = args[1];
/* 107 */       connectPort = Integer.parseInt(args[2]);
/*     */     }
/*     */ 
/* 110 */     new SymmetricScenarioClient().runSymmetricScenario();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.multiplex.SymmetricScenarioClient
 * JD-Core Version:    0.6.0
 */