/*     */ package org.jboss.remoting.samples.multiplex;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.net.InetAddress;
/*     */ import java.net.ServerSocket;
/*     */ import java.net.Socket;
/*     */ import org.jboss.remoting.transport.multiplex.MasterServerSocket;
/*     */ import org.jboss.remoting.transport.multiplex.VirtualSocket;
/*     */ 
/*     */ public class PrimeScenarioExampleServer
/*     */ {
/*     */   public void runPrimeScenario()
/*     */   {
/*     */     try
/*     */     {
/*  51 */       ServerSocket serverSocket = new MasterServerSocket(5555);
/*  52 */       serverSocket.setSoTimeout(10000);
/*  53 */       Socket v2 = serverSocket.accept();
/*     */ 
/*  56 */       Thread asynchronousThread = new AsynchronousThread(v2);
/*  57 */       asynchronousThread.start();
/*     */ 
/*  60 */       ObjectInputStream ois = new ObjectInputStream(v2.getInputStream());
/*  61 */       ObjectOutputStream oos = new ObjectOutputStream(v2.getOutputStream());
/*  62 */       v2.setSoTimeout(10000);
/*  63 */       Object o = ois.readObject();
/*  64 */       oos.writeObject(o);
/*     */ 
/*  66 */       asynchronousThread.join();
/*  67 */       serverSocket.close();
/*  68 */       v2.close();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  73 */       e.printStackTrace();
/*  74 */       System.exit(1);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 119 */     new PrimeScenarioExampleServer().runPrimeScenario();
/*     */   }
/*     */ 
/*     */   class AsynchronousThread extends Thread
/*     */   {
/*     */     private Socket virtualSocket;
/*     */ 
/*     */     public AsynchronousThread(Socket socket)
/*     */       throws IOException
/*     */     {
/*  85 */       this.virtualSocket = socket;
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/*     */       try
/*     */       {
/*  93 */         Thread.sleep(2000L);
/*     */ 
/*  96 */         String hostName = this.virtualSocket.getInetAddress().getHostName();
/*  97 */         int port = this.virtualSocket.getPort();
/*  98 */         Socket v3 = new VirtualSocket(hostName, port);
/*     */ 
/* 101 */         ObjectOutputStream oos = new ObjectOutputStream(v3.getOutputStream());
/* 102 */         oos.writeObject(new Integer(7));
/*     */ 
/* 104 */         oos.flush();
/* 105 */         v3.close();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 109 */         e.printStackTrace();
/* 110 */         System.exit(1);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.multiplex.PrimeScenarioExampleServer
 * JD-Core Version:    0.6.0
 */