/*    */ package org.jboss.remoting.samples.multiplex;
/*    */ 
/*    */ import java.io.InputStream;
/*    */ import java.io.OutputStream;
/*    */ import java.net.Socket;
/*    */ import org.jboss.remoting.transport.multiplex.MasterServerSocket;
/*    */ import org.jboss.remoting.transport.multiplex.VirtualSocket;
/*    */ 
/*    */ public class N_SocketScenarioServer
/*    */ {
/* 47 */   static int bindPort = 6666;
/* 48 */   static String connectHost = "localhost";
/* 49 */   static int connectPort = 5555;
/*    */ 
/*    */   public void runN_SocketScenario()
/*    */   {
/*    */     try
/*    */     {
/* 56 */       MasterServerSocket serverSocket = new MasterServerSocket(bindPort);
/*    */ 
/* 59 */       serverSocket.setSoTimeout(10000);
/* 60 */       serverSocket.acceptServerSocketConnection();
/*    */ 
/* 63 */       Thread.sleep(2000L);
/* 64 */       Socket socket1 = new VirtualSocket(connectHost, connectPort);
/* 65 */       Socket socket2 = new VirtualSocket(connectHost, connectPort);
/* 66 */       Socket socket3 = new VirtualSocket(connectHost, connectPort);
/*    */ 
/* 69 */       InputStream is1 = socket1.getInputStream();
/* 70 */       OutputStream os1 = socket1.getOutputStream();
/* 71 */       InputStream is2 = socket2.getInputStream();
/* 72 */       OutputStream os2 = socket2.getOutputStream();
/* 73 */       InputStream is3 = socket3.getInputStream();
/* 74 */       OutputStream os3 = socket3.getOutputStream();
/* 75 */       os1.write(is1.read());
/* 76 */       os2.write(is2.read());
/* 77 */       os3.write(is3.read());
/*    */ 
/* 79 */       socket1.close();
/* 80 */       socket2.close();
/* 81 */       socket3.close();
/* 82 */       serverSocket.close();
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 86 */       e.printStackTrace();
/*    */     }
/*    */   }
/*    */ 
/*    */   public static void main(String[] args)
/*    */   {
/* 92 */     if (args.length == 3)
/*    */     {
/* 94 */       bindPort = Integer.parseInt(args[0]);
/* 95 */       connectHost = args[1];
/* 96 */       connectPort = Integer.parseInt(args[2]);
/*    */     }
/*    */ 
/* 99 */     new N_SocketScenarioServer().runN_SocketScenario();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.multiplex.N_SocketScenarioServer
 * JD-Core Version:    0.6.0
 */