/*    */ package org.jboss.remoting.samples.http;
/*    */ 
/*    */ import java.io.PrintStream;
/*    */ import org.jboss.remoting.InvokerLocator;
/*    */ import org.jboss.remoting.ServerInvocationHandler;
/*    */ import org.jboss.remoting.transport.Connector;
/*    */ 
/*    */ public class SimpleServer
/*    */ {
/* 38 */   private static String transport = "http";
/* 39 */   private static String host = "localhost";
/* 40 */   private static int port = 5400;
/*    */ 
/*    */   public void setupServer(String locatorURI)
/*    */     throws Exception
/*    */   {
/* 47 */     InvokerLocator locator = new InvokerLocator(locatorURI);
/* 48 */     System.out.println("Starting remoting server with locator uri of: " + locatorURI);
/* 49 */     Connector connector = new Connector(locator);
/*    */ 
/* 51 */     connector.create();
/*    */ 
/* 54 */     ServerInvocationHandler invocationHandler = new WebInvocationHandler();
/*    */ 
/* 56 */     connector.addInvocationHandler("sample", invocationHandler);
/*    */ 
/* 60 */     connector.start();
/*    */   }
/*    */ 
/*    */   public static void main(String[] args)
/*    */   {
/* 72 */     if ((args != null) && (args.length == 3))
/*    */     {
/* 74 */       transport = args[0];
/* 75 */       host = args[1];
/* 76 */       port = Integer.parseInt(args[2]);
/*    */     }
/* 78 */     String locatorURI = transport + "://" + host + ":" + port;
/* 79 */     SimpleServer server = new SimpleServer();
/*    */     try
/*    */     {
/* 82 */       server.setupServer(locatorURI);
/*    */       while (true)
/*    */       {
/* 87 */         Thread.sleep(1000L);
/*    */       }
/*    */ 
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 93 */       e.printStackTrace();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.http.SimpleServer
 * JD-Core Version:    0.6.0
 */