/*     */ package org.jboss.remoting.samples.detection.multicast;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.util.Date;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerFactory;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.ServerInvocationHandler;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.remoting.detection.multicast.MulticastDetector;
/*     */ import org.jboss.remoting.transport.Connector;
/*     */ 
/*     */ public class SimpleDetectorServer
/*     */ {
/*  46 */   private static String transport = "socket";
/*  47 */   private static String host = "localhost";
/*  48 */   private static int port = 5400;
/*     */ 
/*     */   public void setupDetector()
/*     */     throws Exception
/*     */   {
/*  60 */     MBeanServer server = MBeanServerFactory.createMBeanServer();
/*     */ 
/*  63 */     MulticastDetector detector = new MulticastDetector();
/*  64 */     server.registerMBean(detector, new ObjectName("remoting:type=MulticastDetector"));
/*  65 */     detector.start();
/*  66 */     println("MulticastDetector has been created and is listening for new NetworkRegistries to come online");
/*     */   }
/*     */ 
/*     */   public void setupServer(String locatorURI)
/*     */     throws Exception
/*     */   {
/*  81 */     InvokerLocator locator = new InvokerLocator(locatorURI);
/*  82 */     println("Starting remoting server with locator uri of: " + locatorURI);
/*  83 */     Connector connector = new Connector();
/*  84 */     connector.setInvokerLocator(locator.getLocatorURI());
/*  85 */     connector.create();
/*     */ 
/*  87 */     SampleInvocationHandler invocationHandler = new SampleInvocationHandler();
/*     */ 
/*  90 */     connector.addInvocationHandler("sample", invocationHandler);
/*     */ 
/*  92 */     println("Added our invocation handler; we are now ready to begin accepting messages from clients");
/*     */ 
/*  94 */     connector.start();
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 107 */     String prop = System.getProperty("args");
/* 108 */     if (prop != null)
/*     */     {
/*     */       try
/*     */       {
/* 112 */         transport = prop.substring(0, prop.indexOf("-"));
/* 113 */         port = Integer.parseInt(prop.substring(prop.indexOf("-") + 1));
/*     */       }
/*     */       catch (NumberFormatException nfe)
/*     */       {
/* 117 */         println("INVALID ARGUMENTS: Bad port from property args: " + prop);
/* 118 */         System.exit(1);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 122 */         println("INVALID ARGUMENTS: -Dargs property must be in the form '{socket|rmi}-{port#}': " + prop);
/* 123 */         System.exit(1);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 128 */     if ((args != null) && (args.length != 0))
/*     */     {
/* 130 */       if (args.length == 2)
/*     */       {
/* 132 */         transport = args[0];
/* 133 */         port = Integer.parseInt(args[1]);
/*     */       }
/*     */       else
/*     */       {
/* 137 */         println("INVALID ARGUMENTS: Usage: " + SimpleDetectorServer.class.getName() + " [rmi|socket <port>]");
/*     */ 
/* 139 */         System.exit(1);
/*     */       }
/*     */     }
/*     */ 
/* 143 */     println("Starting JBoss/Remoting server... to stop this server, kill it manually via Control-C");
/*     */ 
/* 145 */     String locatorURI = transport + "://" + host + ":" + port;
/* 146 */     println("This server's endpoint will be: " + locatorURI);
/*     */ 
/* 148 */     SimpleDetectorServer server = new SimpleDetectorServer();
/*     */     try
/*     */     {
/* 151 */       server.setupDetector();
/* 152 */       server.setupServer(locatorURI);
/*     */       while (true)
/*     */       {
/* 157 */         Thread.sleep(1000L);
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 162 */       e.printStackTrace();
/*     */ 
/* 165 */       println("Stopping JBoss/Remoting server");
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void println(String msg)
/*     */   {
/* 175 */     System.out.println(new Date() + ": [SERVER]: " + msg);
/*     */   }
/*     */ 
/*     */   public static class SampleInvocationHandler
/*     */     implements ServerInvocationHandler
/*     */   {
/*     */     public Object invoke(InvocationRequest invocation)
/*     */       throws Throwable
/*     */     {
/* 195 */       String msg = invocation.getParameter().toString();
/*     */ 
/* 197 */       SimpleDetectorServer.println("RECEIVED A CLIENT MESSAGE: " + msg);
/*     */ 
/* 199 */       String response = "Server received your message that said [" + msg + "]";
/*     */ 
/* 201 */       if (msg.indexOf("Welcome") > -1)
/*     */       {
/* 203 */         response = "Received your welcome message.  Thank you!";
/*     */       }
/*     */ 
/* 206 */       SimpleDetectorServer.println("Returning the following message back to the client: " + response);
/*     */ 
/* 208 */       return response;
/*     */     }
/*     */ 
/*     */     public void addListener(InvokerCallbackHandler callbackHandler)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void removeListener(InvokerCallbackHandler callbackHandler)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void setMBeanServer(MBeanServer server)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void setInvoker(ServerInvoker invoker)
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.detection.multicast.SimpleDetectorServer
 * JD-Core Version:    0.6.0
 */