/*     */ package org.jboss.remoting.samples.detection.multicast;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.util.Date;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerFactory;
/*     */ import javax.management.Notification;
/*     */ import javax.management.NotificationListener;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.detection.multicast.MulticastDetector;
/*     */ import org.jboss.remoting.network.NetworkNotification;
/*     */ import org.jboss.remoting.network.NetworkRegistry;
/*     */ 
/*     */ public class SimpleDetectorClient
/*     */   implements NotificationListener
/*     */ {
/*     */   public void setupDetector()
/*     */     throws Exception
/*     */   {
/*  59 */     MBeanServer server = MBeanServerFactory.createMBeanServer();
/*     */ 
/*  62 */     NetworkRegistry registry = NetworkRegistry.getInstance();
/*  63 */     server.registerMBean(registry, new ObjectName("remoting:type=NetworkRegistry"));
/*  64 */     println("NetworkRegistry has been created");
/*     */ 
/*  67 */     registry.addNotificationListener(this, null, null);
/*  68 */     println("NetworkRegistry has added the client as a listener");
/*     */ 
/*  71 */     MulticastDetector detector = new MulticastDetector();
/*  72 */     server.registerMBean(detector, new ObjectName("remoting:type=MulticastDetector"));
/*  73 */     detector.start();
/*  74 */     println("MulticastDetector has been created and is listening for new NetworkRegistries to come online");
/*     */   }
/*     */ 
/*     */   public void handleNotification(Notification notification, Object handback)
/*     */   {
/*  90 */     if ((notification instanceof NetworkNotification))
/*     */     {
/*  92 */       println("GOT A NETWORK-REGISTRY NOTIFICATION: " + notification.getType());
/*     */ 
/*  94 */       NetworkNotification networkNotification = (NetworkNotification)notification;
/*     */ 
/*  96 */       if ("jboss.network.server.added".equals(networkNotification.getType()))
/*     */       {
/*  98 */         println("New server(s) have been detected - getting locators and sending welcome messages");
/*  99 */         InvokerLocator[] locators = networkNotification.getLocator();
/* 100 */         for (int x = 0; x < locators.length; x++)
/*     */         {
/*     */           try
/*     */           {
/* 105 */             InvokerLocator newServerLocator = locators[x];
/* 106 */             makeInvocation(newServerLocator.getLocatorURI());
/*     */           }
/*     */           catch (Throwable throwable)
/*     */           {
/* 110 */             throwable.printStackTrace();
/*     */           }
/*     */         }
/*     */       }
/* 114 */       else if ("jboss.network.server.removed".equals(networkNotification.getType()))
/*     */       {
/* 116 */         InvokerLocator[] locators = networkNotification.getLocator();
/* 117 */         for (int x = 0; x < locators.length; x++)
/*     */         {
/* 119 */           println("It has been detected that a server has gone down with a locator of: " + locators[x]);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void makeInvocation(String locatorURI)
/*     */     throws Throwable
/*     */   {
/* 136 */     InvokerLocator locator = new InvokerLocator(locatorURI);
/* 137 */     println("Sending welcome message to remoting server with locator uri of: " + locatorURI);
/*     */ 
/* 139 */     Client remotingClient = new Client(locator);
/* 140 */     remotingClient.connect();
/* 141 */     Object response = remotingClient.invoke("Welcome Aboard!", null);
/*     */ 
/* 143 */     println("The newly discovered server sent this response to our welcome message: " + response);
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 155 */     println("Starting JBoss/Remoting client... to stop this client, kill it manually via Control-C");
/* 156 */     SimpleDetectorClient client = new SimpleDetectorClient();
/*     */     try
/*     */     {
/* 159 */       client.setupDetector();
/*     */       while (true)
/*     */       {
/* 164 */         Thread.sleep(1000L);
/*     */       }
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 169 */       e.printStackTrace();
/*     */ 
/* 172 */       println("Stopping JBoss/Remoting client");
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void println(String msg)
/*     */   {
/* 182 */     System.out.println(new Date() + ": [CLIENT]: " + msg);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.detection.multicast.SimpleDetectorClient
 * JD-Core Version:    0.6.0
 */