/*     */ package org.jboss.remoting.samples.detection.jndi;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.net.InetAddress;
/*     */ import java.util.Date;
/*     */ import org.jnp.server.Main;
/*     */ 
/*     */ public class SimpleJNDIServer
/*     */ {
/*  16 */   private static String transport = "socket";
/*  17 */   private static String host = "localhost";
/*  18 */   private static int port = 5400;
/*  19 */   private int detectorPort = 1099;
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*  30 */     String prop = System.getProperty("args");
/*  31 */     if (prop != null)
/*     */     {
/*     */       try
/*     */       {
/*  35 */         transport = prop.substring(0, prop.indexOf("-"));
/*  36 */         port = Integer.parseInt(prop.substring(prop.indexOf("-") + 1));
/*     */       }
/*     */       catch (NumberFormatException nfe)
/*     */       {
/*  40 */         println("INVALID ARGUMENTS: Bad port from property args: " + prop);
/*  41 */         System.exit(1);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*  45 */         println("INVALID ARGUMENTS: -Dargs property must be in the form '{socket|rmi}-{port#}': " + prop);
/*  46 */         System.exit(1);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  51 */     if ((args != null) && (args.length != 0))
/*     */     {
/*  53 */       if (args.length == 2)
/*     */       {
/*  55 */         transport = args[0];
/*  56 */         port = Integer.parseInt(args[1]);
/*     */       }
/*     */       else
/*     */       {
/*  60 */         println("INVALID ARGUMENTS: Usage: " + SimpleJNDIServer.class.getName() + " [rmi|socket <port>]");
/*     */ 
/*  62 */         System.exit(1);
/*     */       }
/*     */     }
/*     */ 
/*  66 */     println("Starting JNDI server... to stop this server, kill it manually via Control-C");
/*     */ 
/*  68 */     SimpleJNDIServer server = new SimpleJNDIServer();
/*     */     try
/*     */     {
/*  71 */       server.setupJNDIServer();
/*     */       while (true)
/*     */       {
/*  76 */         Thread.sleep(1000L);
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  81 */       e.printStackTrace();
/*     */ 
/*  84 */       println("Stopping JBoss/Remoting server");
/*     */     }
/*     */   }
/*     */ 
/*     */   private void setupJNDIServer() throws Exception
/*     */   {
/*  90 */     String detectorHost = InetAddress.getLocalHost().getHostName();
/*     */ 
/*  92 */     Main JNDIServer = new Main();
/*  93 */     JNDIServer.setPort(this.detectorPort);
/*  94 */     JNDIServer.setBindAddress(detectorHost);
/*  95 */     JNDIServer.start();
/*  96 */     System.out.println("Started JNDI server on " + detectorHost + ":" + this.detectorPort);
/*     */   }
/*     */ 
/*     */   public static void println(String msg)
/*     */   {
/* 107 */     System.out.println(new Date() + ": [SERVER]: " + msg);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.detection.jndi.SimpleJNDIServer
 * JD-Core Version:    0.6.0
 */