/*     */ package org.jboss.remoting.samples.detection.jndi;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.net.InetAddress;
/*     */ import java.util.Date;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerFactory;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.ServerInvocationHandler;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.remoting.detection.jndi.JNDIDetector;
/*     */ import org.jboss.remoting.transport.Connector;
/*     */ 
/*     */ public class SimpleDetectorServer
/*     */ {
/*  28 */   protected static String transport = "socket";
/*  29 */   protected static String host = "localhost";
/*  30 */   protected static int port = 5400;
/*     */   private int detectorPort;
/*     */   private String contextFactory;
/*     */   private String urlPackage;
/*     */ 
/*     */   public SimpleDetectorServer()
/*     */   {
/*  32 */     this.detectorPort = 1099;
/*  33 */     this.contextFactory = "org.jnp.interfaces.NamingContextFactory";
/*  34 */     this.urlPackage = "org.jboss.naming:org.jnp.interfaces";
/*     */   }
/*     */ 
/*     */   public void setupDetector()
/*     */     throws Exception
/*     */   {
/*  47 */     MBeanServer server = MBeanServerFactory.createMBeanServer();
/*     */ 
/*  49 */     String detectorHost = InetAddress.getLocalHost().getHostName();
/*     */ 
/*  52 */     JNDIDetector detector = new JNDIDetector(getConfiguration());
/*     */ 
/*  54 */     detector.setPort(this.detectorPort);
/*  55 */     detector.setHost(detectorHost);
/*  56 */     detector.setContextFactory(this.contextFactory);
/*  57 */     detector.setURLPackage(this.urlPackage);
/*     */ 
/*  59 */     server.registerMBean(detector, new ObjectName("remoting:type=JNDIDetector"));
/*  60 */     detector.start();
/*  61 */     println("JNDIDetector has been created and is listening for new NetworkRegistries to come online");
/*     */   }
/*     */ 
/*     */   public void setupServer(String locatorURI)
/*     */     throws Exception
/*     */   {
/*  75 */     InvokerLocator locator = new InvokerLocator(locatorURI);
/*  76 */     println("Starting remoting server with locator uri of: " + locatorURI);
/*  77 */     Connector connector = new Connector(getConfiguration());
/*  78 */     connector.setInvokerLocator(locator.getLocatorURI());
/*  79 */     connector.create();
/*     */ 
/*  81 */     SampleInvocationHandler invocationHandler = new SampleInvocationHandler();
/*     */ 
/*  84 */     connector.addInvocationHandler("sample", invocationHandler);
/*     */ 
/*  86 */     println("Added our invocation handler; we are now ready to begin accepting messages from clients");
/*     */ 
/*  88 */     connector.start();
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*  99 */     println("Starting JBoss/Remoting server... to stop this server, kill it manually via Control-C");
/* 100 */     String locatorURI = getLocatorURI(args);
/* 101 */     println("This server's endpoint will be: " + locatorURI);
/*     */ 
/* 103 */     SimpleDetectorServer server = new SimpleDetectorServer();
/*     */     try
/*     */     {
/* 106 */       server.setupDetector();
/* 107 */       server.setupServer(locatorURI);
/*     */       while (true)
/*     */       {
/* 112 */         Thread.sleep(1000L);
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 117 */       e.printStackTrace();
/*     */ 
/* 120 */       println("Stopping JBoss/Remoting server");
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void println(String msg)
/*     */   {
/* 130 */     System.out.println(new Date() + ": [SERVER]: " + msg);
/*     */   }
/*     */ 
/*     */   protected static String getLocatorURI(String[] args)
/*     */   {
/* 136 */     String prop = System.getProperty("args");
/* 137 */     if (prop != null)
/*     */     {
/*     */       try
/*     */       {
/* 141 */         transport = prop.substring(0, prop.indexOf("-"));
/* 142 */         port = Integer.parseInt(prop.substring(prop.indexOf("-") + 1));
/*     */       }
/*     */       catch (NumberFormatException nfe)
/*     */       {
/* 146 */         println("INVALID ARGUMENTS: Bad port from property args: " + prop);
/* 147 */         System.exit(1);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 151 */         println("INVALID ARGUMENTS: -Dargs property must be in the form '{socket|rmi}-{port#}': " + prop);
/* 152 */         System.exit(1);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 157 */     if ((args != null) && (args.length != 0))
/*     */     {
/* 159 */       if (args.length == 2)
/*     */       {
/* 161 */         transport = args[0];
/* 162 */         port = Integer.parseInt(args[1]);
/*     */       }
/*     */       else
/*     */       {
/* 166 */         println("INVALID ARGUMENTS: Usage: " + SimpleDetectorServer.class.getName() + " [rmi|socket <port>]");
/*     */ 
/* 168 */         System.exit(1);
/*     */       }
/*     */     }
/*     */ 
/* 172 */     return transport + "://" + host + ":" + port;
/*     */   }
/*     */ 
/*     */   protected Map getConfiguration()
/*     */   {
/* 180 */     return new HashMap();
/*     */   }
/*     */ 
/*     */   protected SimpleDetectorServer getDetectorServer()
/*     */   {
/* 185 */     return new SimpleDetectorServer();
/*     */   }
/*     */ 
/*     */   public static class SampleInvocationHandler
/*     */     implements ServerInvocationHandler
/*     */   {
/*     */     public Object invoke(InvocationRequest invocation)
/*     */       throws Throwable
/*     */     {
/* 205 */       String msg = invocation.getParameter().toString();
/*     */ 
/* 207 */       SimpleDetectorServer.println("RECEIVED A CLIENT MESSAGE: " + msg);
/*     */ 
/* 209 */       String response = "Server received your message that said [" + msg + "]";
/*     */ 
/* 211 */       if (msg.indexOf("Welcome") > -1)
/*     */       {
/* 213 */         response = "Received your welcome message.  Thank you!";
/*     */       }
/*     */ 
/* 216 */       SimpleDetectorServer.println("Returning the following message back to the client: " + response);
/*     */ 
/* 218 */       return response;
/*     */     }
/*     */ 
/*     */     public void addListener(InvokerCallbackHandler callbackHandler)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void removeListener(InvokerCallbackHandler callbackHandler)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void setMBeanServer(MBeanServer server)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void setInvoker(ServerInvoker invoker)
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.detection.jndi.SimpleDetectorServer
 * JD-Core Version:    0.6.0
 */