/*     */ package org.jboss.remoting.samples.detection.jndi;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.net.InetAddress;
/*     */ import java.util.Date;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MBeanServerFactory;
/*     */ import javax.management.Notification;
/*     */ import javax.management.NotificationListener;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.detection.jndi.JNDIDetector;
/*     */ import org.jboss.remoting.network.NetworkNotification;
/*     */ import org.jboss.remoting.network.NetworkRegistry;
/*     */ 
/*     */ public class SimpleDetectorClient
/*     */   implements NotificationListener
/*     */ {
/*  30 */   private int detectorPort = 1099;
/*  31 */   private String contextFactory = "org.jnp.interfaces.NamingContextFactory";
/*  32 */   private String urlPackage = "org.jboss.naming:org.jnp.interfaces";
/*     */ 
/*     */   public void setupDetector()
/*     */     throws Exception
/*     */   {
/*  45 */     MBeanServer server = MBeanServerFactory.createMBeanServer();
/*     */ 
/*  48 */     NetworkRegistry registry = NetworkRegistry.getInstance();
/*  49 */     server.registerMBean(registry, new ObjectName("remoting:type=NetworkRegistry"));
/*  50 */     println("NetworkRegistry has been created");
/*     */ 
/*  53 */     registry.addNotificationListener(this, null, null);
/*  54 */     println("NetworkRegistry has added the client as a listener");
/*     */ 
/*  56 */     String detectorHost = InetAddress.getLocalHost().getHostName();
/*     */ 
/*  59 */     JNDIDetector detector = new JNDIDetector(getConfiguration());
/*     */ 
/*  61 */     detector.setPort(this.detectorPort);
/*  62 */     detector.setHost(detectorHost);
/*  63 */     detector.setContextFactory(this.contextFactory);
/*  64 */     detector.setURLPackage(this.urlPackage);
/*     */ 
/*  66 */     server.registerMBean(detector, new ObjectName("remoting:type=JNDIDetector"));
/*  67 */     detector.start();
/*  68 */     println("JNDIDetector has been created and is listening for new NetworkRegistries to come online");
/*     */   }
/*     */ 
/*     */   public void handleNotification(Notification notification, Object handback)
/*     */   {
/*  84 */     if ((notification instanceof NetworkNotification))
/*     */     {
/*  86 */       println("GOT A NETWORK-REGISTRY NOTIFICATION: " + notification.getType());
/*     */ 
/*  88 */       NetworkNotification networkNotification = (NetworkNotification)notification;
/*     */ 
/*  90 */       if ("jboss.network.server.added".equals(networkNotification.getType()))
/*     */       {
/*  92 */         println("New server(s) have been detected - getting locators and sending welcome messages");
/*  93 */         InvokerLocator[] locators = networkNotification.getLocator();
/*  94 */         for (int x = 0; x < locators.length; x++)
/*     */         {
/*     */           try
/*     */           {
/*  99 */             InvokerLocator newServerLocator = locators[x];
/* 100 */             makeInvocation(newServerLocator.getLocatorURI());
/*     */           }
/*     */           catch (Throwable throwable)
/*     */           {
/* 104 */             throwable.printStackTrace();
/*     */           }
/*     */         }
/*     */       }
/* 108 */       else if ("jboss.network.server.removed".equals(networkNotification.getType()))
/*     */       {
/* 110 */         InvokerLocator[] locators = networkNotification.getLocator();
/* 111 */         for (int x = 0; x < locators.length; x++)
/*     */         {
/* 113 */           println("It has been detected that a server has gone down with a locator of: " + locators[x]);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void makeInvocation(String locatorURI)
/*     */     throws Throwable
/*     */   {
/* 130 */     InvokerLocator locator = new InvokerLocator(locatorURI);
/* 131 */     println("Sending welcome message to remoting server with locator uri of: " + locatorURI);
/*     */ 
/* 133 */     Client remotingClient = new Client(locator, getConfiguration());
/* 134 */     remotingClient.connect();
/* 135 */     Object response = remotingClient.invoke("Welcome Aboard!", null);
/*     */ 
/* 137 */     println("The newly discovered server sent this response to our welcome message: " + response);
/*     */ 
/* 139 */     remotingClient.disconnect();
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 150 */     println("Starting JBoss/Remoting client... to stop this client, kill it manually via Control-C");
/* 151 */     SimpleDetectorClient client = new SimpleDetectorClient();
/*     */     try
/*     */     {
/* 154 */       client.setupDetector();
/*     */       while (true)
/*     */       {
/* 159 */         Thread.sleep(1000L);
/*     */       }
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 164 */       e.printStackTrace();
/*     */ 
/* 167 */       println("Stopping JBoss/Remoting client");
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void println(String msg)
/*     */   {
/* 177 */     System.out.println(new Date() + ": [CLIENT]: " + msg);
/*     */   }
/*     */ 
/*     */   protected Map getConfiguration()
/*     */   {
/* 185 */     return new HashMap();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.detection.jndi.SimpleDetectorClient
 * JD-Core Version:    0.6.0
 */