/*     */ package org.jboss.remoting.samples.chat.utility;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ 
/*     */ public class ReadWriteArrayList
/*     */   implements Serializable
/*     */ {
/*     */   private ArrayList arrayList;
/*     */   private static final long serialVersionUID = 6L;
/*  19 */   private Gate gate = new Gate();
/*     */ 
/*     */   public ReadWriteArrayList()
/*     */   {
/*  23 */     this.arrayList = new ArrayList();
/*     */   }
/*     */ 
/*     */   public boolean add(Object o)
/*     */   {
/*  28 */     this.gate.enterWrite();
/*  29 */     this.arrayList.add(o);
/*  30 */     this.gate.leaveWrite();
/*  31 */     return true;
/*     */   }
/*     */ 
/*     */   public Object get(int i)
/*     */   {
/*  36 */     this.gate.enterRead(i);
/*  37 */     Object o = this.arrayList.get(i);
/*  38 */     this.gate.leaveRead();
/*  39 */     return o;
/*     */   }
/*     */ 
/*     */   public ArrayList copy()
/*     */   {
/*  44 */     return (ArrayList)subList(0, this.arrayList.size());
/*     */   }
/*     */ 
/*     */   public List subList(int from, int to)
/*     */   {
/*  49 */     this.gate.enterRead(to - 1);
/*  50 */     List list = new ArrayList(this.arrayList.subList(from, to));
/*  51 */     this.gate.leaveRead();
/*  52 */     return list;
/*     */   }
/*     */ 
/*     */   public Object firstElement()
/*     */   {
/*  57 */     return get(0);
/*     */   }
/*     */ 
/*     */   public Object remove(int i)
/*     */   {
/*  62 */     this.gate.enterRead(i);
/*  63 */     Object o = this.arrayList.remove(i);
/*  64 */     this.gate.leaveRead();
/*  65 */     return o;
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/*  70 */     return this.arrayList.size();
/*     */   }
/*     */ 
/*     */   public Object[] toArray()
/*     */   {
/*  75 */     return this.arrayList.toArray();
/*     */   }
/*     */ 
/*     */   public Object[] toArray(Object[] a)
/*     */   {
/*  80 */     return this.arrayList.toArray(a);
/*     */   }
/*     */ 
/*     */   public ArrayList toArrayList()
/*     */   {
/*  85 */     return this.arrayList;
/*     */   }
/*     */   class Gate implements Serializable {
/*     */     private static final long serialVersionUID = 7L;
/*     */     private int numberOfReaders;
/*     */     private int numberOfWriters;
/*     */ 
/*     */     Gate() {
/*     */     }
/*     */ 
/*     */     public synchronized void enterRead(int i) {
/*  99 */       while ((this.numberOfWriters > 0) || (i > ReadWriteArrayList.this.arrayList.size() - 1))
/*     */         try
/*     */         {
/* 102 */           wait();
/*     */         }
/*     */         catch (InterruptedException ie)
/*     */         {
/*     */         }
/* 107 */       this.numberOfReaders += 1;
/*     */     }
/*     */ 
/*     */     public synchronized void enterWrite()
/*     */     {
/* 112 */       while ((this.numberOfWriters > 0) || (this.numberOfReaders > 0))
/*     */         try
/*     */         {
/* 115 */           wait();
/*     */         }
/*     */         catch (InterruptedException ie)
/*     */         {
/*     */         }
/* 120 */       this.numberOfWriters += 1;
/*     */     }
/*     */ 
/*     */     public synchronized void leaveRead()
/*     */     {
/* 125 */       if (this.numberOfReaders <= 0) {
/* 126 */         throw new Error("number of readers <= 0");
/*     */       }
/* 128 */       this.numberOfReaders -= 1;
/* 129 */       notifyAll();
/*     */     }
/*     */ 
/*     */     public synchronized void leaveWrite()
/*     */     {
/* 134 */       if (this.numberOfWriters <= 0) {
/* 135 */         throw new Error("number of writers <= 0");
/*     */       }
/* 137 */       this.numberOfWriters -= 1;
/* 138 */       notifyAll();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.chat.utility.ReadWriteArrayList
 * JD-Core Version:    0.6.0
 */