/*     */ package org.jboss.remoting.samples.chat.server;
/*     */ 
/*     */ import java.awt.Container;
/*     */ import java.awt.Font;
/*     */ import java.awt.GridBagConstraints;
/*     */ import java.awt.GridBagLayout;
/*     */ import java.awt.Insets;
/*     */ import java.awt.event.ActionEvent;
/*     */ import java.io.PrintStream;
/*     */ import java.net.MalformedURLException;
/*     */ import javax.swing.JButton;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.samples.chat.client.CloseableFrame;
/*     */ import org.jboss.remoting.samples.chat.utility.Parameters;
/*     */ import org.jboss.remoting.transport.Connector;
/*     */ 
/*     */ public class ChatManagerLauncher extends CloseableFrame
/*     */ {
/*  28 */   protected static final Logger log = Logger.getLogger(ChatManagerLauncher.class);
/*     */   private static final int PORT = 1969;
/*     */   private ChatManager chatManager;
/*     */   private InvokerLocator managerLocator;
/*     */   private Connector managerConnector;
/*  35 */   private JButton launchButton = new JButton();
/*  36 */   private JButton shutDownButton = new JButton();
/*  37 */   private JButton exitButton = new JButton();
/*  38 */   private GridBagLayout gridBagLayout1 = new GridBagLayout();
/*     */ 
/*     */   public ChatManagerLauncher()
/*     */   {
/*     */     try
/*     */     {
/*  44 */       jbInit();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  48 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*  54 */     Parameters.initParameters(args);
/*  55 */     ChatManagerLauncher chatManagerLauncher = new ChatManagerLauncher();
/*     */   }
/*     */ 
/*     */   private void jbInit() throws Exception
/*     */   {
/*  60 */     this.launchButton.setFont(new Font("SansSerif", 1, 12));
/*  61 */     this.launchButton.setActionCommand("startButton");
/*  62 */     this.launchButton.setText("Launch");
/*  63 */     this.launchButton.addActionListener(new ChatManagerLauncher_launchButton_actionAdapter(this));
/*  64 */     getContentPane().setLayout(this.gridBagLayout1);
/*  65 */     this.shutDownButton.setFont(new Font("SansSerif", 1, 12));
/*  66 */     this.shutDownButton.setText("Shut down");
/*  67 */     this.shutDownButton.addActionListener(new ChatManagerLauncher_shutDownButton_actionAdapter(this));
/*  68 */     this.exitButton.setFont(new Font("SansSerif", 1, 12));
/*  69 */     this.exitButton.setText("Exit");
/*  70 */     this.exitButton.addActionListener(new ChatManagerLauncher_exitButton_actionAdapter(this));
/*  71 */     getContentPane().add(this.launchButton, new GridBagConstraints(0, 0, 1, 1, 0.0D, 0.0D, 10, 0, new Insets(188, 102, 0, 0), 0, 0));
/*     */ 
/*  75 */     getContentPane().add(this.shutDownButton, new GridBagConstraints(1, 0, 1, 1, 0.0D, 0.0D, 10, 0, new Insets(188, 23, 0, 103), 0, 0));
/*     */ 
/*  79 */     getContentPane().add(this.exitButton, new GridBagConstraints(0, 1, 2, 1, 0.0D, 0.0D, 10, 0, new Insets(23, 154, 39, 173), 0, 0));
/*     */ 
/*  84 */     center();
/*  85 */     pack();
/*  86 */     show();
/*     */   }
/*     */ 
/*     */   void launchButton_actionPerformed(ActionEvent ae)
/*     */   {
/*  91 */     String managerUriString = Parameters.getParameter("chatManagerUri");
/*     */     try
/*     */     {
/*  95 */       this.managerLocator = new InvokerLocator(managerUriString);
/*  96 */       log.info("ChatManagerLauncher: manager uri = " + managerUriString);
/*     */     }
/*     */     catch (MalformedURLException e)
/*     */     {
/* 100 */       log.error("ChatManagerLauncher(): invalid locator uri: " + managerUriString);
/* 101 */       e.printStackTrace();
/* 102 */       System.exit(-1);
/*     */     }
/*     */ 
/* 105 */     this.managerConnector = new Connector();
/*     */     try
/*     */     {
/* 109 */       this.managerConnector.setInvokerLocator(this.managerLocator.getLocatorURI());
/* 110 */       this.managerConnector.create();
/* 111 */       this.chatManager = new ChatManager();
/* 112 */       this.managerConnector.addInvocationHandler("chatManager", this.chatManager);
/* 113 */       this.managerConnector.start();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 117 */       log.error("Unable to start Connector for chat manager: " + e.getMessage());
/* 118 */       e.printStackTrace();
/*     */     }
/*     */ 
/* 121 */     log.info("ChatManagerLauncher: created chat manager");
/*     */   }
/*     */ 
/*     */   void shutDownButton_actionPerformed(ActionEvent ae)
/*     */   {
/* 126 */     if (this.chatManager == null)
/*     */     {
/* 128 */       System.out.println("ChatManagerLauncher: chat manager has not been launched");
/* 129 */       return;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 134 */       this.chatManager.shutdown();
/* 135 */       System.out.println("ChatManagerLauncher: shut down chatManager");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 139 */       System.out.println("ChatManagerLauncher: unable to shut down");
/* 140 */       return;
/*     */     }
/*     */ 
/* 144 */     System.out.println("ChatManagerLauncher: shut down web server");
/*     */   }
/*     */ 
/*     */   void exitButton_actionPerformed(ActionEvent e)
/*     */   {
/* 149 */     System.exit(0);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.chat.server.ChatManagerLauncher
 * JD-Core Version:    0.6.0
 */