/*     */ package org.jboss.remoting.samples.chat.client;
/*     */ 
/*     */ import java.awt.Color;
/*     */ import java.awt.Container;
/*     */ import java.awt.Font;
/*     */ import java.awt.GridBagConstraints;
/*     */ import java.awt.GridBagLayout;
/*     */ import java.awt.Insets;
/*     */ import java.awt.SystemColor;
/*     */ import java.awt.event.ActionEvent;
/*     */ import java.io.PrintStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import javax.swing.JButton;
/*     */ import javax.swing.JLabel;
/*     */ import javax.swing.JScrollPane;
/*     */ import javax.swing.JTextArea;
/*     */ import javax.swing.JTextField;
/*     */ import javax.swing.JViewport;
/*     */ import org.jboss.remoting.samples.chat.exceptions.TalkConnectionException;
/*     */ 
/*     */ public class TalkFrame extends CloseableFrame
/*     */ {
/*  38 */   JScrollPane jScrollPane1 = new JScrollPane();
/*  39 */   JButton closeButton = new JButton();
/*  40 */   JButton exitButton = new JButton();
/*  41 */   JTextArea backChatTextArea = new JTextArea();
/*  42 */   JTextField newMessage = new JTextField();
/*  43 */   JLabel talkLabel = new JLabel();
/*  44 */   GridBagLayout gridBagLayout1 = new GridBagLayout();
/*     */   private String description;
/*     */   private String nickname;
/*     */   private String[] backChat;
/*     */   private TalkConnectionStrategy tcs;
/*     */   private Font plainFont;
/*     */   private Font boldFont;
/*     */   private String chatKey;
/*  54 */   private static ArrayList talkWindows = new ArrayList();
/*     */ 
/*  56 */   public final boolean NEW_CHAT = true;
/*  57 */   public final boolean OLD_CHAT = false;
/*     */ 
/*     */   public TalkFrame(String description, String nickname, Closeable parent)
/*     */   {
/*  61 */     super(parent);
/*  62 */     this.description = description;
/*  63 */     this.nickname = nickname;
/*     */     try
/*     */     {
/*  66 */       jbInit();
/*     */     }
/*     */     catch (Exception e) {
/*  69 */       e.printStackTrace();
/*     */     }
/*     */ 
/*  72 */     this.plainFont = new Font("SanSerif", 0, 12);
/*  73 */     this.boldFont = new Font("SanSerif", 1, 12);
/*     */ 
/*  75 */     talkWindows.add(this);
/*     */   }
/*     */ 
/*     */   private void jbInit() throws Exception {
/*  79 */     getContentPane().setLayout(this.gridBagLayout1);
/*  80 */     this.closeButton.setFont(new Font("SansSerif", 1, 12));
/*  81 */     this.closeButton.setText("Close");
/*  82 */     this.closeButton.addActionListener(new TalkFrame_closeButton_actionAdapter(this));
/*  83 */     this.exitButton.setFont(new Font("SansSerif", 1, 12));
/*  84 */     this.exitButton.setText("Exit");
/*  85 */     this.exitButton.addActionListener(new TalkFrame_exitButton_actionAdapter(this));
/*  86 */     this.backChatTextArea.setFont(new Font("Monospaced", 0, 13));
/*  87 */     this.backChatTextArea.setDisabledTextColor(Color.white);
/*  88 */     this.backChatTextArea.setEditable(false);
/*  89 */     this.backChatTextArea.setText("");
/*  90 */     this.newMessage.setText("");
/*  91 */     this.newMessage.addActionListener(new TalkFrame_newMessage_actionAdapter(this));
/*  92 */     this.newMessage.requestFocus();
/*  93 */     this.talkLabel.setFont(new Font("SansSerif", 1, 12));
/*  94 */     this.talkLabel.setText("Talk:");
/*  95 */     this.jScrollPane1.setVerticalScrollBarPolicy(22);
/*  96 */     this.jScrollPane1.getViewport().setBackground(Color.white);
/*  97 */     this.jScrollPane1.setAutoscrolls(true);
/*  98 */     getContentPane().setBackground(SystemColor.control);
/*  99 */     getContentPane().add(this.closeButton, new GridBagConstraints(1, 2, 1, 1, 0.0D, 0.0D, 10, 0, new Insets(28, 204, 21, 0), 6, 0));
/*     */ 
/* 101 */     getContentPane().add(this.exitButton, new GridBagConstraints(2, 2, 1, 1, 0.0D, 0.0D, 10, 0, new Insets(28, 17, 21, 280), 18, 0));
/*     */ 
/* 103 */     getContentPane().add(this.jScrollPane1, new GridBagConstraints(1, 0, 2, 1, 1.0D, 1.0D, 10, 1, new Insets(10, 8, 0, 33), 602, 264));
/*     */ 
/* 105 */     getContentPane().add(this.talkLabel, new GridBagConstraints(0, 1, 1, 1, 0.0D, 0.0D, 17, 0, new Insets(34, 15, 0, 0), 7, -1));
/*     */ 
/* 107 */     getContentPane().add(this.newMessage, new GridBagConstraints(1, 1, 2, 1, 1.0D, 0.0D, 17, 2, new Insets(25, 10, 0, 33), 602, 6));
/*     */ 
/* 109 */     this.jScrollPane1.getViewport().add(this.backChatTextArea, null);
/*     */ 
/* 111 */     setTitle(this.description);
/*     */ 
/* 113 */     pack();
/* 114 */     center();
/*     */   }
/*     */ 
/*     */   public void registerStrategy(TalkConnectionStrategy tcs)
/*     */   {
/* 119 */     this.tcs = tcs;
/*     */   }
/*     */ 
/*     */   public void registerChatKey(String chatKey)
/*     */   {
/* 125 */     System.out.println("TalkFrame: registering chat key: " + chatKey);
/* 126 */     this.chatKey = chatKey;
/*     */   }
/*     */ 
/*     */   public void appendMessage(ChatMessage chatMessage)
/*     */   {
/* 132 */     String message = chatMessage.get_message();
/* 133 */     int mark = message.indexOf(':');
/* 134 */     int boundedMark = Math.max(0, mark);
/* 135 */     boundedMark = Math.min(8, boundedMark);
/* 136 */     String name = message.substring(0, boundedMark) + ":" + "        ".substring(0, 8 - boundedMark);
/* 137 */     String content = message.substring(mark + 1) + "\n";
/* 138 */     this.backChatTextArea.append(name + content);
/*     */   }
/*     */ 
/*     */   public void appendMessages(ArrayList messages)
/*     */   {
/* 153 */     for (int i = 0; i < messages.size(); i++)
/* 154 */       appendMessage((ChatMessage)messages.get(i));
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 161 */     String[] backChat = { "roger: take this", "mike: take that" };
/*     */ 
/* 164 */     TalkFrame talkFrame = new TalkFrame("dummy title", "h_brewski", null);
/*     */ 
/* 169 */     talkFrame.show();
/*     */   }
/*     */ 
/*     */   void close()
/*     */   {
/* 174 */     if (this.tcs == null)
/* 175 */       throw new Error("TalkFrame '" + this.description + "' close(): no TalkStrategy registered");
/*     */     try
/*     */     {
/* 178 */       this.tcs.leave();
/*     */     }
/*     */     catch (TalkConnectionException rce) {
/* 181 */       System.out.println("TalkFrame: unable to close");
/*     */     }
/*     */ 
/* 184 */     hide();
/* 185 */     System.out.println("member '" + this.nickname + "' is leaving chat room '" + this.description + "'");
/* 186 */     talkWindows.remove(this);
/* 187 */     notifyOnClose(this);
/*     */   }
/*     */ 
/*     */   void closeButton_actionPerformed(ActionEvent e)
/*     */   {
/* 192 */     close();
/*     */   }
/*     */ 
/*     */   public static void exit()
/*     */   {
/* 197 */     Iterator it = new ArrayList(talkWindows).iterator();
/* 198 */     while (it.hasNext())
/*     */     {
/* 200 */       ((TalkFrame)it.next()).close();
/*     */     }
/* 202 */     System.exit(0);
/*     */   }
/*     */ 
/*     */   void exitButton_actionPerformed(ActionEvent e)
/*     */   {
/* 207 */     exit();
/*     */   }
/*     */ 
/*     */   void newMessage_actionPerformed(ActionEvent e)
/*     */   {
/* 212 */     if (this.tcs == null)
/* 213 */       throw new Error("TalkFrame exit button: no TalkStrategy registered");
/*     */     try
/*     */     {
/* 216 */       this.tcs.send(new ChatMessage(this.chatKey, this.nickname + ": " + this.newMessage.getText()));
/*     */     }
/*     */     catch (TalkConnectionException rce) {
/* 219 */       System.out.println("TalkFrame: unable to send new chat line");
/*     */     }
/*     */ 
/* 222 */     this.newMessage.setText("");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.chat.client.TalkFrame
 * JD-Core Version:    0.6.0
 */