/*     */ package org.jboss.remoting.samples.chat.client;
/*     */ 
/*     */ import java.awt.Container;
/*     */ import java.awt.Font;
/*     */ import java.awt.GridBagConstraints;
/*     */ import java.awt.GridBagLayout;
/*     */ import java.awt.Insets;
/*     */ import java.awt.SystemColor;
/*     */ import java.awt.event.ActionEvent;
/*     */ import java.io.PrintStream;
/*     */ import java.util.Date;
/*     */ import java.util.Locale;
/*     */ import javax.swing.JButton;
/*     */ import javax.swing.JLabel;
/*     */ import javax.swing.JTextField;
/*     */ import org.jboss.remoting.samples.chat.exceptions.ConnectionException;
/*     */ import org.jboss.remoting.samples.chat.exceptions.InfoConnectionException;
/*     */ 
/*     */ public class InfoFrame extends CloseableFrame
/*     */   implements Closeable
/*     */ {
/*  34 */   JLabel jLabel1 = new JLabel();
/*  35 */   JLabel jLabel2 = new JLabel();
/*  36 */   JLabel jLabel3 = new JLabel();
/*  37 */   JTextField jTextField1 = new JTextField();
/*  38 */   JTextField jTextField2 = new JTextField();
/*  39 */   JTextField numberOfMessages = new JTextField();
/*  40 */   JButton joinButton = new JButton();
/*  41 */   JButton closeButton = new JButton();
/*  42 */   GridBagLayout gridBagLayout1 = new GridBagLayout();
/*     */   InfoConnectionStrategy ics;
/*     */   ChatInfo chatInfo;
/*     */ 
/*     */   public InfoFrame(InfoConnectionStrategy ics, ChatInfo chatInfo, Closeable parent)
/*     */   {
/*  52 */     super(parent);
/*  53 */     this.ics = ics;
/*  54 */     this.chatInfo = chatInfo;
/*     */     try
/*     */     {
/*  57 */       jbInit();
/*     */     }
/*     */     catch (Exception e) {
/*  60 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void jbInit() throws Exception
/*     */   {
/*  66 */     this.jLabel1.setFont(new Font("SansSerif", 1, 12));
/*  67 */     this.jLabel1.setText("Description:");
/*  68 */     getContentPane().setLayout(this.gridBagLayout1);
/*  69 */     this.jLabel2.setFont(new Font("SansSerif", 1, 12));
/*  70 */     this.jLabel2.setText("Current members:");
/*  71 */     this.jLabel3.setFont(new Font("SansSerif", 1, 12));
/*  72 */     this.jLabel3.setAlignmentX(0.0F);
/*  73 */     this.jLabel3.setText("Number of messages:");
/*  74 */     this.jTextField1.setEditable(false);
/*  75 */     this.jTextField1.setText(this.chatInfo.get_description());
/*  76 */     this.jTextField2.setEditable(false);
/*  77 */     this.jTextField2.setText(Integer.toString(this.chatInfo.get_currentMembers()));
/*  78 */     this.numberOfMessages.setEditable(false);
/*  79 */     this.numberOfMessages.setText(Integer.toString(this.chatInfo.get_size()));
/*  80 */     this.joinButton.setFont(new Font("SansSerif", 1, 12));
/*  81 */     this.joinButton.setText("Join");
/*  82 */     this.joinButton.addActionListener(new InfoFrame_joinButton_actionAdapter(this));
/*  83 */     this.closeButton.setFont(new Font("SansSerif", 1, 12));
/*  84 */     this.closeButton.setText("Close");
/*  85 */     this.closeButton.addActionListener(new InfoFrame_closeButton_actionAdapter(this));
/*  86 */     getContentPane().setBackground(SystemColor.control);
/*  87 */     setLocale(Locale.getDefault());
/*  88 */     setTitle("Chat room information");
/*  89 */     getContentPane().add(this.jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0D, 0.0D, 17, 0, new Insets(11, 43, 0, 0), 11, 2));
/*     */ 
/*  91 */     getContentPane().add(this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0D, 0.0D, 17, 0, new Insets(44, 43, 10, 40), 7, 2));
/*     */ 
/*  93 */     getContentPane().add(this.jLabel3, new GridBagConstraints(0, 2, 2, 1, 0.0D, 0.0D, 17, 0, new Insets(21, 43, 0, 0), 15, 2));
/*     */ 
/*  95 */     getContentPane().add(this.jTextField1, new GridBagConstraints(2, 0, 2, 1, 1.0D, 0.0D, 17, 2, new Insets(44, 0, 0, 38), 304, 7));
/*     */ 
/*  97 */     getContentPane().add(this.jTextField2, new GridBagConstraints(2, 1, 1, 1, 1.0D, 0.0D, 17, 2, new Insets(9, 0, 0, 0), 51, 0));
/*     */ 
/*  99 */     getContentPane().add(this.numberOfMessages, new GridBagConstraints(2, 2, 1, 1, 1.0D, 0.0D, 17, 2, new Insets(18, 0, 0, 0), 50, 0));
/*     */ 
/* 101 */     getContentPane().add(this.closeButton, new GridBagConstraints(3, 3, 1, 1, 0.0D, 0.0D, 10, 0, new Insets(0, 17, 50, 201), 6, 0));
/*     */ 
/* 103 */     getContentPane().add(this.joinButton, new GridBagConstraints(1, 3, 2, 1, 0.0D, 0.0D, 12, 0, new Insets(42, 0, 93, 8), 14, 0));
/*     */ 
/* 106 */     pack();
/* 107 */     center();
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*     */     try
/*     */     {
/* 114 */       Date gc = new Date();
/*     */ 
/* 116 */       ChatMember chatMember = new ChatMember();
/* 117 */       chatMember.set_name("jj");
/* 118 */       ChatInfo chatInfo = new ChatInfo();
/* 119 */       chatInfo.set_currentMembers(3);
/* 120 */       chatInfo.set_description("Black holes");
/* 121 */       chatInfo.set_origin(gc);
/*     */ 
/* 123 */       InfoFrame infoFrame = new InfoFrame(new DummyInfoConnectionStrategy(), chatInfo, null);
/*     */ 
/* 128 */       infoFrame.setDefaultCloseOperation(3);
/* 129 */       infoFrame.show();
/*     */     }
/*     */     catch (InfoConnectionException ce) {
/* 132 */       System.out.println("unable to create chat frame");
/*     */     }
/*     */   }
/*     */ 
/*     */   void joinButton_actionPerformed(ActionEvent e)
/*     */   {
/*     */     try {
/* 139 */       this.ics.getId(this.chatInfo);
/* 140 */       notifyOnClose(this);
/*     */     }
/*     */     catch (ConnectionException ce)
/*     */     {
/* 144 */       System.out.println("Join button catches exception:");
/* 145 */       System.out.println(ce);
/*     */     }
/*     */   }
/*     */ 
/*     */   void closeButton_actionPerformed(ActionEvent e) {
/* 150 */     notifyOnClose(this);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.chat.client.InfoFrame
 * JD-Core Version:    0.6.0
 */