/*     */ package org.jboss.remoting.samples.chat.client;
/*     */ 
/*     */ import java.awt.Container;
/*     */ import java.awt.Dimension;
/*     */ import java.awt.Font;
/*     */ import java.awt.GridBagConstraints;
/*     */ import java.awt.GridBagLayout;
/*     */ import java.awt.Insets;
/*     */ import java.awt.event.ActionEvent;
/*     */ import java.io.PrintStream;
/*     */ import java.util.Locale;
/*     */ import javax.swing.JButton;
/*     */ import javax.swing.JLabel;
/*     */ import javax.swing.JTextField;
/*     */ import org.jboss.remoting.samples.chat.exceptions.CreateConnectionException;
/*     */ 
/*     */ public class CreateFrame extends CloseableFrame
/*     */ {
/*  32 */   JLabel jDescriptionLabel = new JLabel();
/*  33 */   JLabel IDLabel = new JLabel();
/*  34 */   JTextField descriptionField = new JTextField();
/*  35 */   JTextField idField = new JTextField();
/*  36 */   JButton OKButton = new JButton();
/*  37 */   JButton CancelButton = new JButton();
/*  38 */   GridBagLayout gridBagLayout1 = new GridBagLayout();
/*     */   private CreateConnectionStrategy ccs;
/*     */ 
/*     */   public CreateFrame(CreateConnectionStrategy ccs, Closeable parent)
/*     */   {
/*  46 */     super(parent);
/*  47 */     this.ccs = ccs;
/*     */     try
/*     */     {
/*  50 */       jbInit();
/*     */     }
/*     */     catch (Exception e) {
/*  53 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void jbInit() throws Exception {
/*  58 */     this.jDescriptionLabel.setFont(new Font("SansSerif", 1, 12));
/*  59 */     this.jDescriptionLabel.setText("Description:");
/*  60 */     getContentPane().setLayout(this.gridBagLayout1);
/*  61 */     this.IDLabel.setFont(new Font("SansSerif", 1, 12));
/*  62 */     this.IDLabel.setText("Your ID:");
/*  63 */     this.descriptionField.setText("");
/*  64 */     this.idField.setText("");
/*  65 */     this.OKButton.setFont(new Font("SansSerif", 1, 14));
/*  66 */     this.OKButton.setText("OK");
/*  67 */     this.OKButton.addActionListener(new CreateFrame_OKButton_actionAdapter(this));
/*  68 */     this.CancelButton.setFont(new Font("SansSerif", 1, 14));
/*  69 */     this.CancelButton.setText("Cancel");
/*  70 */     this.CancelButton.addActionListener(new CreateFrame_CancelButton_actionAdapter(this));
/*  71 */     setLocale(Locale.getDefault());
/*  72 */     setResizable(false);
/*  73 */     setTitle("Create a chat room");
/*  74 */     setSize(new Dimension(0, 300));
/*  75 */     getContentPane().add(this.jDescriptionLabel, new GridBagConstraints(0, 0, 2, 1, 0.0D, 0.0D, 17, 0, new Insets(25, 21, 0, 0), 11, 4));
/*     */ 
/*  77 */     getContentPane().add(this.IDLabel, new GridBagConstraints(0, 1, 1, 1, 0.0D, 0.0D, 17, 0, new Insets(11, 21, 0, 0), 27, 0));
/*     */ 
/*  79 */     getContentPane().add(this.descriptionField, new GridBagConstraints(2, 0, 2, 1, 1.0D, 0.0D, 17, 2, new Insets(25, 0, 0, 16), 270, 1));
/*     */ 
/*  81 */     getContentPane().add(this.OKButton, new GridBagConstraints(1, 2, 2, 1, 0.0D, 0.0D, 10, 0, new Insets(81, 0, 115, 0), 30, -5));
/*     */ 
/*  83 */     getContentPane().add(this.CancelButton, new GridBagConstraints(3, 2, 1, 1, 0.0D, 0.0D, 10, 0, new Insets(81, 27, 115, 103), 11, -2));
/*     */ 
/*  85 */     getContentPane().add(this.idField, new GridBagConstraints(2, 1, 2, 1, 1.0D, 0.0D, 17, 2, new Insets(9, 0, 0, 22), 272, 2));
/*     */ 
/*  88 */     center();
/*  89 */     pack();
/*     */   }
/*     */ 
/*     */   void OKButton_actionPerformed(ActionEvent e)
/*     */   {
/*     */     try {
/*  95 */       notifyOnClose(this);
/*  96 */       ChatMember chatMember = new ChatMember();
/*  97 */       chatMember.set_name(this.idField.getText());
/*  98 */       this.ccs.createChat(this.descriptionField.getText(), chatMember);
/*     */     }
/*     */     catch (CreateConnectionException cce)
/*     */     {
/* 102 */       System.out.println("OK button catches exception:");
/* 103 */       System.out.println(cce);
/*     */     }
/*     */   }
/*     */ 
/*     */   void CancelButton_actionPerformed(ActionEvent e) {
/* 108 */     notifyOnClose(this);
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*     */     try
/*     */     {
/* 115 */       CreateFrame createFrame = new CreateFrame(new DummyCreateConnectionStrategy(), null);
/*     */ 
/* 119 */       createFrame.setDefaultCloseOperation(3);
/* 120 */       createFrame.show();
/*     */     }
/*     */     catch (CreateConnectionException ce)
/*     */     {
/* 124 */       System.out.println("unable to create create frame");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.chat.client.CreateFrame
 * JD-Core Version:    0.6.0
 */