/*    */ package org.jboss.remoting.samples.chat.client;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import org.jboss.remoting.callback.Callback;
/*    */ import org.jboss.remoting.callback.HandleCallbackException;
/*    */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*    */ import org.jboss.remoting.invocation.RemoteInvocation;
/*    */ 
/*    */ public class ChatReceiverHandler
/*    */   implements InvokerCallbackHandler
/*    */ {
/*    */   private TalkFrame talkFrame;
/*    */ 
/*    */   public ChatReceiverHandler(TalkFrame tf)
/*    */   {
/* 26 */     this.talkFrame = tf;
/*    */   }
/*    */ 
/*    */   public void handleCallback(Callback callback) throws HandleCallbackException
/*    */   {
/* 31 */     if (!(callback.getParameter() instanceof RemoteInvocation)) {
/* 32 */       throw new HandleCallbackException("invalid request format: expecting RemoteInvocation");
/*    */     }
/* 34 */     RemoteInvocation request = (RemoteInvocation)callback.getParameter();
/* 35 */     String methodName = request.getMethodName();
/* 36 */     Object[] args = request.getParameters();
/*    */ 
/* 38 */     if (methodName.equals("send")) {
/* 39 */       send(args);
/*    */     }
/* 41 */     else if (methodName.equals("sendMultiple")) {
/* 42 */       sendMultiple(args);
/*    */     }
/* 44 */     else if (methodName.equals("setKey")) {
/* 45 */       setKey(args);
/*    */     }
/* 47 */     else if (methodName.equals("shuttingDown")) {
/* 48 */       shuttingDown(args);
/*    */     }
/*    */     else
/* 51 */       throw new HandleCallbackException("unrecognized method name: " + methodName);
/*    */   }
/*    */ 
/*    */   protected void send(Object[] args)
/*    */   {
/* 57 */     ChatMessage mesg = (ChatMessage)args[0];
/* 58 */     this.talkFrame.appendMessage(mesg);
/*    */   }
/*    */ 
/*    */   protected void sendMultiple(Object[] args)
/*    */   {
/* 63 */     ArrayList messages = (ArrayList)args[0];
/* 64 */     this.talkFrame.appendMessages(messages);
/*    */   }
/*    */ 
/*    */   protected void setKey(Object[] args)
/*    */   {
/* 69 */     String key = (String)args[0];
/* 70 */     this.talkFrame.registerChatKey(key);
/*    */   }
/*    */ 
/*    */   protected void shuttingDown(Object[] args)
/*    */   {
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.remoting.samples.chat.client.ChatReceiverHandler
 * JD-Core Version:    0.6.0
 */